/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.Converter;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.SubscriberGroupsResource;
import com.tangosol.internal.management.resources.SubscribersResource;
import com.tangosol.internal.management.resources.TopicMembersResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.filter.AlwaysFilter;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class TopicResource
extends AbstractManagementResource {
    public static String[] CHILD_LINKS = new String[]{"members", "channels", "subscribers", "subscriberGroups"};

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addGet(sPathRoot + "/channels", this::getChannelsResponse);
        router.addPost(sPathRoot + "/disconnectAll", this::disconnectAll);
        router.addRoutes(sPathRoot + "/members", new TopicMembersResource());
        router.addRoutes(sPathRoot + "/subscriberGroups", new SubscriberGroupsResource());
        router.addRoutes(sPathRoot + "/subscribergroups", new SubscriberGroupsResource());
        router.addRoutes(sPathRoot + "/subscribers", new SubscribersResource());
    }

    public Response get(HttpRequest request) {
        String sTopicName = request.getFirstPathParameter("topicName");
        String sRoleName = request.getFirstQueryParameter("role");
        String sCollector = request.getFirstQueryParameter("collector");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sTopicName, sServiceName);
        Set<String> setObjectNames = this.ensureBeanAccessor(request).queryKeys(queryBuilder.build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        EntityMBeanResponse responseEntity = this.getResponseEntityForMbean(request, queryBuilder, this.getParentUri(request), this.getCurrentUri(request), this.getAttributesFilter(request), this.getLinksFilter(request), CHILD_LINKS);
        if (responseEntity == null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        this.addObjectNamesToResponse(request, setObjectNames, responseEntity);
        Map<String, Object> responseMap = responseEntity.toJson();
        this.addAggregatedMetricsToResponseMap(request, sRoleName, sCollector, queryBuilder, responseMap);
        return this.response(responseMap);
    }

    public Response disconnectAll(HttpRequest request) {
        String sTopicName = request.getFirstPathParameter("topicName");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sTopicName, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "disconnectAll", null, null);
    }

    public Response getChannelsResponse(HttpRequest request) {
        String sTopicName = request.getFirstPathParameter("topicName");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sTopicName, sServiceName);
        EntityMBeanResponse response = this.getResponseBodyForMBeanCollection(request, queryBuilder, Map.of("fields", List.of("channels", "nodeId")), this.getParentUri(request), this.getCurrentUri(request));
        return this.response(response);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        String sTopicName = MBeanHelper.safeUnquote(mapArguments.get("name"));
        URI uriSelf = TopicResource.getSubUri(uriParent, sTopicName);
        Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sTopicName, sServiceName);
        Set<String> setObjectNames = this.ensureBeanAccessor(request).queryKeys(queryBuilder.build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            return null;
        }
        EntityMBeanResponse response = this.getResponseEntityForMbean(request, queryBuilder, uriParent, uriSelf, this.getAttributesFilter(request), filterLinks, CHILD_LINKS);
        this.addObjectNamesToResponse(request, setObjectNames, response);
        Map<String, Object> mapEntity = response.getEntity();
        this.addAggregatedMetricsToResponseMap(request, "*", null, queryBuilder, mapEntity);
        return response;
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sTopicName, String sServiceName) {
        return this.createQueryBuilder(request).withBaseQuery(":type=PagedTopic,name=" + sTopicName).withService(sServiceName);
    }

    protected void addObjectNamesToResponse(HttpRequest request, Set<String> setObjectNames, EntityMBeanResponse responseEntity) {
        Filter<String> filterAttributes = this.getAttributesFilter(request);
        LinkedHashMap<String, Object> mapAttributes = new LinkedHashMap<String, Object>();
        if (filterAttributes instanceof AlwaysFilter) {
            filterAttributes = this.getAttributesFilter(String.join((CharSequence)",", "name", "service", "nodeId", "type"), null);
        }
        for (String sName : setObjectNames) {
            try {
                ObjectName objectName = new ObjectName(sName);
                for (String sKey : objectName.getKeyPropertyList().keySet()) {
                    if (!filterAttributes.evaluate(sKey)) continue;
                    Object oValue = Converter.convert(objectName.getKeyProperty(sKey));
                    Object oCurrent = mapAttributes.get(sKey);
                    if (oCurrent == null) {
                        mapAttributes.put(sKey, oValue);
                        continue;
                    }
                    if (oCurrent instanceof Set) {
                        ((Set)oCurrent).add(oValue);
                        continue;
                    }
                    if (Objects.equals(oCurrent, oValue)) continue;
                    HashSet<Object> values = new HashSet<Object>();
                    values.add(oCurrent);
                    values.add(oValue);
                    mapAttributes.put(sKey, values);
                }
            }
            catch (MalformedObjectNameException e) {
                Base.log("Exception occurred while creating an ObjectName " + sName + "\n" + Base.getStackTrace(e));
            }
        }
        responseEntity.setEntity(mapAttributes);
    }
}

