/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.SubscriberResource;
import com.tangosol.net.management.MBeanAccessor;
import java.net.URI;
import java.util.HashMap;

public class SubscribersResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addRoutes(sPathRoot + "/{id}", new SubscriberResource());
    }

    public Response get(HttpRequest request) {
        String sTopicName = request.getFirstPathParameter("topicName");
        String sGroupName = request.getFirstPathParameter("subscriberGroupName");
        String sSubType = request.getFirstQueryParameter("subType");
        String sBaseQuery = ":type=PagedTopicSubscriber,topic=" + sTopicName;
        if ("durable".equalsIgnoreCase(sSubType)) {
            sBaseQuery = sBaseQuery + ",subType=Durable";
        } else if ("anon".equalsIgnoreCase(sSubType) || "anonymous".equalsIgnoreCase(sSubType)) {
            sBaseQuery = sBaseQuery + ",subType=Anonymous";
        }
        if (sGroupName != null && !sGroupName.isBlank()) {
            sBaseQuery = sBaseQuery + ",group=" + sGroupName;
        }
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(sBaseQuery).withService(this.getService(request));
        URI uriCurrent = this.getCurrentUri(request);
        EntityMBeanResponse response = this.getResponseBodyForMBeanCollection(request, queryBuilder, new SubscriberResource(), "id", null, this.getParentUri(request), uriCurrent, uriCurrent, null);
        if (response == null && this.getService(request) != null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        return response == null ? this.response(new HashMap<String, Object>()) : this.response(response);
    }
}

