/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SubscriberResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addPost(sPathRoot + "/connect", this::connect);
        router.addPost(sPathRoot + "/disconnect", this::disconnect);
        router.addPost(sPathRoot + "/heads", this::heads);
        router.addPost(sPathRoot + "/notifyPopulated", this::notifyPopulated);
        router.addPost(sPathRoot + "/remainingMessages", this::remainingMessages);
    }

    public Response get(HttpRequest request) {
        String sSubscriberId = request.getFirstPathParameter("id");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sSubscriberId, sServiceName);
        return this.response(this.getResponseEntityForMbean(request, queryBuilder, new String[0]));
    }

    public Response connect(HttpRequest request) {
        String sSubscriberId = request.getFirstPathParameter("id");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sSubscriberId, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "connect", null, null);
    }

    public Response disconnect(HttpRequest request) {
        String sSubscriberId = request.getFirstPathParameter("id");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sSubscriberId, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "disconnect", null, null);
    }

    public Response heads(HttpRequest request) {
        String sSubscriberId = request.getFirstPathParameter("id");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sSubscriberId, sServiceName);
        return this.response(this.getResponseFromMBeanOperation(request, queryBuilder, "heads", "heads"));
    }

    public Response notifyPopulated(HttpRequest request) {
        String sSubscriberId = request.getFirstPathParameter("id");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        String channel = request.getFirstQueryParameter("channel");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sSubscriberId, sServiceName);
        try {
            return this.executeMBeanOperation(request, queryBuilder, "notifyPopulated", new Object[]{Integer.valueOf(channel)}, new String[]{Integer.class.getName()});
        }
        catch (NumberFormatException e) {
            return Response.status(Response.Status.BAD_REQUEST).entity(Collections.singletonMap("error", "Channel query parameter must be an integer.")).build();
        }
    }

    public Response remainingMessages(HttpRequest request) {
        String sSubscriberId = request.getFirstPathParameter("id");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sSubscriberId, sServiceName);
        return this.response(this.getResponseFromMBeanOperation(request, queryBuilder, "remainingMessages", "remainingMessages"));
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        String sSubscriber = mapArguments.get("id");
        URI uriSelf = SubscriberResource.getSubUri(uriParent, sSubscriber);
        Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sSubscriber, sServiceName);
        Set<String> setObjectNames = this.ensureBeanAccessor(request).queryKeys(queryBuilder.build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            return null;
        }
        Filter<String> filterAttributes = this.getAttributesFilter(request, mapQuery);
        return this.getResponseEntityForMbean(request, queryBuilder, uriParent, uriSelf, filterAttributes, filterLinks, new String[0]);
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sSubscriberId, String sServiceName) {
        return this.createQueryBuilder(request).withBaseQuery(":type=PagedTopicSubscriber,id=" + sSubscriberId).withService(sServiceName);
    }
}

