/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.SubscriberGroupMemberResource;
import com.tangosol.internal.management.resources.SubscribersResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import java.net.URI;
import java.util.Map;

public class SubscriberGroupResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addPost(sPathRoot + "/disconnectAll", this::disconnectAll);
        router.addRoutes(sPathRoot + "/{memberKey}", new SubscriberGroupMemberResource());
        router.addRoutes(sPathRoot + "/subscribers", new SubscribersResource());
    }

    public Response get(HttpRequest request) {
        String sTopicName = request.getFirstPathParameter("topicName");
        String sSubscriberGroupName = request.getFirstPathParameter("subscriberGroupName");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sTopicName, sSubscriberGroupName, sServiceName);
        return this.response(this.getResponseBodyForMBeanCollection(request, queryBuilder, new SubscriberGroupResource(), "nodeId", null, this.getParentUri(request), this.getCurrentUri(request), this.getCurrentUri(request), null));
    }

    public Response disconnectAll(HttpRequest request) {
        String sTopicName = request.getFirstPathParameter("topicName");
        String sSubscriberGroupName = request.getFirstPathParameter("subscriberGroupName");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sTopicName, sSubscriberGroupName, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "disconnectAll", null, null);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        String sTopicName = request.getFirstPathParameter("topicName");
        String sSubscriberGroupName = request.getFirstPathParameter("subscriberGroupName");
        String sNodeId = mapArguments.get("nodeId");
        URI uriSelf = SubscriberGroupResource.getSubUri(uriParent, sNodeId);
        Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(String.format(":type=PagedTopicSubscriberGroup,topic=%s,name=%s", sTopicName, sSubscriberGroupName)).withMember(sNodeId).withService(sServiceName);
        Filter<String> filterAttributes = this.getAttributesFilter(request, mapQuery);
        return this.getResponseEntityForMbean(request, queryBuilder, uriParent, uriSelf, filterAttributes, filterLinks, new String[0]);
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sTopicName, String sSubscriberGroupName, String sServiceName) {
        return this.createQueryBuilder(request).withBaseQuery(String.format(":type=PagedTopicSubscriberGroup,topic=%s,name=%s", sTopicName, sSubscriberGroupName)).withService(sServiceName);
    }
}

