/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.Converter;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import com.tangosol.util.filter.AlwaysFilter;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class StorageManagerResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addPost(sPathRoot + "/clear", this::clearCache);
        router.addPost(sPathRoot + "/truncate", this::truncateCache);
        router.addPost(sPathRoot + "/resetStatistics", this::resetStatistics);
        router.addGet(sPathRoot + "/reportPartitionStats", this::reportPartitionStats);
    }

    public Response get(HttpRequest request) {
        String sCacheName = request.getFirstPathParameter("cacheName");
        String sRoleName = request.getFirstQueryParameter("role");
        String sCollector = request.getFirstQueryParameter("collector");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sCacheName, sServiceName);
        Set<String> setObjectNames = this.ensureBeanAccessor(request).queryKeys(queryBuilder.build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        EntityMBeanResponse responseEntity = this.createResponse(request, this.getParentUri(request), this.getCurrentUri(request), this.getLinksFilter(request));
        this.addObjectNamesToResponse(request, setObjectNames, responseEntity);
        Map<String, Object> mapResponse = responseEntity.toJson();
        this.addAggregatedMetricsToResponseMap(request, sRoleName, sCollector, queryBuilder, mapResponse);
        return this.response(mapResponse);
    }

    public Response resetStatistics(HttpRequest request) {
        String sCacheName = request.getFirstPathParameter("cacheName");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sCacheName, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "resetStatistics", null, null);
    }

    public Response reportPartitionStats(HttpRequest request) {
        String sCacheName = request.getFirstPathParameter("cacheName");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sCacheName, sServiceName);
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{"native"};
        return this.response(this.getResponseFromMBeanOperation(request, queryBuilder, "reportPartitionStats", "reportPartitionStats", aoArguments, asSignature));
    }

    public Response clearCache(HttpRequest request) {
        String sCacheName = request.getFirstPathParameter("cacheName");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sCacheName, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "clearCache", null, null);
    }

    public Response truncateCache(HttpRequest request) {
        String sCacheName = request.getFirstPathParameter("cacheName");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sCacheName, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "truncateCache", null, null);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        String sCacheName = mapArguments.get("cache");
        URI uriSelf = StorageManagerResource.getSubUri(uriParent, sCacheName);
        Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sCacheName, sServiceName);
        Set<String> setObjectNames = this.ensureBeanAccessor(request).queryKeys(queryBuilder.build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            return null;
        }
        EntityMBeanResponse responseEntity = this.createResponse(request, uriParent, uriSelf, filterLinks);
        this.addObjectNamesToResponse(request, setObjectNames, responseEntity);
        Map<String, Object> mapEntity = responseEntity.getEntity();
        this.addAggregatedMetricsToResponseMap(request, "*", null, queryBuilder, mapEntity);
        return responseEntity;
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sCacheName, String sServiceName) {
        return this.createQueryBuilder(request).withBaseQuery(String.format(":type=StorageManager,cache=%s", sCacheName)).withService(sServiceName);
    }

    protected void addObjectNamesToResponse(HttpRequest request, Set<String> setObjectNames, EntityMBeanResponse responseEntity) {
        Filter<String> filterAttributes = this.getAttributesFilter(request);
        LinkedHashMap<String, Object> mapAttributes = new LinkedHashMap<String, Object>();
        if (filterAttributes instanceof AlwaysFilter) {
            filterAttributes = this.getAttributesFilter(String.join((CharSequence)",", "cache", "service", "nodeId"), null);
        }
        for (String sName : setObjectNames) {
            try {
                ObjectName objectName = new ObjectName(sName);
                for (String sKey : objectName.getKeyPropertyList().keySet()) {
                    if (!filterAttributes.evaluate(sKey)) continue;
                    Object oValue = Converter.convert(objectName.getKeyProperty(sKey));
                    Object oCurrent = mapAttributes.get(sKey);
                    if (oCurrent == null) {
                        mapAttributes.put(sKey, oValue);
                        continue;
                    }
                    if (oCurrent instanceof Set) {
                        ((Set)oCurrent).add(oValue);
                        continue;
                    }
                    if (Objects.equals(oCurrent, oValue)) continue;
                    HashSet<Object> values = new HashSet<Object>();
                    values.add(oCurrent);
                    values.add(oValue);
                    mapAttributes.put(sKey, values);
                }
            }
            catch (MalformedObjectNameException e) {
                CacheFactory.log("Exception occurred while creating an ObjectName " + sName + "\n" + CacheFactory.getStackTrace(e));
            }
        }
        responseEntity.setEntity(mapAttributes);
    }
}

