/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.http.HttpException;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.MBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.ServiceResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.management.ObjectName;

public class ServicesResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addGet(sPathRoot + "/members", this::getAllServiceMembers);
        router.addGet(sPathRoot + "/proxy/members", this::getAllProxyMembers);
        router.addPost(sPathRoot + "/persistence/snapshots/{snapshotName}", this::executeSnapshotOperationAllServices);
        router.addRoutes(sPathRoot + "/{serviceName}", new ServiceResource());
    }

    public Response get(HttpRequest request) {
        URI uriCurrent = this.getCurrentUri(request);
        EntityMBeanResponse response = this.getResponseBodyForMBeanCollection(request, this.getQuery(request), new ServiceResource(), "name", null, this.getParentUri(request), uriCurrent, uriCurrent, null);
        if (response == null && this.getService(request) != null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        return response == null ? this.response(new EntityMBeanResponse()) : this.response(response);
    }

    public Response getAllServiceMembers(HttpRequest request) {
        return this.response(this.getResponseBodyForMBeanCollection(request, this.getQuery(request), null, this.getParentUri(request), this.getCurrentUri(request)));
    }

    public Response getAllProxyMembers(HttpRequest request) {
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=ConnectionManager");
        return this.response(this.getResponseBodyForMBeanCollection(request, queryBuilder, null, this.getParentUri(request), this.getCurrentUri(request)));
    }

    public Response executeSnapshotOperationAllServices(HttpRequest request) {
        String sSnapshotName = request.getFirstPathParameter("snapshotName");
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        EntityMBeanResponse response = this.getResponseBodyForMBeanCollection(request, this.instantiatePersistentServicesQuery(request), null, this.getParentUri(request), this.getCurrentUri(request));
        List<Map<String, Object>> listEntities = response.getEntities();
        if (listEntities.isEmpty()) {
            Response.status(Response.Status.BAD_REQUEST).entity(response.toJson()).build();
        } else {
            for (Map<String, Object> entity : listEntities) {
                String sService = (String)entity.get("service");
                Response resp = this.executeMBeanOperation(request, this.instantiatePersistentServicesQuery(request, sService), "createSnapshot", aoArguments, asSignature);
                if (resp.getStatus().getStatusCode() == 200) continue;
                MBeanResponse mbeanResponse = new MBeanResponse(request);
                String sMsg = "Creation of a snapshot across all service failed for service " + sService + ".";
                mbeanResponse.addFailure(sMsg);
                mbeanResponse.addFailure(resp.getEntity().toString());
                return Response.status(resp.getStatus()).entity(mbeanResponse.toJson()).build();
            }
        }
        return Response.status(200).build();
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        try {
            Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
            URI uriSelf = ServicesResource.getSubUri(uriParent, "services");
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            EntityMBeanResponse responseEntity = this.createResponse(request, uriParent, uriSelf, filterLinks);
            Set<String> setObjectNames = accessor.queryKeys(this.getQuery(request).build());
            if (setObjectNames != null && !setObjectNames.isEmpty()) {
                Set<ObjectName> setObjNames = ServicesResource.convertToObjectNames(setObjectNames);
                ArrayList<Map<String, Object>> listServices = new ArrayList<Map<String, Object>>();
                Set setDomainPartitions = setObjNames.stream().map(o -> o.getKeyProperty("domainPartition")).collect(Collectors.toSet());
                for (String domainPartition : setDomainPartitions) {
                    listServices.addAll(this.getResponseForDomainPartition(request, mapQuery, uriSelf, uriCurrent, setObjNames, domainPartition));
                }
                responseEntity.setEntities(listServices);
            }
            return responseEntity;
        }
        catch (Exception e) {
            Logger.err("Exception occurred while getting response for an MBean collection for Services\n", (Throwable)e);
            throw new HttpException();
        }
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Service");
    }

    protected List<Map<String, Object>> getResponseForDomainPartition(HttpRequest request, Map<String, Object> mapQuery, URI uriSelf, URI uriCurrent, Set<ObjectName> setObjectNames, String sDomainPartition) {
        ArrayList<Map<String, Object>> listChildEntities = new ArrayList<Map<String, Object>>();
        Map<String, List<ObjectName>> mapMBeanToName = setObjectNames.stream().filter(this.matchesDomainPartition(sDomainPartition)).collect(Collectors.groupingBy(o -> o.getKeyProperty("name")));
        for (Map.Entry<String, List<ObjectName>> entry : mapMBeanToName.entrySet()) {
            ServiceResource resource = new ServiceResource();
            resource.setDomainPartitionFilter(this.createDomainPartitionPredicate(sDomainPartition));
            listChildEntities.add(((AbstractManagementResource)resource).getQueryResult(request, uriSelf, uriCurrent, mapQuery, Collections.singletonMap("name", entry.getKey())).toJson());
        }
        return listChildEntities;
    }

    protected Predicate<ObjectName> matchesDomainPartition(String domainPartition) {
        return o -> domainPartition == null ? o.getKeyProperty("domainPartition") == null : domainPartition.equals(o.getKeyProperty("domainPartition"));
    }

    public Filter<String> createDomainPartitionPredicate(String sDomainPartitionName) {
        return sDomainPartitionName == null ? Objects::isNull : s -> s.equals(sDomainPartitionName);
    }

    protected MBeanAccessor.QueryBuilder instantiatePersistentServicesQuery(HttpRequest request, String sService) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Persistence,responsibility=PersistenceCoordinator").withService(sService);
    }

    protected MBeanAccessor.QueryBuilder instantiatePersistentServicesQuery(HttpRequest request) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Persistence,responsibility=PersistenceCoordinator").exact(false);
    }
}

