/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.CachesResource;
import com.tangosol.internal.management.resources.PersistenceResource;
import com.tangosol.internal.management.resources.ServiceMembersResource;
import com.tangosol.internal.management.resources.StorageManagersResource;
import com.tangosol.internal.management.resources.TopicsResource;
import com.tangosol.internal.management.resources.ViewsResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Filter;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public class ServiceResource
extends AbstractManagementResource {
    public static final String SCHEDULED_DISTRIBUTIONS = "scheduledDistributions";
    public static String[] CHILD_LINKS = new String[]{"caches", "members", "partition", "federation", "topics", "storage", "views"};

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addGet(sPathRoot + "/partition", this::getPartitionAssignment);
        router.addGet(sPathRoot + "/partition/scheduledDistributions", this::getScheduledDistributions);
        router.addGet(sPathRoot + "/proxy", this::getAggregatedProxyMetricsResponse);
        router.addGet(sPathRoot + "/description", this::getServiceDescription);
        router.addPost(sPathRoot, this::update);
        router.addPost(sPathRoot + "/suspend", this::suspendService);
        router.addPost(sPathRoot + "/resume", this::resumeService);
        router.addPost(sPathRoot + "/resetStatistics", this::resetStatistics);
        router.addPost(sPathRoot + "/shutdown", this::shutdownService);
        router.addPost(sPathRoot + "/start", this::startService);
        router.addPost(sPathRoot + "/stop", this::stopService);
        router.addRoutes(sPathRoot + "/members", new ServiceMembersResource());
        router.addRoutes(sPathRoot + "/caches", new CachesResource());
        router.addRoutes(sPathRoot + "/persistence", new PersistenceResource());
        router.addRoutes(sPathRoot + "/topics", new TopicsResource());
        router.addRoutes(sPathRoot + "/storage", new StorageManagersResource());
        router.addRoutes(sPathRoot + "/views", new ViewsResource());
    }

    public Response get(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        String sRoleName = request.getFirstQueryParameter("role");
        String sCollector = request.getFirstQueryParameter("collector");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sServiceName);
        String sIncludeFields = "name,type,domainPartition";
        Filter<String> filterAttributes = this.getAttributesFilter(sIncludeFields, this.getExcludeList(request));
        EntityMBeanResponse response = this.getResponseEntityForMbean(request, queryBuilder, this.getParentUri(request), this.getCurrentUri(request), filterAttributes, this.getLinksFilter(request), CHILD_LINKS);
        if (response == null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        Map<String, Object> responseMap = response.toJson();
        this.addAggregatedMetricsToResponseMap(request, sRoleName, sCollector, queryBuilder, responseMap);
        return this.response(responseMap);
    }

    public Response getPartitionAssignment(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getPartitionAssignmentQuery(request, sServiceName);
        return this.response(this.getResponseEntityForMbean(request, queryBuilder, SCHEDULED_DISTRIBUTIONS));
    }

    public Response getScheduledDistributions(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        boolean fVerbose = Boolean.parseBoolean(request.getFirstQueryParameter("verbose"));
        String[] asSignature = new String[]{Boolean.TYPE.getName()};
        Object[] aoArguments = new Object[]{fVerbose};
        MBeanAccessor.QueryBuilder queryBuilder = this.getPartitionAssignmentQuery(request, sServiceName);
        return this.response(this.getResponseFromMBeanOperation(request, queryBuilder, SCHEDULED_DISTRIBUTIONS, "reportScheduledDistributions", aoArguments, asSignature));
    }

    public Response getAggregatedProxyMetricsResponse(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        String sRoleName = request.getFirstQueryParameter("role");
        String sCollector = request.getFirstQueryParameter("collector");
        EntityMBeanResponse responseEntity = this.getLinksOnlyResponseBody(request, this.getParentUri(request), this.getCurrentUri(request), new String[0]);
        Map<String, Object> responseMap = responseEntity.toJson();
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=ConnectionManager,name=" + sServiceName);
        this.addAggregatedMetricsToResponseMap(request, sRoleName, sCollector, queryBuilder, responseMap);
        return this.response(responseMap);
    }

    public Response getServiceDescription(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sServiceName);
        return this.response(this.getResponseFromMBeanOperation(request, queryBuilder, "description", "getServiceDescription"));
    }

    public Response update(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        Map<String, Object> entity = this.getJsonBody(request);
        return this.update(request, entity, this.getQuery(request, sServiceName));
    }

    public Response suspendService(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=Cluster");
        return this.executeMBeanOperation(request, queryBuilder, "suspendService", new Object[]{sServiceName}, new String[]{String.class.getName()});
    }

    public Response resumeService(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=Cluster");
        return this.executeMBeanOperation(request, queryBuilder, "resumeService", new Object[]{sServiceName}, new String[]{String.class.getName()});
    }

    public Response resetStatistics(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "resetStatistics", null, null);
    }

    public Response shutdownService(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "shutdown", new Object[]{sServiceName}, new String[]{String.class.getName()});
    }

    public Response startService(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "start", null, null);
    }

    public Response stopService(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "stop", null, null);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        Filter<String> filterAttributes;
        String sServiceName = MBeanHelper.safeUnquote(mapArguments.get("name"));
        URI uriSelf = ServiceResource.getSubUri(uriParent, sServiceName);
        Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sServiceName);
        EntityMBeanResponse response = this.getResponseEntityForMbean(request, queryBuilder, uriParent, uriSelf, filterAttributes = this.getAttributesFilter("name,type,domainPartition", this.getExcludeList(request, mapQuery)), filterLinks, CHILD_LINKS);
        if (response != null) {
            Object oChildren = this.getChildrenQuery(mapQuery);
            Map<String, Object> mapEntity = response.getEntity();
            this.addAggregatedMetricsToResponseMap(request, "*", null, queryBuilder, mapEntity);
            if (oChildren instanceof Map) {
                Map mapChildrenQuery = (Map)oChildren;
                queryBuilder = this.getQuery(request, sServiceName);
                this.addChildMbeanQueryResult(request, uriParent, uriCurrent, "partition", queryBuilder, mapEntity, mapChildrenQuery, new String[0]);
                mapArguments = Collections.singletonMap("serviceName", sServiceName);
                this.addChildResourceQueryResult(request, new ServiceMembersResource(), "members", mapEntity, mapChildrenQuery, mapArguments);
                this.addChildResourceQueryResult(request, new CachesResource(), "caches", mapEntity, mapChildrenQuery, mapArguments);
                this.addChildResourceQueryResult(request, new PersistenceResource(), "persistence", mapEntity, mapChildrenQuery, mapArguments);
                this.addChildResourceQueryResult(request, new TopicsResource(), "topics", mapEntity, mapChildrenQuery, mapArguments);
                this.addChildResourceQueryResult(request, new ViewsResource(), "views", mapEntity, mapChildrenQuery, mapArguments);
            }
        }
        return response;
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sServiceName) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Service,name=" + sServiceName);
    }

    protected MBeanAccessor.QueryBuilder getPartitionAssignmentQuery(HttpRequest request, String sServiceName) {
        return this.createQueryBuilder(request).withBaseQuery(":type=PartitionAssignment").withService(sServiceName);
    }
}

