/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.net.management.MBeanAccessor;
import java.net.URI;
import java.util.Map;

public class ServiceMemberResource
extends AbstractManagementResource {
    public static final String DISTRIBUTION_STATE = "distributionState";
    public static final String OWNERSHIP = "ownership";
    public static final String[] LINKS = new String[]{"proxy", "distributionState", "ownership"};

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addGet(sPathRoot + "/proxy", this::getProxy);
        router.addGet(sPathRoot + "/proxy/connections", this::getProxyConnections);
        router.addGet(sPathRoot + "/distributionState", this::getDistributionState);
        router.addGet(sPathRoot + "/ownership", this::getOwnership);
        router.addPost(sPathRoot, this::updateAttributes);
        router.addPost(sPathRoot + "/resetStatistics", this::resetStatistics);
        router.addPost(sPathRoot + "/proxy/resetStatistics", this::resetStatisticsProxy);
        router.addPost(sPathRoot + "/start", this::start);
        router.addPost(sPathRoot + "/stop", this::stop);
        router.addPost(sPathRoot + "/shutdown", this::shutdown);
    }

    public Response get(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        String sMemberKey = request.getFirstPathParameter("memberKey");
        return this.response(this.getResponseEntityForMbean(request, this.getQuery(request, sServiceName, sMemberKey), LINKS));
    }

    public Response getProxy(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        String sMemberKey = request.getFirstPathParameter("memberKey");
        MBeanAccessor.QueryBuilder queryBuilder = this.getConnectionManagerQuery(request, sServiceName, sMemberKey);
        return this.response(this.getResponseEntityForMbean(request, queryBuilder, "connections"));
    }

    public Response getProxyConnections(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        String sMemberKey = request.getFirstPathParameter("memberKey");
        MBeanAccessor.QueryBuilder queryBuilder = this.getConnectionsQuery(request, sServiceName, sMemberKey);
        return this.response(this.getResponseBodyForMBeanCollection(request, queryBuilder, null, this.getParentUri(request), this.getCurrentUri(request)).toJson());
    }

    public Response getDistributionState(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        String sMemberKey = request.getFirstPathParameter("memberKey");
        boolean verbose = Boolean.parseBoolean(request.getFirstQueryParameter("verbose"));
        String[] asSignature = new String[]{Boolean.TYPE.getName()};
        Object[] aoArguments = new Object[]{verbose};
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sServiceName, sMemberKey);
        return this.response(this.getResponseFromMBeanOperation(request, queryBuilder, DISTRIBUTION_STATE, "reportDistributionState", aoArguments, asSignature));
    }

    public Response getOwnership(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        String sMemberKey = request.getFirstPathParameter("memberKey");
        boolean verbose = Boolean.parseBoolean(request.getFirstQueryParameter("verbose"));
        String[] asSignature = new String[]{Boolean.TYPE.getName()};
        Object[] aoArguments = new Object[]{verbose};
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sServiceName, sMemberKey);
        return this.response(this.getResponseFromMBeanOperation(request, queryBuilder, OWNERSHIP, "reportOwnership", aoArguments, asSignature));
    }

    public Response resetStatistics(HttpRequest request) {
        return this.executeNoArgOperation(request, "resetStatistics");
    }

    public Response resetStatisticsProxy(HttpRequest request) {
        return this.executeNoArgOperationProxy(request, "resetStatistics");
    }

    public Response start(HttpRequest request) {
        return this.executeNoArgOperation(request, "start");
    }

    public Response stop(HttpRequest request) {
        return this.executeNoArgOperation(request, "stop");
    }

    public Response shutdown(HttpRequest request) {
        return this.executeNoArgOperation(request, "shutdown");
    }

    public Response executeNoArgOperation(HttpRequest request, String sOperationName) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        String sMemberKey = request.getFirstPathParameter("memberKey");
        return this.executeMBeanOperation(request, this.getQuery(request, sServiceName, sMemberKey), sOperationName, null, null);
    }

    public Response executeNoArgOperationProxy(HttpRequest request, String sOperationName) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        String sMemberKey = request.getFirstPathParameter("memberKey");
        return this.executeMBeanOperation(request, this.getConnectionManagerQuery(request, sServiceName, sMemberKey), sOperationName, null, null);
    }

    public Response updateAttributes(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter("serviceName");
        String sMemberKey = request.getFirstPathParameter("memberKey");
        Map<String, Object> entity = this.getJsonBody(request);
        return this.update(request, entity, this.getQuery(request, sServiceName, sMemberKey));
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        Object oChildren;
        String sMemberId = mapArguments.get("memberKey");
        String sServiceName = mapArguments.get("name");
        URI uriSelf = ServiceMemberResource.getSubUri(uriParent, sMemberId);
        EntityMBeanResponse response = this.getLinksOnlyResponseBody(request, uriParent, uriSelf, this.getLinksFilter(request, mapQuery), LINKS);
        Map<String, Object> mapResponse = response.getEntity();
        Object object = oChildren = mapQuery == null ? null : mapQuery.get("children");
        if (oChildren instanceof Map) {
            MBeanAccessor.QueryBuilder queryBuilder = this.getConnectionManagerQuery(request, sServiceName, sMemberId);
            this.addChildMbeanQueryResult(request, uriParent, uriCurrent, "proxy", queryBuilder, mapResponse, (Map)oChildren, "connections");
        }
        return response;
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sServiceName, String sMemberKey) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Service,name=" + sServiceName).withMember(sMemberKey);
    }

    protected MBeanAccessor.QueryBuilder getConnectionManagerQuery(HttpRequest request, String sServiceName, String sMemberKey) {
        return this.createQueryBuilder(request).withBaseQuery(":type=ConnectionManager,name=" + sServiceName).withMember(sMemberKey);
    }

    protected MBeanAccessor.QueryBuilder getConnectionsQuery(HttpRequest request, String sServiceName, String sMemberKey) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Connection,name=" + sServiceName).withMember(sMemberKey);
    }
}

