/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import java.net.URI;
import java.util.Map;

public class PersistenceResource
extends AbstractManagementResource {
    public static String[] LINKS = new String[]{"snapshots", "archives"};

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addGet(sPathRoot + "/snapshots", this::getSnapshots);
        router.addGet(sPathRoot + "/archives", this::getArchives);
        router.addGet(sPathRoot + "/archiveStores/{snapshotName}", this::getArchiveStores);
        router.addPost(sPathRoot + "/forceRecovery", this::forceRecovery);
        router.addPost(sPathRoot + "/snapshots/{snapshotName}", this::createSnapshot);
        router.addPost(sPathRoot + "/snapshots/{snapshotName}/recover", this::recoverSnapshot);
        router.addPost(sPathRoot + "/archives/{snapshotName}", this::archiveSnapshot);
        router.addPost(sPathRoot + "/archives/{snapshotName}/retrieve", this::retrieveArchivedSnapshot);
        router.addDelete(sPathRoot + "/snapshots/{snapshotName}", this::deleteSnapshot);
        router.addDelete(sPathRoot + "/archives/{snapshotName}", this::deleteArchive);
    }

    public Response get(HttpRequest request) {
        return this.response(this.getResponseEntityForMbean(request, this.getQuery(request), LINKS));
    }

    public Response getSnapshots(HttpRequest request) {
        Filter<String> filterAttributes = this.getAttributesFilter("snapshots", this.getExcludeList(request));
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request);
        return this.response(this.getResponseEntityForMbean(request, queryBuilder, this.getParentUri(request), this.getCurrentUri(request), filterAttributes, this.getLinksFilter(request), new String[0]));
    }

    public Response getArchives(HttpRequest request) {
        return this.response(this.getResponseFromMBeanOperation(request, this.getQuery(request), "archives", "listArchivedSnapshots"));
    }

    public Response getArchiveStores(HttpRequest request) {
        String sSnapshotName = request.getFirstPathParameter("snapshotName");
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.response(this.getResponseFromMBeanOperation(request, this.getQuery(request), "archiveStores", "listArchivedSnapshotStores", aoArguments, asSignature));
    }

    public Response forceRecovery(HttpRequest request) {
        return this.executeMBeanOperation(request, this.getQuery(request), "forceRecovery", null, null);
    }

    public Response createSnapshot(HttpRequest request) {
        String sSnapshotName = request.getFirstPathParameter("snapshotName");
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(request, this.getQuery(request), "createSnapshot", aoArguments, asSignature);
    }

    public Response recoverSnapshot(HttpRequest request) {
        String sSnapshotName = request.getFirstPathParameter("snapshotName");
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(request, this.getQuery(request), "recoverSnapshot", aoArguments, asSignature);
    }

    public Response archiveSnapshot(HttpRequest request) {
        String sSnapshotName = request.getFirstPathParameter("snapshotName");
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(request, this.getQuery(request), "archiveSnapshot", aoArguments, asSignature);
    }

    public Response retrieveArchivedSnapshot(HttpRequest request) {
        String sSnapshotName = request.getFirstPathParameter("snapshotName");
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(request, this.getQuery(request), "retrieveArchivedSnapshot", aoArguments, asSignature);
    }

    public Response deleteSnapshot(HttpRequest request) {
        String sSnapshotName = request.getFirstPathParameter("snapshotName");
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        Logger.info("PersistenceResource.DELETE, snapshot: " + sSnapshotName);
        return this.executeMBeanOperation(request, this.getQuery(request), "removeSnapshot", aoArguments, asSignature);
    }

    public Response deleteArchive(HttpRequest request) {
        String sSnapshotName = request.getFirstPathParameter("snapshotName");
        String[] asSignature = new String[]{String.class.getName()};
        Object[] aoArguments = new Object[]{sSnapshotName};
        return this.executeMBeanOperation(request, this.getQuery(request), "removeArchivedSnapshot", aoArguments, asSignature);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        URI uriSelf = PersistenceResource.getSubUri(uriParent, "persistence");
        return this.getResponseEntityForMbean(request, this.getQuery(request), uriParent, uriSelf, mapQuery, LINKS);
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Persistence,responsibility=PersistenceCoordinator").withService(this.getService(request));
    }
}

