/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.JournalMembersResource;
import com.tangosol.net.management.MBeanAccessor;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public class JournalResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addPost(sPathRoot + "/compact", this::compact);
        router.addPost(sPathRoot + "/resetStatistics", this::resetStatistics);
        router.addRoutes(sPathRoot + "/members", new JournalMembersResource());
    }

    public Response get(HttpRequest request) {
        String sJournalType = request.getFirstPathParameter("journalType");
        String sRoleName = request.getFirstQueryParameter("role");
        String sCollector = request.getFirstQueryParameter("collector");
        EntityMBeanResponse response = this.getLinksOnlyResponseBody(request, this.getParentUri(request), this.getCurrentUri(request), "members");
        Map<String, Object> responseMap = response.toJson();
        this.addAggregatedMetricsToResponseMap(request, sRoleName, sCollector, this.getQuery(request, sJournalType), responseMap);
        return this.response(responseMap);
    }

    public Response compact(HttpRequest request) {
        String sJournalType = request.getFirstPathParameter("journalType");
        Map<String, Object> entity = this.getJsonBody(request);
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sJournalType);
        Object oRegular = entity == null ? null : entity.get("regular");
        boolean fRegular = oRegular != null && Boolean.parseBoolean(oRegular.toString());
        return this.executeMBeanOperation(request, queryBuilder, "compact", new Object[]{fRegular}, new String[]{Boolean.TYPE.getName()});
    }

    public Response resetStatistics(HttpRequest request) {
        String sJournalType = request.getFirstPathParameter("journalType");
        return this.executeMBeanOperation(request, this.getQuery(request, sJournalType), "resetStatistics", null, null);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        Object oChildren = this.getChildrenQuery(mapQuery);
        if (oChildren instanceof Map) {
            LinkedHashMap<String, Object> mapResponse = new LinkedHashMap<String, Object>();
            Map mapChildrenQuery = (Map)oChildren;
            this.addChildResourceQueryResult(request, new JournalMembersResource(), "members", mapResponse, mapChildrenQuery, mapArguments);
            EntityMBeanResponse responseEntity = new EntityMBeanResponse();
            responseEntity.setEntity(mapResponse);
            return responseEntity;
        }
        return null;
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sJournalType) {
        return this.createQueryBuilder(request).withBaseQuery((String)MAP_JOURNAL_URL_TO_MBEAN_QUERY.get(sJournalType));
    }
}

