/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.net.management.MBeanAccessor;
import java.net.URI;
import java.util.Map;

public class JournalMemberResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addPost(sPathRoot + "/compact", this::compact);
        router.addPost(sPathRoot + "/resetStatistics", this::resetStatistics);
    }

    public Response get(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        String sJournalType = request.getFirstPathParameter("journalType");
        return this.response(this.getResponseEntityForMbean(request, this.getQuery(request, sMemberKey, sJournalType), new String[0]));
    }

    public Response compact(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        String sJournalType = request.getFirstPathParameter("journalType");
        Map<String, Object> entity = this.getJsonBody(request);
        Object oRegular = entity == null ? null : entity.get("regular");
        boolean fRegular = oRegular != null && Boolean.parseBoolean(oRegular.toString());
        return this.executeMBeanOperation(request, this.getQuery(request, sMemberKey, sJournalType), "compact", new Object[]{fRegular}, new String[]{Boolean.TYPE.getName()});
    }

    public Response resetStatistics(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        String sJournalType = request.getFirstPathParameter("journalType");
        return this.executeMBeanOperation(request, this.getQuery(request, sMemberKey, sJournalType), "resetStatistics", null, null);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        return this.getLinksOnlyResponseBody(request, uriParent, JournalMemberResource.getSubUri(uriParent, mapArguments.get("memberKey")), new String[0]);
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sMemberKey, String sJournalType) {
        return this.createQueryBuilder(request).withBaseQuery((String)MAP_JOURNAL_URL_TO_MBEAN_QUERY.get(sJournalType)).withMember(sMemberKey);
    }
}

