/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.HealthMembersResource;
import com.tangosol.internal.management.resources.HealthResource;
import com.tangosol.net.management.MBeanAccessor;
import java.net.URI;
import java.util.Map;

public class HealthsResource
extends AbstractManagementResource {
    private final HealthResource f_healthResource = new HealthResource();

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addGet(sPathRoot + "/ready", this::ready);
        router.addGet(sPathRoot + "/live", this::live);
        router.addGet(sPathRoot + "/started", this::started);
        router.addGet(sPathRoot + "/safe", this::safe);
        router.addRoutes(sPathRoot + "/members", new HealthMembersResource());
        router.addRoutes(sPathRoot + "/{name}", this.f_healthResource);
    }

    public Response get(HttpRequest request) {
        URI uriCurrent = this.getCurrentUri(request);
        EntityMBeanResponse mBeanResponse = this.getResponseBodyForMBeanCollection(request, this.getQuery(request), this.f_healthResource, "name", null, this.getParentUri(request), uriCurrent, uriCurrent, null);
        if (mBeanResponse == null && this.getService(request) != null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        if (mBeanResponse == null) {
            return this.response(new EntityMBeanResponse());
        }
        mBeanResponse.addResourceLink("members", HealthsResource.getSubUri(uriCurrent, "members"));
        return this.response(mBeanResponse);
    }

    public Response ready(HttpRequest request) {
        return this.handle(request, "Ready");
    }

    public Response live(HttpRequest request) {
        return this.handle(request, "Live");
    }

    public Response started(HttpRequest request) {
        return this.handle(request, "Started");
    }

    public Response safe(HttpRequest request) {
        return this.handle(request, "Safe");
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Health");
    }

    protected Response handle(HttpRequest request, String sAttribute) {
        try {
            MBeanAccessor.QueryBuilder.ParsedQuery query = this.getQuery(request).build();
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            Map<String, Map<String, Object>> map = accessor.getAttributes(query);
            boolean fOK = map.values().stream().map(m -> m.get(sAttribute)).allMatch(Boolean.class::cast);
            return fOK ? Response.ok().build() : Response.status(503).build();
        }
        catch (Throwable t) {
            Logger.err("HealthsResource failed to handle request \"" + sAttribute + "\": " + t.getMessage());
            return Response.serverError().build();
        }
    }
}

