/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.HealthMembersResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.filter.AlwaysFilter;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public class HealthResource
extends AbstractManagementResource {
    public static String[] CHILD_LINKS = new String[]{"members"};

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addRoutes(sPathRoot + "/members", new HealthMembersResource());
    }

    public Response get(HttpRequest request) {
        String sRoleName = request.getFirstQueryParameter("role");
        String sCollector = request.getFirstQueryParameter("collector");
        MBeanAccessor.QueryBuilder queryBuilder = this.createHealthQueryBuilder(request);
        EntityMBeanResponse response = this.getResponseEntityForMbean(request, queryBuilder, this.getParentUri(request), this.getCurrentUri(request), AlwaysFilter.INSTANCE(), this.getLinksFilter(request), new String[0]);
        if (response == null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        Map<String, Object> responseMap = response.toJson();
        this.addAggregatedMetricsToResponseMap(request, sRoleName, sCollector, queryBuilder, responseMap);
        return this.response(responseMap);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        String sName = MBeanHelper.safeUnquote(mapArguments.get("name"));
        String sSubType = mapArguments.get("subType");
        String sRoleName = request.getFirstQueryParameter("role");
        String sCollector = request.getFirstQueryParameter("collector");
        URI uriSelf = HealthResource.getSubUri(uriParent, sName);
        Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
        MBeanAccessor.QueryBuilder queryBuilder = this.createHealthQueryBuilder(request, sSubType, sName);
        EntityMBeanResponse responseEntity = this.getResponseEntityForMbean(request, queryBuilder, uriParent, uriSelf, AlwaysFilter.INSTANCE(), filterLinks, CHILD_LINKS);
        if (responseEntity != null) {
            Object oChildren = this.getChildrenQuery(mapQuery);
            Map<String, Object> mapEntity = responseEntity.getEntity();
            this.addAggregatedMetricsToResponseMap(request, sRoleName, sCollector, queryBuilder, mapEntity);
            if (oChildren instanceof Map) {
                Map mapChildrenQuery = (Map)oChildren;
                queryBuilder = this.createHealthQueryBuilder(request, sSubType, sName);
                this.addChildMbeanQueryResult(request, uriParent, uriCurrent, "name", queryBuilder, mapEntity, mapChildrenQuery, new String[0]);
                mapArguments = Collections.singletonMap("name", sName);
                this.addChildResourceQueryResult(request, new HealthMembersResource(), "members", mapEntity, mapChildrenQuery, mapArguments);
            }
        }
        return responseEntity;
    }
}

