/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.net.management.MBeanAccessor;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class HealthMemberResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
    }

    public Response get(HttpRequest request) {
        Response response = this.response(this.getResponseBodyForMBeanCollection(request, this.getQuery(request), null, this.getParentUri(request), this.getCurrentUri(request)));
        return response == null ? this.response(new HashMap<String, Object>()) : response;
    }

    public Response ready(HttpRequest request, int nNodeId) {
        return this.handle(request, "Ready", nNodeId);
    }

    public Response live(HttpRequest request, int nNodeId) {
        return this.handle(request, "Live", nNodeId);
    }

    public Response started(HttpRequest request, int nNodeId) {
        return this.handle(request, "Started", nNodeId);
    }

    public Response safe(HttpRequest request, int nNodeId) {
        return this.handle(request, "Safe", nNodeId);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        String sNodeId = mapArguments.get("memberKey");
        URI uriSelf = HealthMemberResource.getSubUri(uriParent, sNodeId);
        return this.getLinksOnlyResponseBody(request, uriParent, uriSelf, this.getLinksFilter(request, mapQuery), new String[0]);
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request) {
        String sNodeId = request.getFirstPathParameter("memberKey");
        return this.createHealthQueryBuilder(request).withMember(sNodeId);
    }

    protected Response handle(HttpRequest request, String sAttribute, int nNodeId) {
        MBeanAccessor.QueryBuilder.ParsedQuery query = this.createHealthQueryBuilder(request).withMember(String.valueOf(nNodeId)).build();
        MBeanAccessor accessor = this.ensureBeanAccessor(request);
        Map<String, Map<String, Object>> map = accessor.getAttributes(query);
        boolean fOK = true;
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            Object o;
            Boolean fEnabled = (Boolean)entry.getValue().get("MemberHealthCheck");
            if (fEnabled != null && !fEnabled.booleanValue() || !((o = entry.getValue().get(sAttribute)) instanceof Boolean) || ((Boolean)o).booleanValue()) continue;
            fOK = false;
            Logger.warn("Health: " + sAttribute + " check failed for health check " + entry.getKey());
        }
        return fOK ? Response.ok().build() : Response.status(503).build();
    }
}

