/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.ExecutorMembersResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import java.net.URI;
import java.util.Map;

public class ExecutorResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addPost(sPathRoot, this::update);
        router.addPost(sPathRoot + "/resetStatistics", this::resetStatistics);
        router.addRoutes(sPathRoot + "/members", new ExecutorMembersResource());
    }

    public Response get(HttpRequest request) {
        String sName = request.getFirstPathParameter("name");
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=Executor,name=" + sName);
        EntityMBeanResponse responseEntity = this.createResponse(request, this.getParentUri(request), this.getCurrentUri(request), this.getLinksFilter(request));
        Map<String, Object> mapResponse = responseEntity.toJson();
        this.addAggregatedMetricsToResponseMap(request, "*", null, queryBuilder, mapResponse);
        return this.response(mapResponse);
    }

    public Response update(HttpRequest request) {
        String sName = request.getFirstPathParameter("name");
        Map<String, Object> entity = this.getJsonBody(request);
        return this.update(request, entity, this.getQuery(request, sName));
    }

    public Response resetStatistics(HttpRequest request) {
        String sName = request.getFirstPathParameter("name");
        return this.executeMBeanOperation(request, this.getQuery(request, sName), "resetStatistics", null, null);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        Object oChildren;
        String sName = mapArguments.get("name");
        URI uriSelf = ExecutorResource.getSubUri(uriParent, sName);
        Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
        EntityMBeanResponse responseEntity = this.createResponse(request, uriParent, uriSelf, filterLinks);
        Map<String, Object> mapEntity = responseEntity.getEntity();
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=Executor,name=" + sName);
        this.addAggregatedMetricsToResponseMap(request, "*", null, queryBuilder, mapEntity);
        Object object = oChildren = mapQuery == null ? null : mapQuery.get("children");
        if (oChildren instanceof Map) {
            Map mapChildrenQuery = (Map)oChildren;
            this.addChildResourceQueryResult(request, new ExecutorMembersResource(), "members", mapEntity, mapChildrenQuery, mapArguments);
        }
        return responseEntity;
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sName) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Executor,name=" + sName);
    }
}

