/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.ClusterResource;
import com.tangosol.util.BuilderHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ClustersResource
extends AbstractManagementResource {
    private final Supplier<Set<String>> f_supplierClusters;
    private final ClusterResource f_clusterResource;

    public ClustersResource(Supplier<Set<String>> supplierClusters) {
        this.f_supplierClusters = supplierClusters;
        this.f_clusterResource = new ClusterResource();
    }

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addPost(sPathRoot + "/search", this::search);
        router.addRoutes(sPathRoot + "/{clusterName}", this.f_clusterResource);
    }

    public Response get(HttpRequest request) {
        Set<String> setCluster = this.f_supplierClusters.get();
        Filter<String> filter = this.getLinksFilter(request);
        EntityMBeanResponse mBeanResponse = new EntityMBeanResponse(request, filter);
        List<Map<String, Object>> list = setCluster.stream().map(sName -> this.getJson((String)sName, request)).collect(Collectors.toList());
        mBeanResponse.addParentResourceLink(this.getParentUri(request));
        mBeanResponse.addSelfResourceLinks(this.getCurrentUri(request));
        mBeanResponse.setEntities(list);
        return this.response(mBeanResponse);
    }

    public Response search(HttpRequest request) {
        Map<String, Object> entity = this.getJsonBody(request);
        if (entity == null) {
            entity = Collections.emptyMap();
        }
        Filter<String> filter = this.getLinksFilter(request);
        EntityMBeanResponse mBeanResponse = new EntityMBeanResponse(request, filter);
        Set<String> setCluster = this.f_supplierClusters.get();
        ClusterResource resource = new ClusterResource();
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        URI parentUri = this.getParentUri(request);
        URI currentUri = this.getCurrentUri(request);
        ResourceRegistry registry = request.getResourceRegistry();
        for (String sCluster : setCluster) {
            registry.registerResource(String.class, "clusterName", BuilderHelper.using(sCluster), RegistrationBehavior.REPLACE, null);
            URI subUri = ClustersResource.getSubUri(parentUri, sCluster);
            LinkedHashMap<String, Object> mapQuery = new LinkedHashMap<String, Object>(entity);
            Map<String, Object> mapCluster = resource.getSearchResults(request, sCluster, mapQuery, parentUri, subUri, currentUri);
            items.add(mapCluster);
        }
        mBeanResponse.setEntities(items);
        return this.response(mBeanResponse);
    }

    private Map<String, Object> getJson(String clusterName, HttpRequest request) {
        request.getResourceRegistry().registerResource(String.class, "clusterName", BuilderHelper.using(clusterName), RegistrationBehavior.REPLACE, null);
        return this.f_clusterResource.getClusterResponseMap(request, this.getCurrentUri(request), clusterName);
    }
}

