/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.CachesResource;
import com.tangosol.internal.management.resources.ClusterMembersResource;
import com.tangosol.internal.management.resources.ExecutorsResource;
import com.tangosol.internal.management.resources.HealthsResource;
import com.tangosol.internal.management.resources.JournalResource;
import com.tangosol.internal.management.resources.ReportersResource;
import com.tangosol.internal.management.resources.ServicesResource;
import com.tangosol.internal.management.resources.StorageManagersResource;
import com.tangosol.internal.management.resources.TopicsResource;
import com.tangosol.internal.management.resources.ViewsResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Resources;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClusterResource
extends AbstractManagementResource {
    public static final String DUMP_CLUSTER_HEAP = "dumpClusterHeap";
    public static final String CONFIGURE_TRACING = "configureTracing";
    public static final String GET_CLUSTER_CONFIG = "getClusterConfig";
    public static final String ROLE = "role";
    public static final String TRACING_RATIO = "tracingRatio";
    public static final String[] CHILD_LINKS = new String[]{"services", "caches", "members", "management", "journal", "hotcache", "reporters", "webApplications", "executors", "topics", "storage", "views"};

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addGet(sPathRoot + "/management", this::getManagement);
        router.addGet(sPathRoot + "/journal", this::getJournalResponse);
        router.addGet(sPathRoot + "/platform/{platformMBean}", this::getPlatformResponse);
        router.addGet(sPathRoot + "/metadata-catalog", this::getMetadataCatalog).produces("application/json", "application/swagger+json");
        router.addGet(sPathRoot + "/getClusterConfig", this::getClusterConfig).produces("application/xml");
        router.addGet(sPathRoot + "/description", this::getClusterDescription);
        router.addPost(sPathRoot, this::updateNodes);
        router.addPost(sPathRoot + "/shutdown", this::shutdownCluster);
        router.addPost(sPathRoot + "/logClusterState", this::logClusterState);
        router.addPost(sPathRoot + "/dumpClusterHeap", this::dumpClusterHeap);
        router.addPost(sPathRoot + "/configureTracing", this::configureTracing);
        router.addPost(sPathRoot + "/management", this::updateJMXManagement);
        router.addPost(sPathRoot + "/search", this::search);
        router.addPost(sPathRoot + "/diagnostic-cmd/{jfrCmd}", this::diagnosticCmd);
        router.addPost(sPathRoot + "/{operationName}", this::executeOperation);
        router.addPost(sPathRoot + "/networkStats/trackWeakest", this::trackWeakestMember);
        router.addRoutes(sPathRoot + "/caches", new CachesResource());
        router.addRoutes(sPathRoot + "/executors", new ExecutorsResource());
        router.addRoutes(sPathRoot + "/health", new HealthsResource());
        router.addRoutes(sPathRoot + "/journal/{journalType}", new JournalResource());
        router.addRoutes(sPathRoot + "/members", new ClusterMembersResource());
        router.addRoutes(sPathRoot + "/reporters", new ReportersResource());
        router.addRoutes(sPathRoot + "/services", new ServicesResource());
        router.addRoutes(sPathRoot + "/storage", new StorageManagersResource());
        router.addRoutes(sPathRoot + "/topics", new TopicsResource());
        router.addRoutes(sPathRoot + "/views", new ViewsResource());
    }

    public Response getMetadataCatalog() {
        URL url = Resources.findFileOrResource("management-swagger.json", this.getClass().getClassLoader());
        try {
            return url == null ? Response.notFound().build() : Response.ok(url.openStream()).build();
        }
        catch (IOException e) {
            Logger.warn("Exception occurred while returning Swagger resource management-swagger.json", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public Response get(HttpRequest request) {
        return this.response(this.getResponseEntityForMbean(request, this.getQuery(request), CHILD_LINKS));
    }

    public Response getManagement(HttpRequest request) {
        return this.response(this.getResponseEntityForMbean(request, this.getManagementQuery(request), new String[0]));
    }

    public Response getJournalResponse(HttpRequest request) {
        return this.response(this.getLinksOnlyResponseBody(request, this.getParentUri(request), this.getCurrentUri(request), "ram", "flash").toJson());
    }

    public Response getPlatformResponse(HttpRequest request) {
        String sPlatformMBeanType = request.getFirstPathParameter("platformMBean");
        String sRoleName = request.getFirstPathParameter(ROLE);
        String sCollector = request.getFirstPathParameter("collector");
        String sBaseQuery = (String)MAP_PLATFORM_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType);
        if (sBaseQuery == null && (sBaseQuery = (String)MAP_PLATFORM_PS_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType)) == null && (sBaseQuery = (String)MAP_PLATFORM_G1_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType)) == null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(sBaseQuery);
        EntityMBeanResponse response = this.getLinksOnlyResponseBody(request, this.getParentUri(request), this.getCurrentUri(request), new String[0]);
        Map<String, Object> responseMap = response.toJson();
        this.addAggregatedMetricsToResponseMap(request, sRoleName, sCollector, queryBuilder, responseMap);
        return this.response(responseMap);
    }

    public Response getClusterDescription(HttpRequest request) {
        return this.response(this.getResponseFromMBeanOperation(request, this.getQuery(request), "description", "getClusterDescription"));
    }

    public Response shutdownCluster(HttpRequest request) {
        return this.executeMBeanOperation(request, this.getQuery(request), "shutdown", null, null);
    }

    public Response logClusterState(HttpRequest request) {
        Map<String, Object> mapBody = this.getJsonBody(request);
        String sRoleName = (String)mapBody.get(ROLE);
        return this.executeMBeanOperation(request, this.getQuery(request), "logClusterState", new Object[]{sRoleName}, new String[]{String.class.getName()});
    }

    public Response dumpClusterHeap(HttpRequest request) {
        Map<String, Object> mapBody = this.getJsonBody(request);
        String sRoleName = (String)mapBody.get(ROLE);
        return this.executeMBeanOperation(request, this.getQuery(request), DUMP_CLUSTER_HEAP, new Object[]{sRoleName}, new String[]{String.class.getName()});
    }

    public Response configureTracing(HttpRequest request) {
        Map<String, Object> mapParameters = this.getJsonBody(request);
        Object oRole = mapParameters == null ? null : mapParameters.get(ROLE);
        float oRatio = mapParameters == null ? -1.0f : Float.parseFloat(mapParameters.get(TRACING_RATIO).toString());
        return this.executeMBeanOperation(request, this.getQuery(request), CONFIGURE_TRACING, new Object[]{oRole, Float.valueOf(oRatio)}, new String[]{String.class.getName(), Float.class.getName()});
    }

    public Response executeOperation(HttpRequest request) {
        String sOperationName = request.getFirstPathParameter("operationName");
        if (sOperationName.equalsIgnoreCase("logMemberState")) {
            sOperationName = "logNodeState";
        }
        if ("shutdown".equals(sOperationName) || "resetStatistics".equals(sOperationName) || "logNodeState".equals(sOperationName)) {
            return this.executeMBeanOperation(request, this.getMembersQuery(request), sOperationName, null, null);
        }
        return Response.notFound().build();
    }

    public Response trackWeakestMember(HttpRequest request) {
        return this.executeMBeanOperation(request, this.getPointToPointMBeanQuery(request), "trackWeakest", null, null);
    }

    public Response updateJMXManagement(HttpRequest request) {
        Map<String, Object> mapParameters = this.getJsonBody(request);
        return this.update(request, mapParameters, this.getManagementQuery(request));
    }

    public Response updateNodes(HttpRequest request) {
        Map<String, Object> entity = this.getJsonBody(request);
        MBeanAccessor.QueryBuilder queryBuilder = this.getMembersQuery(request);
        return this.update(request, entity, queryBuilder);
    }

    public Response search(HttpRequest request) {
        Map<String, Object> mapQuery = this.getJsonBody(request);
        URI uriParent = this.getParentUri(request);
        URI uriCurrent = this.getCurrentUri(request);
        String sCluster = this.getClusterName(request);
        return this.response(this.getSearchResults(request, sCluster, mapQuery, uriParent, uriCurrent, uriCurrent));
    }

    public Response diagnosticCmd(HttpRequest request) {
        String sCmd = request.getFirstPathParameter("jfrCmd");
        String sOptions = request.getFirstQueryParameter("options");
        String sRole = request.getFirstQueryParameter(ROLE);
        return this.response(this.getResponseFromMBeanOperation(request, this.getQuery(request), "status", "flightRecording", new Object[]{sRole, sCmd, sOptions}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()}));
    }

    public Response getClusterConfig(HttpRequest request) {
        return this.executeMBeanOperation(request, this.getQuery(request), GET_CLUSTER_CONFIG, null, null);
    }

    public Map<String, Object> getClusterResponseMap(HttpRequest request, URI uriParent, String sClusterName) {
        EntityMBeanResponse response = this.getResponseEntityForMbean(request, this.getQuery(request), uriParent, ClusterResource.getSubUri(uriParent, sClusterName), null, CHILD_LINKS);
        return response != null ? response.toJson() : new LinkedHashMap<String, Object>();
    }

    public Map<String, Object> getSearchResults(HttpRequest request, String sCluster, Map<String, Object> mapQuery, URI uriParent, URI uriCurrent, URI uriChild) {
        LinkedHashMap<String, Object> mapResponse = new LinkedHashMap<String, Object>();
        EntityMBeanResponse response = this.getResponseEntityForMbean(request, this.getQuery(sCluster), uriParent, uriCurrent, mapQuery, new String[0]);
        mapResponse.putAll(response.toJson());
        Object oChildren = this.getChildrenQuery(mapQuery);
        if (oChildren instanceof Map) {
            Map mapChildrenQuery = (Map)oChildren;
            this.addChildMbeanQueryResult(request, uriParent, uriChild, "management", this.getManagementQuery(request), mapResponse, mapChildrenQuery, new String[0]);
            this.addChildResourceQueryResult(request, new ServicesResource(), "services", mapResponse, mapChildrenQuery, null);
            this.addChildResourceQueryResult(request, new ClusterMembersResource(), "members", mapResponse, mapChildrenQuery, null);
            this.addChildResourceQueryResult(request, new ReportersResource(), "reporters", mapResponse, mapChildrenQuery, null);
            this.addChildResourceQueryResult(request, new ExecutorsResource(), "executors", mapResponse, mapChildrenQuery, null);
            Object oJournal = mapChildrenQuery.get("journal");
            if (oJournal instanceof Map) {
                LinkedHashMap<String, Object> mapJournal = new LinkedHashMap<String, Object>();
                Object oJournalChildren = this.getChildrenQuery((Map)oJournal);
                if (oJournalChildren instanceof Map) {
                    Map mapJournalQuery = (Map)oJournalChildren;
                    this.addChildResourceQueryResult(request, new JournalResource(), "ram", mapJournal, mapJournalQuery, Collections.singletonMap("journalType", "ram"));
                    this.addChildResourceQueryResult(request, new JournalResource(), "flash", mapJournal, mapJournalQuery, Collections.singletonMap("journalType", "flash"));
                    mapResponse.put("journal", mapJournal);
                }
            }
        }
        return mapResponse;
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request) {
        return this.getQuery(this.getClusterName(request));
    }

    protected MBeanAccessor.QueryBuilder getQuery(String sCluster) {
        return this.createQueryBuilder(sCluster).withBaseQuery(":type=Cluster");
    }

    protected MBeanAccessor.QueryBuilder getManagementQuery(HttpRequest request) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Management");
    }

    protected MBeanAccessor.QueryBuilder getMembersQuery(HttpRequest request) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Node");
    }

    protected MBeanAccessor.QueryBuilder getPointToPointMBeanQuery(HttpRequest request) {
        return this.createQueryBuilder(request).withBaseQuery(":type=PointToPoint").withMember("*");
    }
}

