/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ClusterMemberResource
extends AbstractManagementResource {
    public static final String MEMBER_DUMP_HEAP = "dumpHeap";
    public static final String DIAGNOSTIC_CMD = "diagnostic-cmd";
    public static String[] CHILD_LINKS;

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addGet(sPathRoot + "/platform/{platformMBean}", this::getPlatformMBeanResponse);
        router.addGet(sPathRoot + "/{networkStats}", this::getPointToPointResponse);
        router.addGet(sPathRoot + "/environment", this::getEnvironmentResponse);
        router.addGet(sPathRoot + "/state", this::getStateResponse);
        router.addGet(sPathRoot + "/federation", this::getFederationResponse);
        router.addGet(sPathRoot + "/federation/topologies", this::getTopologiesResponse);
        router.addGet(sPathRoot + "/federation/topologies/{topologyName}", this::getTopologyResponse);
        router.addGet(sPathRoot + "/description", this::getNodeDescription);
        router.addPost(sPathRoot, this::update);
        router.addPost(sPathRoot + "/{operationName}", this::executeOperation);
        router.addPost(sPathRoot + "/logMemberState", new LogMemberStateHandler());
        router.addPost(sPathRoot + "/dumpHeap", new DumpHeapHandler());
        router.addPost(sPathRoot + "/networkStats/trackWeakest", this::trackWeakestMember);
        router.addPost(sPathRoot + "/diagnostic-cmd/{jfrCmd}", this::diagnosticCmd);
    }

    public Response get(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        return this.response(this.getResponseEntityForMbean(request, this.getQuery(request, sMemberKey), CHILD_LINKS));
    }

    public Response getPlatformMBeanResponse(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        String sPlatformMBeanType = request.getFirstPathParameter("platformMBean");
        String sBaseQuery = (String)MAP_PLATFORM_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType);
        if (sBaseQuery == null && (sBaseQuery = (String)MAP_PLATFORM_PS_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType)) == null && (sBaseQuery = (String)MAP_PLATFORM_G1_URL_TO_MBEAN_QUERY.get(sPlatformMBeanType)) == null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(sBaseQuery).withMember(sMemberKey);
        return this.response(this.getResponseEntityForMbean(request, queryBuilder, new String[0]));
    }

    public Response getPointToPointResponse(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        return this.response(this.getResponseEntityForMbean(request, this.getPointToPointMBeanQuery(request, sMemberKey), new String[0]));
    }

    public Response getStateResponse(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        return this.response(this.getResponseFromMBeanOperation(request, this.getQuery(request, sMemberKey), "state", "reportNodeState"));
    }

    public Response getEnvironmentResponse(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        return this.response(this.getResponseFromMBeanOperation(request, this.getQuery(request, sMemberKey), "environment", "reportEnvironment"));
    }

    public Response getFederationResponse(HttpRequest request) {
        return this.response(this.getLinksOnlyResponseBody(request, this.getParentUri(request), this.getCurrentUri(request), "topologies").toJson());
    }

    public Response getTopologiesResponse(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=Federation,subType=Topology").withMember(sMemberKey);
        return this.response(this.getResponseBodyForMBeanCollection(request, queryBuilder, "name", null, this.getParentUri(request), this.getCurrentUri(request)));
    }

    public Response getTopologyResponse(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        String sTopologyName = request.getFirstPathParameter("topologyName");
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(String.format(":type=Federation,subType=Topology,name=%s", sTopologyName)).withMember(sMemberKey);
        return this.response(this.getResponseEntityForMbean(request, queryBuilder, new String[0]));
    }

    public Response getNodeDescription(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        return this.response(this.getResponseFromMBeanOperation(request, this.getQuery(request, sMemberKey), "description", "getNodeDescription"));
    }

    public Response update(HttpRequest request) {
        Map<String, Object> entity = this.getJsonBody(request);
        String sMemberKey = request.getFirstPathParameter("memberKey");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sMemberKey);
        return this.update(request, entity, queryBuilder);
    }

    public Response executeOperation(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        String sOperationName = request.getFirstPathParameter("operationName");
        if ("shutdown".equals(sOperationName) || "resetStatistics".equals(sOperationName)) {
            return this.executeMBeanOperation(request, this.getQuery(request, sMemberKey), sOperationName, null, null);
        }
        return Response.notFound().build();
    }

    public Response logMemberState(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        return this.executeMBeanOperation(request, this.getQuery(request, sMemberKey), "logNodeState", null, null);
    }

    public Response trackWeakestMember(HttpRequest request) {
        String sMemberKey = request.getFirstPathParameter("memberKey");
        return this.executeMBeanOperation(request, this.getPointToPointMBeanQuery(request, sMemberKey), "trackWeakest", null, null);
    }

    public Response diagnosticCmd(HttpRequest request) {
        String[] stringArray;
        Object[] objectArray;
        String sMemberKey = request.getFirstPathParameter("memberKey");
        String sCmd = request.getFirstPathParameter("jfrCmd");
        String sOptions = request.getFirstQueryParameter("options");
        String sBaseQuery = ":type=DiagnosticCommand,Domain=com.sun.management,subType=DiagnosticCommand";
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(sBaseQuery).withMember(sMemberKey);
        if (sOptions == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = sOptions.split(",");
        }
        Object[] aoArguments = objectArray;
        if (sOptions == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String[].class.getName();
        }
        String[] signature = stringArray;
        return this.response(this.getResponseFromMBeanOperation(request, queryBuilder, "status", sCmd, aoArguments, signature));
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        String sMemberKey = mapArguments.get("memberKey");
        Object oChildren = this.getChildrenQuery(mapQuery);
        URI uriSelf = ClusterMemberResource.getSubUri(uriParent, sMemberKey);
        EntityMBeanResponse response = this.getLinksOnlyResponseBody(request, uriParent, uriSelf, this.getLinksFilter(request, mapQuery), CHILD_LINKS);
        Map<String, Object> mapResponse = response.getEntity();
        if (oChildren instanceof Map) {
            Map mapChildrenQuery = (Map)oChildren;
            this.addChildMbeanQueryResult(request, uriParent, uriCurrent, "networkStats", this.getPointToPointMBeanQuery(request, sMemberKey), mapResponse, mapChildrenQuery, new String[0]);
            this.addPlatformMBeansQueryResult(request, uriParent, uriCurrent, sMemberKey, mapResponse, mapChildrenQuery);
            this.addFederationTopologiesQueryResult(request, sMemberKey, mapResponse, mapChildrenQuery, uriSelf);
        }
        return response;
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sMemberKey) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Node").withMember(sMemberKey);
    }

    protected MBeanAccessor.QueryBuilder getPointToPointMBeanQuery(HttpRequest request, String sMemberKey) {
        return this.createQueryBuilder(request).withBaseQuery(":type=PointToPoint").withMember(sMemberKey);
    }

    protected Object getPlatformChildrenQueryMap(Map mapQuery) {
        Object oPlatformQuery = mapQuery.get("platform");
        Object oChildrenQueryObject = null;
        if (oPlatformQuery instanceof Map) {
            oChildrenQueryObject = ((Map)oPlatformQuery).get("children");
        }
        return oChildrenQueryObject;
    }

    protected void addPlatformMBeansQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, String sMemberId, Map<String, Object> mapResponse, Map mapQuery) {
        Object oChildrenQueryObject = this.getPlatformChildrenQueryMap(mapQuery);
        if (oChildrenQueryObject instanceof Map) {
            MBeanAccessor.QueryBuilder queryBuilder;
            String sPlatformMBeanKey;
            LinkedHashMap<String, Object> mapPlatform = new LinkedHashMap<String, Object>();
            Map mapPlatformChildrenQueryMap = (Map)oChildrenQueryObject;
            for (Map.Entry entry : MAP_PLATFORM_URL_TO_MBEAN_QUERY.entrySet()) {
                sPlatformMBeanKey = (String)entry.getKey();
                queryBuilder = this.createQueryBuilder(request).withBaseQuery((String)entry.getValue()).withMember(sMemberId);
                this.addChildMbeanQueryResult(request, uriParent, uriCurrent, sPlatformMBeanKey, queryBuilder, mapPlatform, mapPlatformChildrenQueryMap, new String[0]);
            }
            for (Map.Entry entry : MAP_PLATFORM_G1_URL_TO_MBEAN_QUERY.entrySet()) {
                sPlatformMBeanKey = (String)entry.getKey();
                queryBuilder = this.createQueryBuilder(request).withBaseQuery((String)entry.getValue()).withMember(sMemberId);
                this.addChildMbeanQueryResult(request, uriParent, uriCurrent, sPlatformMBeanKey, queryBuilder, mapPlatform, mapPlatformChildrenQueryMap, new String[0]);
            }
            for (Map.Entry entry : MAP_PLATFORM_PS_URL_TO_MBEAN_QUERY.entrySet()) {
                sPlatformMBeanKey = (String)entry.getKey();
                queryBuilder = this.createQueryBuilder(request).withBaseQuery((String)entry.getValue()).withMember(sMemberId);
                this.addChildMbeanQueryResult(request, uriParent, uriCurrent, sPlatformMBeanKey, queryBuilder, mapPlatform, mapPlatformChildrenQueryMap, new String[0]);
            }
            mapResponse.put("platform", mapPlatform);
        }
    }

    protected void addFederationTopologiesQueryResult(HttpRequest request, String sMemberId, Map<String, Object> mapResponse, Map mapQuery, URI uriParent) {
        Object oFederationQueryObject = mapQuery.get("federation");
        if (oFederationQueryObject instanceof Map) {
            Object oTopologiesQuery;
            Map mapFederationQuery = (Map)oFederationQueryObject;
            URI uriSelf = ClusterMemberResource.getSubUri(uriParent, "federation");
            Filter<String> filterLinks = this.getLinksFilter(request, mapFederationQuery);
            Object oFederationChildren = this.getChildrenQuery(mapFederationQuery);
            Map<String, Object> mapTopologiesResponse = this.getLinksOnlyResponseBody(request, uriParent, uriSelf, filterLinks, "topologies").toJson();
            if (oFederationChildren instanceof Map && (oTopologiesQuery = ((Map)oFederationChildren).get("topologies")) != null) {
                Map mapTopologiesQuery = (Map)oTopologiesQuery;
                MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=Federation,subType=Topology").withMember(sMemberId);
                EntityMBeanResponse responseEntity = this.getResponseBodyForMBeanCollection(request, queryBuilder, "name", mapTopologiesQuery, uriParent, uriSelf);
                mapTopologiesResponse.put("topologies", responseEntity.toJson());
            }
            mapResponse.put("federation", mapTopologiesResponse);
        }
    }

    static {
        ArrayList<String> listChildLinks = new ArrayList<String>();
        listChildLinks.addAll(MAP_PLATFORM_URL_TO_MBEAN_QUERY.keySet().stream().map(s -> "platform/" + s).collect(Collectors.toSet()));
        listChildLinks.addAll(MAP_PLATFORM_G1_URL_TO_MBEAN_QUERY.keySet().stream().map(s -> "platform/" + s).collect(Collectors.toSet()));
        listChildLinks.addAll(MAP_PLATFORM_PS_URL_TO_MBEAN_QUERY.keySet().stream().map(s -> "platform/" + s).collect(Collectors.toSet()));
        listChildLinks.add("networkStats");
        listChildLinks.add("federation");
        CHILD_LINKS = listChildLinks.toArray(new String[0]);
    }

    public class LogMemberStateHandler
    implements RequestRouter.RequestHandler {
        @Override
        public Response handle(HttpRequest request) {
            String sMemberKey = request.getFirstPathParameter("memberKey");
            return ClusterMemberResource.this.executeMBeanOperation(request, ClusterMemberResource.this.getQuery(request, sMemberKey), "logNodeState", null, null);
        }
    }

    public class DumpHeapHandler
    implements RequestRouter.RequestHandler {
        @Override
        public Response handle(HttpRequest request) {
            String sMemberKey = request.getFirstPathParameter("memberKey");
            String[] asSignature = new String[]{String.class.getName()};
            Object[] aoArguments = new Object[]{null};
            return ClusterMemberResource.this.executeMBeanOperation(request, ClusterMemberResource.this.getQuery(request, sMemberKey), ClusterMemberResource.MEMBER_DUMP_HEAP, aoArguments, asSignature);
        }
    }
}

