/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.CacheResource;
import com.tangosol.net.management.MBeanAccessor;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class CachesResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addGet(sPathRoot + "/members", this::getAllCacheMembers);
        router.addRoutes(sPathRoot + "/{cacheName}", new CacheResource());
    }

    public Response get(HttpRequest request) {
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=Cache").withService(this.getService(request));
        URI uriCurrent = this.getCurrentUri(request);
        EntityMBeanResponse response = this.getResponseBodyForMBeanCollection(request, queryBuilder, new CacheResource(), "name", null, this.getParentUri(request), uriCurrent, uriCurrent, null);
        if (response == null && this.getService(request) != null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        return response == null ? this.response(new HashMap<String, Object>()) : this.response(response);
    }

    public Response getAllCacheMembers(HttpRequest request) {
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=Cache").withService(this.getService(request));
        return this.response(this.getResponseBodyForMBeanCollection(request, queryBuilder, null, this.getParentUri(request), this.getCurrentUri(request)));
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        String sServiceName = mapArguments.get("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.createQueryBuilder(request).withBaseQuery(":type=Cache").withService(sServiceName);
        return this.getResponseBodyForMBeanCollection(request, queryBuilder, new CacheResource(), "name", mapQuery, uriParent, CachesResource.getSubUri(uriParent, "caches"), uriCurrent, mapArguments);
    }
}

