/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.Converter;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.CacheMembersResource;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import com.tangosol.util.filter.AlwaysFilter;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CacheResource
extends AbstractManagementResource {
    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addPost(sPathRoot, this::update);
        router.addPost(sPathRoot + "/resetStatistics", this::resetStatistics);
        router.addRoutes(sPathRoot + "/members", new CacheMembersResource());
    }

    public Response get(HttpRequest request) {
        String sCacheName = request.getFirstPathParameter("cacheName");
        String sRoleName = request.getFirstQueryParameter("role");
        String sCollector = request.getFirstQueryParameter("collector");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sCacheName, sServiceName);
        Set<String> setObjectNames = this.ensureBeanAccessor(request).queryKeys(queryBuilder.build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        EntityMBeanResponse responseEntity = this.createResponse(request, this.getParentUri(request), this.getCurrentUri(request), this.getLinksFilter(request));
        this.addObjectNamesToResponse(request, setObjectNames, responseEntity, this.getCurrentUri(request));
        Map<String, Object> mapResponse = responseEntity.toJson();
        MBeanAccessor.QueryBuilder queryBuilderStorage = this.createQueryBuilder(request).withBaseQuery(String.format(":type=StorageManager,cache=%s", sCacheName)).withService(this.getService(request));
        this.addAggregatedMetricsToResponseMap(request, sRoleName, sCollector, queryBuilder, mapResponse);
        this.addAggregatedMetricsToResponseMap(request, sRoleName, sCollector, queryBuilderStorage, mapResponse);
        return this.response(mapResponse);
    }

    public Response resetStatistics(HttpRequest request) {
        String sCacheName = request.getFirstPathParameter("cacheName");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sCacheName, sServiceName);
        return this.executeMBeanOperation(request, queryBuilder, "resetStatistics", null, null);
    }

    public Response update(HttpRequest request) {
        String sCacheName = request.getFirstPathParameter("cacheName");
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sCacheName, sServiceName);
        return this.update(request, this.getJsonBody(request), queryBuilder);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        Object oChildren;
        String sCacheName = mapArguments.get("name");
        URI uriSelf = CacheResource.getSubUri(uriParent, sCacheName);
        Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
        String sServiceName = request.getPathParameters().getFirst("serviceName");
        MBeanAccessor.QueryBuilder queryBuilder = this.getQuery(request, sCacheName, sServiceName);
        Set<String> setObjectNames = this.ensureBeanAccessor(request).queryKeys(queryBuilder.build());
        if (setObjectNames == null || setObjectNames.isEmpty()) {
            return null;
        }
        EntityMBeanResponse responseEntity = this.createResponse(request, uriParent, uriSelf, filterLinks);
        this.addObjectNamesToResponse(request, setObjectNames, responseEntity, uriCurrent);
        Map<String, Object> mapEntity = responseEntity.getEntity();
        MBeanAccessor.QueryBuilder queryBuilderStorage = this.createQueryBuilder(request).withBaseQuery(String.format(":type=StorageManager,cache=%s", sCacheName)).withService(this.getService(request));
        this.addAggregatedMetricsToResponseMap(request, "*", null, queryBuilder, mapEntity);
        this.addAggregatedMetricsToResponseMap(request, "*", null, queryBuilderStorage, mapEntity);
        Object object = oChildren = mapQuery == null ? null : mapQuery.get("children");
        if (oChildren instanceof Map) {
            Map mapChildrenQuery = (Map)oChildren;
            this.addChildResourceQueryResult(request, new CacheMembersResource(), "members", mapEntity, mapChildrenQuery, mapArguments);
        }
        return responseEntity;
    }

    protected MBeanAccessor.QueryBuilder getQuery(HttpRequest request, String sCacheName, String sServiceName) {
        return this.createQueryBuilder(request).withBaseQuery(":type=Cache,name=" + sCacheName).withService(sServiceName);
    }

    protected void addObjectNamesToResponse(HttpRequest request, Set<String> setObjectNames, EntityMBeanResponse responseEntity, URI uriCurrent) {
        Filter<String> filterAttributes = this.getAttributesFilter(request);
        LinkedHashMap<String, Object> mapAttributes = new LinkedHashMap<String, Object>();
        if (filterAttributes instanceof AlwaysFilter) {
            filterAttributes = this.getAttributesFilter(String.join((CharSequence)",", "name", "service", "nodeId"), null);
        }
        for (String sName : setObjectNames) {
            try {
                ObjectName objectName = new ObjectName(sName);
                for (String sKey : objectName.getKeyPropertyList().keySet()) {
                    if (!filterAttributes.evaluate(sKey)) continue;
                    Object oValue = Converter.convert(objectName.getKeyProperty(sKey));
                    Object oCurrent = mapAttributes.get(sKey);
                    if (oCurrent == null) {
                        mapAttributes.put(sKey, oValue);
                        continue;
                    }
                    if (oCurrent instanceof Set) {
                        ((Set)oCurrent).add(oValue);
                        continue;
                    }
                    if (Objects.equals(oCurrent, oValue)) continue;
                    HashSet<Object> values = new HashSet<Object>();
                    values.add(oCurrent);
                    values.add(oValue);
                    mapAttributes.put(sKey, values);
                }
            }
            catch (MalformedObjectNameException e) {
                CacheFactory.log("Exception occurred while creating an ObjectName " + sName + "\n" + CacheFactory.getStackTrace(e));
            }
        }
        responseEntity.setEntity(mapAttributes);
        responseEntity.addResourceLink("members", CacheResource.getSubUri(uriCurrent, "members"));
    }
}

