/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.http.HttpException;
import com.tangosol.internal.http.HttpMethod;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.QueryParameters;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.Converter;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.MBeanResponse;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.net.management.MapJsonBodyHandler;
import com.tangosol.net.management.Registry;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.NotFilter;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;

public abstract class AbstractManagementResource
implements RequestRouter.Routes {
    public static final String INCLUDE_FIELDS = "fields";
    public static final String INCLUDE_LINKS = "links";
    public static final String EXCLUDE_FIELDS = "excludeFields";
    public static final String EXCLUDE_LINKS = "excludeLinks";
    public static final String MEDIA_TYPE_JSON = "application/json";
    public static final String MEDIA_TYPE_XML = "application/xml";
    public static final String MEDIA_TYPE_SWAGGER_JSON = "application/swagger+json";
    public static final String SWAGGER_RESOURCE = "management-swagger.json";
    public static final String MEDIA_TYPES = "application/json";
    public static final String CACHES_QUERY = ":type=Cache";
    public static final String CACHE_QUERY = ":type=Cache,name=";
    public static final String TOPICS_QUERY = ":type=PagedTopic";
    public static final String TOPIC_QUERY = ":type=PagedTopic,name=";
    public static final String VIEWS_QUERY = ":type=View";
    public static final String VIEW_QUERY = ":type=View,name=";
    public static final String SUBSCRIBERS_QUERY = ":type=PagedTopicSubscriber";
    public static final String SUBSCRIBER_QUERY = ":type=PagedTopicSubscriber,id=";
    public static final String TOPIC_SUBSCRIBERS_QUERY = ":type=PagedTopicSubscriber,topic=";
    public static final String SUBSCRIBER_GROUPS_QUERY = ":type=PagedTopicSubscriberGroup";
    public static final String TOPIC_SUBSCRIBER_GROUPS_QUERY = ":type=PagedTopicSubscriberGroup,topic=";
    public static final String TOPIC_SUBSCRIBER_GROUP_QUERY = ":type=PagedTopicSubscriberGroup,topic=%s,name=%s";
    public static final String CACHE_MEMBERS_WITH_SERVICE_QUERY = ":type=Cache,name=";
    public static final String CLUSTER_MEMBERS_QUERY = ":type=Node";
    public static final String REPORTER_MEMBERS_QUERY = ":type=Reporter";
    public static final String VIEW_MEMBERS_WITH_SERVICE_QUERY = ":type=View,name=";
    public static final String FLASH_JOURNAL_QUERY = ":type=Journal,name=FlashJournalRM";
    public static final String RAM_JOURNAL_QUERY = ":type=Journal,name=RamJournalRM";
    public static final String CLUSTER_QUERY = ":type=Cluster";
    public static final String MANAGEMENT_QUERY = ":type=Management";
    public static final String POINT_TO_POINT_QUERY = ":type=PointToPoint";
    public static final String CONNECTION_MANAGERS_QUERY = ":type=ConnectionManager";
    public static final String CONNECTION_MANAGER_QUERY = ":type=ConnectionManager,name=";
    public static final String CONNECTIONS_QUERY = ":type=Connection,name=";
    public static final String SERVICE_MEMBERS_QUERY = ":type=Service,name=";
    public static final String PARTITION_ASSIGNMENT_QUERY = ":type=PartitionAssignment";
    public static final String SERVICES_QUERY = ":type=Service";
    public static final String FEDERATION_TYPE = ":type=Federation";
    public static final String FEDERATION_COORDINATOR_QUERY = ":type=Federation,responsibility=Coordinator";
    public static final String FEDERATION_TOPOLOGY_MEMBER_QUERY = ":type=Federation,subType=Topology,name=%s";
    public static final String FEDERATION_TOPOLOGIES_QUERY = ":type=Federation,subType=Topology";
    public static final String DESTINATIONS_QUERY = ":type=Federation,subType=Destination,name=";
    public static final String DESTINATIONS_COLLECTION_QUERY = ":type=Federation,subType=Destination";
    public static final String ORIGINS_COLLECTION_QUERY = ":type=Federation,subType=Origin";
    public static final String ORIGINS_QUERY = ":type=Federation,subType=Origin,name=";
    public static final String PERSISTENCE_CONTROLLER_QUERY = ":type=Persistence,responsibility=PersistenceCoordinator";
    public static final String PLATFORM_MEMORY_QUERY = ":type=Platform,Domain=java.lang,subType=Memory";
    public static final String COMPRESSED_CLASS_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=Compressed Class Space";
    public static final String META_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=Metaspace";
    public static final String PS_MARK_SWEEP_QUERY = ":type=Platform,Domain=java.lang,subType=GarbageCollector,name=PS MarkSweep";
    public static final String PS_SCAVENGE_QUERY = ":type=Platform,Domain=java.lang,subType=GarbageCollector,name=PS Scavenge";
    public static final String PS_OLDGEN_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=PS Old Gen";
    public static final String PS_EDEN_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=PS Eden Space";
    public static final String PS_SURVIVOR_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=PS Survivor Space";
    public static final String OS_QUERY = ":type=Platform,Domain=java.lang,subType=OperatingSystem";
    public static final String RUNTIME_QUERY = ":type=Platform,Domain=java.lang,subType=Runtime";
    public static final String G1_OLD_GENERATION_QUERY = ":type=Platform,Domain=java.lang,subType=GarbageCollector,name=G1 Old Generation";
    public static final String G1_YOUNG_GENERATION_QUERY = ":type=Platform,Domain=java.lang,subType=GarbageCollector,name=G1 Young Generation";
    public static final String G1_EDEN_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=G1 Eden Space";
    public static final String G1_OLDGEN_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=G1 Old Gen";
    public static final String G1_SURVIVOR_SPACE_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=G1 Survivor Space";
    public static final String G1_CODEHEAP_NON_NMETHODS_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=CodeHeap 'non-nmethods'";
    public static final String G1_CODEHEAP_PROFILED_NMETHODS_QUERY = ":type=Platform,Domain=java.lang,subType=MemoryPool,name=CodeHeap 'profiled nmethods'";
    public static final String G1_CODECACHE_MANAGER = ":type=Platform,Domain=java.lang,subType=MemoryManager,name=CodeCacheManager";
    public static final String G1_METASPACE_MANAGER = ":type=Platform,Domain=java.lang,subType=MemoryManager,name=Metaspace Manager";
    public static final String HOTCACHE_MEMBERS_QUERY = ":type=CoherenceAdapter";
    public static final String CWEB_APPLICATIONS_QUERY = ":type=*HttpSessionManager";
    public static final String CWEB_APPLICATION_QUERY = ":type=*HttpSessionManager,appId=";
    public static final String STORAGE_MANAGERS_ALL_QUERY = ":type=StorageManager";
    public static final String STORAGE_MANAGERS_QUERY = ":type=StorageManager,cache=%s";
    public static final String STORAGE_MANAGER_QUERY = ":type=StorageManager,cache=%s,service=%s,nodeId=%s";
    public static final String EXECUTORS_QUERY = ":type=Executor";
    public static final String EXECUTOR_QUERY = ":type=Executor,name=";
    public static final String HEALTH_QUERY = ":type=Health";
    public static final String HEALTH_NAMED_QUERY = ":type=Health,subType=%s,name=%s";
    public static final String CLUSTER_NAME = "clusterName";
    public static final String SERVICE_NAME = "serviceName";
    public static final String CACHE_NAME = "cacheName";
    public static final String MEMBER_KEY = "memberKey";
    public static final String VERSION = "versionName";
    public static final String PARTICIPANT_NAME = "participantName";
    public static final String TOPOLOGY_NAME = "topologyName";
    public static final String OPERATION_NAME = "operationName";
    public static final String PLATFORM_MBEAN = "platformMBean";
    public static final String APPLICATION_ID = "applicationId";
    public static final String DOMAIN_PARTITION = "domainPartition";
    public static final String TOPOLOGIES = "topologies";
    public static final String SNAPSHOT_NAME = "snapshotName";
    public static final String JFR_CMD = "jfrCmd";
    public static final String TOPIC_NAME = "topicName";
    public static final String VIEW_NAME = "viewName";
    public static final String SUBSCRIBER_GROUP_NAME = "subscriberGroupName";
    public static final String METADATA_CATALOG = "metadata-catalog";
    public static final String SERVICES = "services";
    public static final String MEMBERS = "members";
    public static final String REPORTERS = "reporters";
    public static final String CACHES = "caches";
    public static final String MANAGEMENT = "management";
    public static final String SHUTDOWN = "shutdown";
    public static final String CLUSTER_STATE = "logClusterState";
    public static final String MEMBER_STATE = "logMemberState";
    public static final String CLUSTER = "cluster";
    public static final String SEARCH = "search";
    public static final String STORAGE = "storage";
    public static final String JOURNAL = "journal";
    public static final String JOURNAL_TYPE = "journalType";
    public static final String NETWORK_STATS = "networkStats";
    public static final String VERBOSE = "verbose";
    public static final String HOTCACHE = "hotcache";
    public static final String WEB_APPS = "webApplications";
    public static final String PERSISTENCE = "persistence";
    public static final String PROXY = "proxy";
    public static final String PARTICIPANTS = "participants";
    public static final String STATISTICS = "statistics";
    public static final String INCOMING = "incoming";
    public static final String OUTGOING = "outgoing";
    public static final String EXECUTORS = "executors";
    public static final String STATE = "state";
    public static final String ENVIRONMENT = "environment";
    public static final String HEALTH = "health";
    public static final String TOPICS = "topics";
    public static final String VIEWS = "views";
    public static final String SUBSCRIBERS = "subscribers";
    public static final String SUBSCRIBER_GROUPS = "subscriberGroups";
    public static final String SUBSCRIBER_GROUPS_LCASE = "subscribergroups";
    public static final String CHANNELS = "channels";
    public static final String LOADER = "loader";
    public static final String MEMBER = "member";
    public static final String CONNECTIONS = "connections";
    public static final String ROLE_NAME = "role";
    public static final String COLLECTOR = "collector";
    public static final String PLATFORM = "platform";
    public static final String RAM_JOURNAL_TYPE = "ram";
    public static final String FLASH_JOURNAL_TYPE = "flash";
    public static final String PARTITION = "partition";
    public static final String FEDERATION = "federation";
    public static final String RESET_STATS = "resetStatistics";
    public static final String PARTITION_STATS = "reportPartitionStats";
    public static final String CHILDREN = "children";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String NODE_ID = "nodeId";
    public static final String SERVICE = "service";
    public static final String SUB_TYPE = "subType";
    public static final String TIER_BACK = "back";
    public static final String TIER = "tier";
    public static final String OPTIONS = "options";
    public static final String CACHE = "cache";
    public static final String TRUNCATE = "truncate";
    public static final String CLEAR = "clear";
    public static final String DESCRIPTION = "description";
    public static final String DOMAIN_NAME = "domainName";
    public static final String DOMAIN_FILTER = "domainPartitionFilter";
    public static final String SUBSCRIBER_ID = "id";
    public static final Map<String, String> MAP_PLATFORM_URL_TO_MBEAN_QUERY = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("memory", AbstractManagementResource.PLATFORM_MEMORY_QUERY);
            this.put("metaSpace", AbstractManagementResource.META_SPACE_QUERY);
            this.put("compressedClassSpace", AbstractManagementResource.COMPRESSED_CLASS_SPACE_QUERY);
            this.put("operatingSystem", AbstractManagementResource.OS_QUERY);
            this.put("runtime", AbstractManagementResource.RUNTIME_QUERY);
        }
    });
    public static final Map<String, String> MAP_PLATFORM_PS_URL_TO_MBEAN_QUERY = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("psMarkSweep", AbstractManagementResource.PS_MARK_SWEEP_QUERY);
            this.put("psScavenge", AbstractManagementResource.PS_SCAVENGE_QUERY);
            this.put("psOldGen", AbstractManagementResource.PS_OLDGEN_QUERY);
            this.put("psEdenSpace", AbstractManagementResource.PS_EDEN_SPACE_QUERY);
            this.put("psSurvivorSpace", AbstractManagementResource.PS_SURVIVOR_SPACE_QUERY);
        }
    });
    public static final Map<String, String> MAP_PLATFORM_G1_URL_TO_MBEAN_QUERY = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("g1EdenSpace", AbstractManagementResource.G1_EDEN_SPACE_QUERY);
            this.put("g1OldGen", AbstractManagementResource.G1_OLDGEN_QUERY);
            this.put("g1OldGeneration", AbstractManagementResource.G1_OLD_GENERATION_QUERY);
            this.put("g1SurvivorSpace", AbstractManagementResource.G1_SURVIVOR_SPACE_QUERY);
            this.put("g1YoungGeneration", AbstractManagementResource.G1_YOUNG_GENERATION_QUERY);
            this.put("g1CodeHeapNonNMethods", AbstractManagementResource.G1_CODEHEAP_NON_NMETHODS_QUERY);
            this.put("g1CodeHeapProfiledNMethods", AbstractManagementResource.G1_CODEHEAP_PROFILED_NMETHODS_QUERY);
            this.put("g1CodeCacheManager", AbstractManagementResource.G1_CODECACHE_MANAGER);
            this.put("g1MetaSpaceManager", AbstractManagementResource.G1_METASPACE_MANAGER);
        }
    });
    public static final Map<String, String> MAP_JOURNAL_URL_TO_MBEAN_QUERY = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(AbstractManagementResource.FLASH_JOURNAL_TYPE, AbstractManagementResource.FLASH_JOURNAL_QUERY);
            this.put(AbstractManagementResource.RAM_JOURNAL_TYPE, AbstractManagementResource.RAM_JOURNAL_QUERY);
        }
    });
    private static final Set<String> SET_LONG = new HashSet<String>(Arrays.asList("intervalSeconds", "currentBatch", "taskHungThresholdMillis", "maxQueryThresholdMillis", "transportRetainedBytes", "requestTimeoutMillis", "taskTimeoutMillis"));
    private static final Set<String> SET_INTEGER = new HashSet<String>(Collections.singletonList("expiryDelay"));
    private static final Set<String> SET_FLOAT = new HashSet<String>(Collections.singletonList("tracingSamplingRatio"));
    private static final Pattern PATH_PATTERN = Pattern.compile("/");
    private static MapJsonBodyHandler s_jsonBodyHandler;
    private Filter<String> m_filterDomainPartition;
    private static volatile String s_sMBeanDomainName;
    protected MBeanAccessor m_accessor;

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
    }

    protected Map<String, Object> getJsonBody(HttpRequest request) {
        MapJsonBodyHandler jsonBodyHandler = this.ensureMapJsonBodyHandler();
        Map<String, Object> map = request.getJsonBody(jsonBodyHandler::readMap);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            long l;
            Object oValue = entry.getValue();
            if (!(oValue instanceof Long) || (l = ((Long)oValue).longValue()) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) continue;
            entry.setValue(((Number)oValue).intValue());
        }
        return map;
    }

    protected MapJsonBodyHandler ensureMapJsonBodyHandler() {
        if (s_jsonBodyHandler == null) {
            s_jsonBodyHandler = MapJsonBodyHandler.ensureMapJsonBodyHandler();
        }
        return s_jsonBodyHandler;
    }

    protected Response update(HttpRequest request, Map<String, Object> entity, MBeanAccessor.QueryBuilder queryBuilder) {
        try {
            if (queryBuilder.toString().contains(MANAGEMENT_QUERY)) {
                this.checkAttributeTypeConversion(entity, true);
            } else {
                this.checkAttributeTypeConversion(entity);
            }
            MBeanResponse responseEntity = new MBeanResponse(request);
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            if (!entity.isEmpty()) {
                Map<String, Object> attrMap = entity.entrySet().stream().collect(Collectors.toMap(e -> AbstractManagementResource.fromRestName((String)e.getKey()), Map.Entry::getValue));
                Map<String, Map<String, Object>> mapUpdatedMBeans = accessor.update(queryBuilder.build(), attrMap);
                if (mapUpdatedMBeans.isEmpty()) {
                    return Response.status(Response.Status.NOT_FOUND).build();
                }
                for (Map.Entry<String, Map<String, Object>> entry : mapUpdatedMBeans.entrySet()) {
                    String sObjName = entry.getKey();
                    Map<String, Object> mapAttributes = entry.getValue();
                    for (String sAttrKey : attrMap.keySet()) {
                        if (mapAttributes.containsKey(sAttrKey)) continue;
                        responseEntity.addFailure(AbstractManagementResource.getRestName(sAttrKey), "Update attribute failed for MBean: " + sObjName);
                    }
                }
            }
            return this.response(responseEntity.toJson());
        }
        catch (IllegalArgumentException iae) {
            Logger.info("Request precondition failure for updating an MBean with query " + String.valueOf(queryBuilder) + ". Failure is " + iae.getClass().getName() + " " + iae.getMessage());
            return Response.status(Response.Status.BAD_REQUEST).entity(Response.Status.BAD_REQUEST.getReasonPhrase() + "\n" + iae.getMessage()).build();
        }
        catch (RuntimeMBeanException e2) {
            if (this.isSecurityException(e2.getTargetException())) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            return this.createInternalServerError(queryBuilder, e2);
        }
        catch (SecurityException e3) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e4) {
            return this.createInternalServerError(queryBuilder, e4);
        }
    }

    private Response createInternalServerError(MBeanAccessor.QueryBuilder queryBuilder, Exception e) {
        Logger.warn("Exception occurred while updating an MBean with query " + queryBuilder.toString(), (Throwable)e);
        return Response.serverError().build();
    }

    protected EntityMBeanResponse getResponseEntityForMbean(HttpRequest request, MBeanAccessor.QueryBuilder queryBuilder, String ... asChildLinks) {
        return this.getResponseEntityForMbean(request, queryBuilder, this.getParentUri(request), this.getCurrentUri(request), this.getAttributesFilter(request), this.getLinksFilter(request), asChildLinks);
    }

    protected EntityMBeanResponse getResponseEntityForMbean(HttpRequest request, MBeanAccessor.QueryBuilder queryBuilder, URI uriParent, URI uriSelf, Map<String, Object> mapQuery, String ... asChildLinks) {
        return this.getResponseEntityForMbean(request, queryBuilder, uriParent, uriSelf, this.getAttributesFilter(request, mapQuery), this.getLinksFilter(request, mapQuery), asChildLinks);
    }

    protected EntityMBeanResponse getResponseEntityForMbean(HttpRequest request, MBeanAccessor.QueryBuilder queryBuilder, URI uriParent, URI uriSelf, Filter<String> filterAttributes, Filter<String> filterLinks, String ... asChildLinks) {
        try {
            EntityMBeanResponse responseEntity = this.createResponse(request, uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            Map<String, Map<String, Object>> mapResponses = accessor.getAttributes(queryBuilder.build());
            if (mapResponses.isEmpty()) {
                return null;
            }
            Map.Entry<String, Map<String, Object>> responseEntry = mapResponses.entrySet().iterator().next();
            responseEntity.setEntity(this.getMBeanAttributesMap(filterAttributes, responseEntry.getValue(), responseEntry.getKey()));
            if (asChildLinks != null) {
                Arrays.stream(asChildLinks).forEach(l -> responseEntity.addResourceLink((String)l, AbstractManagementResource.getSubUri(uriSelf, l)));
            }
            return responseEntity;
        }
        catch (Exception e) {
            Logger.warn("Exception occurred while getting response body for MBean with query " + String.valueOf(queryBuilder.build()), (Throwable)e);
            if (e instanceof HttpException) {
                throw (HttpException)e;
            }
            throw new HttpException();
        }
    }

    protected Response executeMBeanOperation(HttpRequest request, MBeanAccessor.QueryBuilder queryBuilder, String sOperationName, Object[] aoArguments, String[] asSignature) {
        try {
            Object obj;
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            Map<String, Object> mapMBeans = accessor.invoke(queryBuilder.build(), sOperationName, aoArguments, asSignature);
            if (mapMBeans.isEmpty()) {
                return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            if (!mapMBeans.isEmpty() && HttpMethod.GET.name().equals(request.getMethod().name()) && !"application/json".equals(request.getHeaderString("Accept")) && (obj = mapMBeans.get(mapMBeans.keySet().iterator().next())) instanceof String) {
                return Response.ok(new ByteArrayInputStream(((String)obj).getBytes(StandardCharsets.UTF_8))).build();
            }
        }
        catch (RuntimeException e) {
            Logger.warn("Exception occurred while executing an Mbean operation on query " + String.valueOf(queryBuilder.build()) + ", and operationName " + sOperationName, (Throwable)e);
            MBeanResponse response = new MBeanResponse(request);
            String sCause = "unknown, refer to log files for more information";
            Throwable tCause = Base.getOriginalException(e);
            if (tCause != null) {
                sCause = Base.getDeepMessage(tCause, "\n");
            }
            response.addFailure(sOperationName + " failed, Cause=" + sCause);
            if (this.isSecurityException(tCause)) {
                return Response.status(Response.Status.UNAUTHORIZED).entity(response.toJson()).build();
            }
            return Response.status(Response.Status.BAD_REQUEST).entity(response.toJson()).build();
        }
        return this.response(new MBeanResponse(request).toJson());
    }

    protected EntityMBeanResponse getResponseFromMBeanOperation(HttpRequest request, MBeanAccessor.QueryBuilder queryBuilder, String sResponseKey, String sOperationName) {
        return this.getResponseFromMBeanOperation(request, queryBuilder, sResponseKey, sOperationName, null, null);
    }

    protected EntityMBeanResponse getResponseFromMBeanOperation(HttpRequest request, MBeanAccessor.QueryBuilder queryBuilder, String sResponseKey, String sOperationName, Object[] aoArguments, String[] asSignature) {
        URI uriParent = this.getParentUri(request);
        URI uriSelf = this.getCurrentUri(request);
        Filter<String> filterLinks = this.getLinksFilter(request);
        Filter<String> filterAttributes = this.getAttributesFilter(request);
        try {
            EntityMBeanResponse responseBody = this.createResponse(request, uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            Map<String, Object> mapMBeans = accessor.invoke(queryBuilder.build(), sOperationName, aoArguments, asSignature);
            if (!mapMBeans.isEmpty()) {
                Map.Entry<String, Object> entry = mapMBeans.entrySet().iterator().next();
                LinkedHashMap<String, Object> mapResponse = new LinkedHashMap<String, Object>();
                if (filterAttributes.evaluate(sResponseKey.toUpperCase())) {
                    mapResponse.put(AbstractManagementResource.getRestName(sResponseKey), Converter.convert(entry.getValue()));
                }
                responseBody.setEntity(mapResponse);
            }
            return responseBody;
        }
        catch (RuntimeException e) {
            Logger.warn("Exception occurred while executing an Mbean operation on query" + queryBuilder.toString() + "and operationName " + sOperationName, (Throwable)e);
            EntityMBeanResponse responseBody = this.createResponse(request, uriParent, uriSelf, filterLinks);
            String sCause = "unknown, refer to log files for more information";
            Throwable tCause = Base.getOriginalException(e);
            if (tCause != null) {
                sCause = Base.getDeepMessage(tCause, "\n");
            }
            if (this.isSecurityException(tCause)) {
                responseBody.setSecurityException(true);
            }
            responseBody.addFailure(sOperationName + " failed, Cause=" + sCause);
            return responseBody;
        }
    }

    protected EntityMBeanResponse getResponseBodyForMBeanCollection(HttpRequest request, MBeanAccessor.QueryBuilder queryBuilder, AbstractManagementResource resource, String sUniqueKeyProperty, Map<String, Object> mapQuery, URI uriParent, URI uriSelf, URI uriCurrent, Map<String, String> mapArguments) {
        try {
            ArrayList<Map<String, Object>> listChildEntities;
            Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
            EntityMBeanResponse responseEntity = this.createResponse(request, uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            Set<String> setObjectNames = accessor.queryKeys(queryBuilder.build());
            if (setObjectNames != null && !setObjectNames.isEmpty()) {
                listChildEntities = new ArrayList<Map<String, Object>>();
                Set<ObjectName> setObjNames = AbstractManagementResource.convertToObjectNames(setObjectNames);
                Map<String, List<ObjectName>> mapMBeanToName = setObjNames.stream().collect(Collectors.groupingBy(o -> AbstractManagementResource.getObjectNameKey(o, sUniqueKeyProperty)));
                for (Map.Entry<String, List<ObjectName>> entry : mapMBeanToName.entrySet()) {
                    HashMap<String, String> mapChildResourceArgs = new HashMap<String, String>();
                    if (mapArguments != null) {
                        mapChildResourceArgs.putAll(mapArguments);
                    }
                    mapChildResourceArgs.put(sUniqueKeyProperty, entry.getKey());
                    EntityMBeanResponse response = resource.getQueryResult(request, uriSelf, uriCurrent, mapQuery, mapChildResourceArgs);
                    if (response == null) continue;
                    listChildEntities.add(response.toJson());
                }
            } else {
                return null;
            }
            responseEntity.setEntities(listChildEntities);
            return responseEntity;
        }
        catch (Exception e) {
            Logger.warn("Exception occurred while getting response for an MBean collection with query " + queryBuilder.build().getQuery(), (Throwable)e);
            throw new HttpException();
        }
    }

    private boolean isSecurityException(Throwable tCause) {
        return tCause instanceof SecurityException || tCause instanceof RuntimeException && tCause.getCause() instanceof WrapperException && ((WrapperException)tCause.getCause()).getRootCause() instanceof SecurityException;
    }

    private static String getObjectNameKey(ObjectName objectName, String sKey) {
        return String.valueOf(objectName.getKeyProperty(sKey));
    }

    protected EntityMBeanResponse getResponseBodyForMBeanCollection(HttpRequest request, MBeanAccessor.QueryBuilder queryBuilder, AbstractManagementResource resource, Map<String, Object> mapQuery, Map<String, String> mapArguments, URI uriParent, URI uriSelf, URI uriCurrent) {
        try {
            Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
            EntityMBeanResponse responseEntity = this.createResponse(request, uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            Map<String, Map<String, Object>> mapMBeans = accessor.getAttributes(queryBuilder.build());
            if (mapMBeans != null && !mapMBeans.isEmpty()) {
                ArrayList<Map<String, Object>> listChildEntities = new ArrayList<Map<String, Object>>();
                Filter<String> filterAttributes = this.getAttributesFilter(request, mapQuery);
                for (Map.Entry<String, Map<String, Object>> entry : mapMBeans.entrySet()) {
                    String sObjName = entry.getKey();
                    ObjectName objName = new ObjectName(sObjName);
                    HashMap<String, String> mapChildResourceArgs = new HashMap<String, String>();
                    if (mapArguments != null) {
                        mapChildResourceArgs.putAll(mapArguments);
                    }
                    mapChildResourceArgs.put(MEMBER_KEY, this.getMemberReference(objName));
                    EntityMBeanResponse response = resource.getQueryResult(request, uriSelf, uriCurrent, mapQuery, mapChildResourceArgs);
                    response.getEntity().putAll(this.getMBeanAttributesMap(filterAttributes, entry.getValue(), entry.getKey()));
                    listChildEntities.add(response.toJson());
                }
                responseEntity.setEntities(listChildEntities);
            }
            return responseEntity;
        }
        catch (Exception e) {
            Logger.warn("Exception occurred while getting response for an MBean collection with query " + String.valueOf(queryBuilder.build()), (Throwable)e);
            throw new HttpException();
        }
    }

    protected EntityMBeanResponse getResponseBodyForMBeanCollection(HttpRequest request, MBeanAccessor.QueryBuilder queryBuilder, String sUniqueKeyProperty, Map<String, Object> mapQuery, URI uriParent, URI uriSelf) {
        try {
            Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
            EntityMBeanResponse responseEntity = this.createResponse(request, uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            Map<String, Map<String, Object>> mapMBeans = accessor.getAttributes(queryBuilder.build());
            if (mapMBeans != null && !mapMBeans.isEmpty()) {
                ArrayList<Map<String, Object>> listChildEntities = new ArrayList<Map<String, Object>>();
                Filter<String> filterAttributes = this.getAttributesFilter(request, mapQuery);
                for (Map.Entry<String, Map<String, Object>> entry : mapMBeans.entrySet()) {
                    String sObjName = entry.getKey();
                    Map<String, Object> mapAttributes = entry.getValue();
                    ObjectName objectName = new ObjectName(entry.getKey());
                    URI uriSub = AbstractManagementResource.getSubUri(uriSelf, objectName.getKeyProperty(sUniqueKeyProperty));
                    EntityMBeanResponse responseEntityChild = this.createResponse(request, uriSelf, uriSub, filterLinks);
                    responseEntityChild.setEntity(this.getMBeanAttributesMap(filterAttributes, mapAttributes, sObjName));
                    listChildEntities.add(responseEntityChild.toJson());
                }
                responseEntity.setEntities(listChildEntities);
            }
            return responseEntity;
        }
        catch (Exception e) {
            Logger.warn("Exception occurred while getting response for an MBean collection with query " + String.valueOf(queryBuilder.build()), (Throwable)e);
            throw new HttpException();
        }
    }

    protected EntityMBeanResponse getResponseBodyForMBeanCollection(HttpRequest request, MBeanAccessor.QueryBuilder queryBuilder, Map<String, Object> mapQuery, URI uriParent, URI uriSelf) {
        try {
            Filter<String> filterLinks = this.getLinksFilter(request, mapQuery);
            EntityMBeanResponse responseEntity = this.createResponse(request, uriParent, uriSelf, filterLinks);
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            Map<String, Map<String, Object>> mapMBeans = accessor.getAttributes(queryBuilder.build());
            if (mapMBeans != null && !mapMBeans.isEmpty()) {
                ArrayList<Map<String, Object>> listChildEntities = new ArrayList<Map<String, Object>>();
                Filter<String> filterAttributes = this.getAttributesFilter(request, mapQuery);
                for (Map.Entry<String, Map<String, Object>> entry : mapMBeans.entrySet()) {
                    listChildEntities.add(this.getMBeanAttributesMap(filterAttributes, entry.getValue(), entry.getKey()));
                }
                responseEntity.setEntities(listChildEntities);
            }
            return responseEntity;
        }
        catch (Exception e) {
            Logger.warn("Exception occurred while getting response for an MBean collection with query " + String.valueOf(queryBuilder.build()), (Throwable)e);
            throw new HttpException();
        }
    }

    protected EntityMBeanResponse getLinksOnlyResponseBody(HttpRequest request, URI uriParent, URI uriSelf, Filter<String> filterLinks, String ... aChildLinks) {
        EntityMBeanResponse responseEntity = this.createResponse(request, uriParent, uriSelf, filterLinks);
        if (aChildLinks != null) {
            Arrays.stream(aChildLinks).forEach(l -> responseEntity.addResourceLink((String)l, AbstractManagementResource.getSubUri(uriSelf, l)));
        }
        return responseEntity;
    }

    protected EntityMBeanResponse getLinksOnlyResponseBody(HttpRequest request, URI uriParent, URI uriSelf, String ... aChildLinks) {
        return this.getLinksOnlyResponseBody(request, uriParent, uriSelf, this.getLinksFilter(request), aChildLinks);
    }

    protected Map<String, Object> getAggregatedMetrics(HttpRequest request, String sLocator, String sAttribute, String sCollector, MBeanAccessor.QueryBuilder queryBuilder) {
        try {
            MBeanAccessor accessor = this.ensureBeanAccessor(request);
            return accessor.aggregate(queryBuilder.build(), sLocator, sAttribute, sCollector);
        }
        catch (RuntimeException e) {
            Response.Status status = Response.Status.SERVICE_UNAVAILABLE;
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!(t instanceof IllegalArgumentException) && !(t instanceof AttributeNotFoundException)) continue;
                status = Response.Status.BAD_REQUEST;
            }
            if (status.equals(Response.Status.BAD_REQUEST)) {
                throw new HttpException(status.getStatusCode(), "HTTP " + status.getStatusCode() + " " + status.getReasonPhrase() + "\n" + e.getMessage());
            }
            Logger.warn("Exception occurred while aggregating metrics with query " + String.valueOf(queryBuilder.build()), (Throwable)e);
            throw new HttpException();
        }
    }

    protected EntityMBeanResponse getQueryResult(HttpRequest request, URI uriParent, URI uriCurrent, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        return null;
    }

    protected void addChildResourceQueryResult(HttpRequest request, AbstractManagementResource resource, String sChildResourceKey, Map<String, Object> mapResponse, Map<String, Object> mapQuery, Map<String, String> mapArguments) {
        EntityMBeanResponse responseEntity;
        URI uriParent = this.getParentUri(request);
        URI uriCurrent = this.getCurrentUri(request);
        Object childQueryEntity = mapQuery.get(sChildResourceKey);
        if (childQueryEntity instanceof Map && (responseEntity = resource.getQueryResult(request, uriParent, uriCurrent, (Map)childQueryEntity, mapArguments)) != null) {
            mapResponse.put(sChildResourceKey, responseEntity.toJson());
        }
    }

    protected void addChildMbeanQueryResult(HttpRequest request, URI parentURI, URI currentURI, String sChildKey, MBeanAccessor.QueryBuilder queryBuilder, Map<String, Object> mapResponse, Map mapQuery, String ... childLinks) {
        Map mapChildrenQuery;
        Filter<String> attributesFilter;
        EntityMBeanResponse responseEntity;
        Object oChildValue = mapQuery.get(sChildKey);
        if (oChildValue instanceof Map && (responseEntity = this.getResponseEntityForMbean(request, queryBuilder, parentURI, currentURI, attributesFilter = this.getAttributesFilter(request, mapChildrenQuery = (Map)oChildValue), this.getLinksFilter(request, mapChildrenQuery), childLinks)) != null) {
            mapResponse.put(sChildKey, responseEntity.toJson());
        }
    }

    protected void addAggregatedMetricsToResponseMap(HttpRequest request, String sRoleName, String sCollector, MBeanAccessor.QueryBuilder queryBuilder, Map<String, Object> mapResponse) {
        Map<String, Object> mapAggregatedMetrics = this.getAggregatedMetrics(request, sRoleName, null, sCollector, queryBuilder);
        Filter<String> filterAttributes = this.getAttributesFilter(request);
        for (Map.Entry<String, Object> entry : mapAggregatedMetrics.entrySet()) {
            String sAttributeKey = entry.getKey();
            if (!filterAttributes.evaluate(sAttributeKey.toUpperCase())) continue;
            mapResponse.put(AbstractManagementResource.getRestName(sAttributeKey), Converter.convert(entry.getValue()));
        }
    }

    protected Filter<String> getDomainPartitionFilter() {
        return this.m_filterDomainPartition;
    }

    protected String getMemberReference(ObjectName objName) {
        String sMemberName = objName.getKeyProperty(MEMBER);
        if (sMemberName != null) {
            return sMemberName;
        }
        return objName.getKeyProperty(MBeanAccessor.NODE_ID);
    }

    protected Object getChildrenQuery(Map<String, Object> mapQuery) {
        return mapQuery == null ? null : mapQuery.get(CHILDREN);
    }

    protected Map<String, Object> getMBeanAttributesMap(Filter<String> filterAttributes, Map<String, Object> mapResponse, String sObjName) throws Exception {
        LinkedHashMap<String, Object> mapAttributes = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : mapResponse.entrySet()) {
            String sAttrName = AbstractManagementResource.getRestName(entry.getKey());
            if (!filterAttributes.evaluate(sAttrName)) continue;
            mapAttributes.put(sAttrName, Converter.convert(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : new ObjectName(sObjName).getKeyPropertyList().entrySet()) {
            String sKey = AbstractManagementResource.getRestName(entry.getKey());
            if (!filterAttributes.evaluate(sKey)) continue;
            mapAttributes.putIfAbsent(sKey, entry.getValue());
        }
        return mapAttributes;
    }

    protected AttributeList getAttributeList(Map<String, Object> mapEntity) {
        return new AttributeList(mapEntity.entrySet().stream().map(e -> new Attribute(AbstractManagementResource.fromRestName((String)e.getKey()), e.getValue())).collect(Collectors.toList()));
    }

    protected Filter<String> getAttributesFilter(HttpRequest request) {
        QueryParameters queryParameters = request.getQueryParameters();
        String sIncludeFields = queryParameters.getFirst(INCLUDE_FIELDS);
        String sExcludeFields = queryParameters.getFirst(EXCLUDE_FIELDS);
        return this.getAttributesFilter(sIncludeFields, sExcludeFields);
    }

    protected Filter<String> getAttributesFilter(String sIncludeFields, String sExcludeFields) {
        Filter<String> filterAttributes = Filters.always();
        if (sIncludeFields != null) {
            Set setIncludedFields = Arrays.stream(sIncludeFields.split(",")).map(String::toUpperCase).collect(Collectors.toSet());
            filterAttributes = Filters.in(String::toUpperCase, setIncludedFields);
        }
        if (sExcludeFields != null) {
            Set setExcludedFields = Arrays.stream(sExcludeFields.split(",")).map(String::toUpperCase).collect(Collectors.toSet());
            NotFilter filterExclude = Filters.not(Filters.in(String::toUpperCase, setExcludedFields));
            filterAttributes = filterExclude.and(filterAttributes);
        }
        return filterAttributes;
    }

    protected Filter<String> getLinksFilter(HttpRequest request) {
        QueryParameters queryParameters = request.getQueryParameters();
        String sIncludeLinks = queryParameters.getFirst(INCLUDE_LINKS);
        String sExcludeLinks = queryParameters.getFirst(EXCLUDE_LINKS);
        Filter<String> filterLinks = Filters.always();
        if (sIncludeLinks != null) {
            Set setIncludedLinks = Arrays.stream(sIncludeLinks.split(",")).collect(Collectors.toSet());
            filterLinks = Filters.in(ValueExtractor.identity(), setIncludedLinks);
        }
        if (sExcludeLinks != null) {
            Set setExcludedLinks = Arrays.stream(sExcludeLinks.split(",")).collect(Collectors.toSet());
            NotFilter filterExclude = Filters.not(Filters.in(ValueExtractor.identity(), setExcludedLinks));
            filterLinks = filterExclude.and(filterLinks);
        }
        return filterLinks;
    }

    protected Filter<String> getAttributesFilter(HttpRequest request, Map mapQuery) {
        if (mapQuery == null) {
            return this.getAttributesFilter(request);
        }
        List listIncludeFields = (List)mapQuery.get(INCLUDE_FIELDS);
        List listExcludeFields = (List)mapQuery.get(EXCLUDE_FIELDS);
        Filter<String> filterAttributes = Filters.always();
        if (listIncludeFields != null) {
            Set setIncludedFields = listIncludeFields.stream().map(String::toUpperCase).collect(Collectors.toSet());
            filterAttributes = Filters.in(String::toUpperCase, setIncludedFields);
        }
        if (listExcludeFields != null) {
            Set setExcludedFields = listExcludeFields.stream().map(String::toUpperCase).collect(Collectors.toSet());
            NotFilter filterExclude = Filters.not(Filters.in(String::toUpperCase, setExcludedFields));
            filterAttributes = filterExclude.and(filterAttributes);
        }
        return filterAttributes;
    }

    protected Filter<String> getLinksFilter(HttpRequest request, Map mapQuery) {
        if (mapQuery == null) {
            return this.getLinksFilter(request);
        }
        List listIncludeLinks = (List)mapQuery.get(INCLUDE_LINKS);
        List listExcludeLinks = (List)mapQuery.get(EXCLUDE_LINKS);
        Filter<String> filterLinks = Filters.always();
        if (listIncludeLinks != null) {
            HashSet setIncludedLinks = new HashSet(listIncludeLinks);
            filterLinks = Filters.in(ValueExtractor.identity(), setIncludedLinks);
        }
        if (listExcludeLinks != null) {
            Set setExcludedLinks = listExcludeLinks.stream().map(AbstractManagementResource::fromRestName).collect(Collectors.toSet());
            NotFilter filterExclude = Filters.not(Filters.in(ValueExtractor.identity(), setExcludedLinks));
            filterLinks = filterExclude.and(filterLinks);
        }
        return filterLinks;
    }

    protected String getExcludeList(HttpRequest request) {
        return this.getExcludeList(request, null);
    }

    protected String getExcludeList(HttpRequest request, Map mapQuery) {
        if (mapQuery == null) {
            return request.getQueryParameters().getFirst(EXCLUDE_FIELDS);
        }
        List listExcludeFields = (List)mapQuery.get(EXCLUDE_FIELDS);
        return listExcludeFields == null ? null : String.join((CharSequence)",", listExcludeFields);
    }

    protected EntityMBeanResponse createResponse(HttpRequest request, URI parentUri, URI selfUri, Filter<String> linksFilter) {
        EntityMBeanResponse responseBody = new EntityMBeanResponse(request, linksFilter);
        responseBody.addParentResourceLink(parentUri);
        responseBody.addSelfResourceLinks(selfUri);
        return responseBody;
    }

    protected Response response(EntityMBeanResponse responseEntity) {
        if (responseEntity == null) {
            return Response.notFound().build();
        }
        if (responseEntity.isSecurityException()) {
            return Response.status(Response.Status.UNAUTHORIZED).entity(responseEntity.toJson()).build();
        }
        if (responseEntity.hasFailures()) {
            return Response.status(Response.Status.BAD_REQUEST).entity(responseEntity.toJson()).build();
        }
        if (responseEntity.isEmpty()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        return Response.ok(responseEntity.toJson()).build();
    }

    public void setDomainPartitionFilter(Filter<String> filter) {
        this.m_filterDomainPartition = filter;
    }

    protected Response response(Map<String, Object> mapResponse) {
        return Response.ok(mapResponse).build();
    }

    protected void checkAttributeTypeConversion(Map<String, Object> entity) {
        this.checkAttributeTypeConversion(entity, false);
    }

    protected void checkAttributeTypeConversion(Map<String, Object> entity, boolean fManagement) {
        entity.replaceAll((k, v) -> {
            Class<Object> clzConvertTo = Object.class;
            try {
                if ((SET_LONG.contains(k) || fManagement && k.compareToIgnoreCase("expiryDelay") == 0) && !(v instanceof Long)) {
                    clzConvertTo = Long.TYPE;
                    return Long.valueOf(v.toString());
                }
                if (SET_INTEGER.contains(k) && !(v instanceof Integer)) {
                    clzConvertTo = Integer.TYPE;
                    return Integer.valueOf(v.toString());
                }
                if (SET_FLOAT.contains(k) && !(v instanceof Float)) {
                    clzConvertTo = Float.TYPE;
                    return Float.valueOf(v.toString());
                }
                return v;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid value for attribute " + k + "; failed type conversion to " + clzConvertTo.getName() + " due to " + e.getClass().getName() + " " + e.getMessage(), e);
            }
        });
    }

    protected String getService(HttpRequest request) {
        return request.getPathParameters().getFirst(SERVICE_NAME);
    }

    public URI getParentUri(HttpRequest request) {
        URI uri = request.getRequestURI();
        String sRawPath = uri.getRawPath();
        if (sRawPath.charAt(sRawPath.length() - 1) == '/') {
            sRawPath = sRawPath.substring(0, sRawPath.length() - 1);
        }
        StringBuilder sPath = new StringBuilder();
        String[] asSegment = sRawPath.split("/");
        for (int i = 0; i < asSegment.length - 1; ++i) {
            if (i > 0) {
                sPath.append('/');
            }
            sPath.append(asSegment[i]);
        }
        return AbstractManagementResource.replacePath(request.getBaseURI(), sPath.toString());
    }

    protected URI getCurrentUri(HttpRequest request) {
        URI uri = request.getRequestURI();
        String sPath = uri.getRawPath();
        if (sPath.endsWith("/")) {
            sPath = sPath.substring(0, sPath.length() - 1);
        }
        return uri.resolve(URI.create(sPath));
    }

    protected String getMBeanDomainName() {
        return AbstractManagementResource.ensureMBeanDomainName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String ensureMBeanDomainName() {
        if (s_sMBeanDomainName != null) return s_sMBeanDomainName;
        Class<AbstractManagementResource> clazz = AbstractManagementResource.class;
        synchronized (AbstractManagementResource.class) {
            if (s_sMBeanDomainName != null) return s_sMBeanDomainName;
            Registry registry = CacheFactory.getCluster().getManagement();
            String sDomainName = registry.getDomainName();
            s_sMBeanDomainName = sDomainName == null || sDomainName.isEmpty() ? "Coherence*" : sDomainName;
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_sMBeanDomainName;
        }
    }

    protected static URI replacePath(URI uri, String sPath) {
        String sFragment;
        String sQuery = uri.getRawQuery();
        if (sQuery != null && sQuery.length() > 0) {
            sPath = (String)sPath + "?" + sQuery;
        }
        if ((sFragment = uri.getRawFragment()) != null && sFragment.length() > 0) {
            sPath = (String)sPath + "#" + sFragment;
        }
        return uri.resolve(URI.create((String)sPath));
    }

    public static String getRestName(String sName) {
        int count;
        for (count = 0; count < sName.length() && Character.isUpperCase(sName.charAt(count)); ++count) {
        }
        if (count == sName.length()) {
            return sName;
        }
        if (count == 0) {
            return sName;
        }
        if (count == 1) {
            return sName.substring(0, count).toLowerCase() + sName.substring(count);
        }
        return sName;
    }

    public static String fromRestName(String sName) {
        return sName.substring(0, 1).toUpperCase() + sName.substring(1);
    }

    public static URI getSubUri(URI uriParent, String ... asSegments) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(uriParent.getPath());
            for (String segment : asSegments) {
                int cSlash = segment.indexOf(47);
                if (cSlash == -1) {
                    builder.append("/").append(segment);
                    continue;
                }
                for (String sPart : PATH_PATTERN.split(segment)) {
                    builder.append("/").append(sPart);
                }
            }
            String sEncoded = AbstractManagementResource.encodePath(builder.toString());
            return uriParent.resolve(sEncoded);
        }
        catch (URISyntaxException e) {
            throw Exceptions.ensureRuntimeException(e);
        }
    }

    private static String encodePath(String sPath) throws URISyntaxException {
        return new URI("http", "localhost", sPath, null).getRawPath();
    }

    public static Set<ObjectName> convertToObjectNames(Set<String> setObjectNames) throws MalformedObjectNameException {
        HashSet<ObjectName> setObjNames = new HashSet<ObjectName>();
        for (String sObjectName : setObjectNames) {
            setObjNames.add(new ObjectName(sObjectName));
        }
        return setObjNames;
    }

    protected MBeanAccessor.QueryBuilder createQueryBuilder(HttpRequest request) {
        String sCluster = this.getClusterName(request);
        return this.createQueryBuilder(sCluster);
    }

    protected MBeanAccessor.QueryBuilder createQueryBuilder(String sCluster) {
        String sDomain = this.getMBeanDomainName();
        MBeanAccessor.QueryBuilder queryBuilder = new MBeanAccessor.QueryBuilder().withMBeanDomainName(sDomain).withCluster(sCluster);
        Filter<String> filter = this.getDomainPartitionFilter();
        if (filter != null) {
            queryBuilder.withFilter(DOMAIN_PARTITION, this.getDomainPartitionFilter());
        }
        return queryBuilder;
    }

    protected MBeanAccessor.QueryBuilder createHealthQueryBuilder(HttpRequest request) {
        String sSubType = request.getFirstPathParameter(SUB_TYPE);
        String sName = request.getFirstPathParameter(NAME);
        return this.createHealthQueryBuilder(request, sSubType, sName);
    }

    protected MBeanAccessor.QueryBuilder createHealthQueryBuilder(HttpRequest request, String sSubType, String sName) {
        if (sSubType == null || sSubType.isEmpty()) {
            sSubType = "*";
        }
        if (sName == null || sName.isEmpty()) {
            sName = "*";
        }
        return this.createQueryBuilder(request).withBaseQuery(String.format(HEALTH_NAMED_QUERY, sSubType, sName));
    }

    protected String getClusterName(HttpRequest request) {
        String sCluster = request.getFirstPathParameter(CLUSTER_NAME);
        if (sCluster == null || sCluster.isEmpty()) {
            sCluster = request.getResourceRegistry().getResource(String.class, CLUSTER_NAME);
        }
        if (sCluster == null || sCluster.isEmpty()) {
            Cluster cluster = CacheFactory.getCluster();
            Registry management = cluster.getManagement();
            boolean fExtended = management.isExtendedMBeanName();
            sCluster = fExtended ? cluster.getLocalMember().getClusterName() : null;
        }
        return sCluster;
    }

    protected MBeanAccessor ensureBeanAccessor(HttpRequest request) {
        MBeanAccessor accessor = this.m_accessor;
        if (accessor == null) {
            MBeanServerProxy proxy = request.getResourceRegistry().getResource(MBeanServerProxy.class);
            if (proxy == null) {
                proxy = CacheFactory.getCluster().getManagement().getMBeanServerProxy();
            }
            accessor = this.m_accessor = new MBeanAccessor(proxy);
        }
        return accessor;
    }

    protected boolean isFederatedServiceMemberValid(HttpRequest request) {
        String sServiceName = request.getFirstPathParameter(SERVICE_NAME);
        String sMemberKey = request.getFirstPathParameter(MEMBER_KEY);
        HashSet<MBeanAccessor.QueryBuilder> setQueries = new HashSet<MBeanAccessor.QueryBuilder>();
        setQueries.add(this.createQueryBuilder(request).withBaseQuery(FEDERATION_COORDINATOR_QUERY).withService(sServiceName));
        setQueries.add(this.createQueryBuilder(request).withBaseQuery(SERVICE_MEMBERS_QUERY + sServiceName).withMember(sMemberKey));
        for (MBeanAccessor.QueryBuilder queryBuilder : setQueries) {
            EntityMBeanResponse response = this.getResponseEntityForMbean(request, queryBuilder, this.getParentUri(request), this.getCurrentUri(request), this.getAttributesFilter(request), this.getLinksFilter(request), new String[0]);
            if (response != null && !response.hasFailures() && !response.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static {
        s_sMBeanDomainName = null;
    }
}

