/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.resources.ClusterResource;
import com.tangosol.internal.management.resources.VersionsResource;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.util.BuilderHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class ManagementRoutes
extends RequestRouter
implements RequestRouter.RequestPreprocessor {
    public static final String APPLICATION_JSON = "application/json";
    public static final String CLUSTER = "/cluster";
    private String m_sClusterName;
    private Filter<String> m_domainPartitionFilter;

    public ManagementRoutes() {
        this(CLUSTER, false, Collections::emptySet, "/mgmt/coherence", "/management/coherence");
    }

    public ManagementRoutes(String sPath, String ... roots) {
        this(sPath, false, Collections::emptySet, roots);
    }

    public ManagementRoutes(String sPath, boolean fVersioned, Supplier<Set<String>> supplier, String ... roots) {
        super(roots);
        this.setDefaultProduces(APPLICATION_JSON);
        this.setDefaultConsumes(APPLICATION_JSON);
        this.addRequestPreprocessor(this);
        this.addDefaultResponseHeader("X-Content-Type-Options", "nosniff");
        this.addDefaultResponseHeader("Content-type", APPLICATION_JSON);
        this.addDefaultResponseHeader("Vary", "Accept-Encoding");
        if (fVersioned) {
            this.addRoutes(sPath, new VersionsResource(supplier));
        } else {
            this.addRoutes(sPath, new ClusterResource());
        }
    }

    public void setClusterName(String sClusterName) {
        this.m_sClusterName = sClusterName;
    }

    public void setDomainPartitionFilter(Filter<String> domainPartitionFilter) {
        this.m_domainPartitionFilter = domainPartitionFilter;
    }

    @Override
    public Optional<Response> process(HttpRequest request) {
        ResourceRegistry registry = request.getResourceRegistry();
        MBeanServerProxy proxy = CacheFactory.getCluster().getManagement().getMBeanServerProxy();
        registry.registerResource(MBeanServerProxy.class, MBeanServerProxy.class.getName(), BuilderHelper.using(proxy), RegistrationBehavior.IGNORE, null);
        if (this.m_sClusterName != null) {
            registry.registerResource(String.class, "clusterName", this.m_sClusterName);
        }
        if (this.m_domainPartitionFilter != null) {
            registry.registerResource(Filter.class, "domainPartitionFilter", this.m_domainPartitionFilter);
        }
        return Optional.empty();
    }
}

