/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.io.pof;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class JavaCollectionsSupport {

    public static class SortedMapSerializer<K, V>
    implements PofSerializer<SortedMap<K, V>> {
        @Override
        public void serialize(PofWriter out, SortedMap<K, V> map) throws IOException {
            out.writeObject(0, map.comparator());
            out.writeMap(1, map);
            out.writeRemainder(null);
        }

        @Override
        public SortedMap<K, V> deserialize(PofReader in) throws IOException {
            Comparator comparator = (Comparator)in.readObject(0);
            SortedMap map = in.readMap(1, new TreeMap(comparator));
            in.readRemainder();
            return map;
        }
    }

    public static class SortedSetSerializer<T>
    implements PofSerializer<SortedSet<T>> {
        @Override
        public void serialize(PofWriter out, SortedSet<T> set) throws IOException {
            out.writeObject(0, set.comparator());
            out.writeCollection(1, set);
            out.writeRemainder(null);
        }

        @Override
        public SortedSet<T> deserialize(PofReader in) throws IOException {
            Comparator comparator = (Comparator)in.readObject(0);
            SortedSet set = in.readCollection(1, new TreeSet(comparator));
            in.readRemainder();
            return set;
        }
    }
}

