/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.http;

import com.sun.net.httpserver.Headers;
import com.tangosol.io.WriteBuffer;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Response {
    private final StatusType f_status;
    private final Object f_oEntity;
    private final Headers f_headers = new Headers();

    private Response(StatusType status, Object oEntity) {
        this.f_status = status;
        this.f_oEntity = oEntity;
    }

    public StatusType getStatus() {
        return this.f_status;
    }

    public Object getEntity() {
        return this.f_oEntity;
    }

    public Headers getHeaders() {
        return this.f_headers;
    }

    Response addHeaders(Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String sKey = entry.getKey();
            for (String sValue : entry.getValue()) {
                this.f_headers.add(sKey, sValue);
            }
        }
        return this;
    }

    Response addHeadersIfNotPresent(Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String sKey = entry.getKey();
            for (String sValue : entry.getValue()) {
                this.f_headers.putIfAbsent(sKey, Collections.singletonList(sValue));
            }
        }
        return this;
    }

    public Builder toBuilder() {
        return new Builder().status(this.f_status).setEntity(this.f_oEntity).addHeaders(this.f_headers);
    }

    public static Builder status(int nStatus) {
        return new Builder().status(nStatus);
    }

    public static Builder status(StatusType status) {
        return new Builder().status(status);
    }

    public static Builder ok() {
        return Response.status(Status.OK);
    }

    public static Builder ok(Map<String, Object> entity) {
        return Response.ok().entity(entity);
    }

    public static Builder ok(InputStream entity) {
        return Response.ok().entity(entity);
    }

    public static Builder ok(WriteBuffer entity) {
        return Response.ok().entity(entity);
    }

    public static Builder notFound() {
        return Response.status(Status.NOT_FOUND);
    }

    public static Builder serverError() {
        return Response.status(Status.INTERNAL_SERVER_ERROR);
    }

    public static interface StatusType {
        public Status.Family getFamily();

        public int getStatusCode();

        public String getReasonPhrase();
    }

    public static class Builder {
        private StatusType m_status = Status.OK;
        private Object m_oEntity;
        private Headers m_headers = new Headers();

        private Builder() {
        }

        public Response build() {
            return new Response(this.m_status, this.m_oEntity);
        }

        public Builder entity(Map<String, Object> mapEntity) {
            return this.setEntity(mapEntity);
        }

        public Builder entity(InputStream stream) {
            return this.setEntity(stream);
        }

        public Builder entity(WriteBuffer buf) {
            return this.setEntity(buf);
        }

        public Builder entity(String sEntity) {
            return this.setEntity(sEntity);
        }

        private Builder setEntity(Object oEntity) {
            this.m_oEntity = oEntity;
            return this;
        }

        public Builder status(int nStatus) {
            Status statusType = Status.fromStatusCode(nStatus);
            if (statusType == null) {
                throw new IllegalArgumentException("Cannot map status " + nStatus + " to a Status enum value");
            }
            return this.status(statusType);
        }

        public Builder status(StatusType status) {
            this.m_status = Objects.requireNonNull(status);
            return this;
        }

        public Builder addHeaders(Map<String, List<String>> mapHeaders) {
            for (Map.Entry<String, List<String>> entry : mapHeaders.entrySet()) {
                String sKey = entry.getKey();
                for (String sValue : entry.getValue()) {
                    this.m_headers.add(sKey, sValue);
                }
            }
            return this;
        }
    }

    public static enum Status implements StatusType
    {
        OK(200, "OK"),
        CREATED(201, "Created"),
        ACCEPTED(202, "Accepted"),
        NO_CONTENT(204, "No Content"),
        RESET_CONTENT(205, "Reset Content"),
        PARTIAL_CONTENT(206, "Partial Content"),
        MOVED_PERMANENTLY(301, "Moved Permanently"),
        FOUND(302, "Found"),
        SEE_OTHER(303, "See Other"),
        NOT_MODIFIED(304, "Not Modified"),
        USE_PROXY(305, "Use Proxy"),
        TEMPORARY_REDIRECT(307, "Temporary Redirect"),
        BAD_REQUEST(400, "Bad Request"),
        UNAUTHORIZED(401, "Unauthorized"),
        PAYMENT_REQUIRED(402, "Payment Required"),
        FORBIDDEN(403, "Forbidden"),
        NOT_FOUND(404, "Not Found"),
        METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
        NOT_ACCEPTABLE(406, "Not Acceptable"),
        PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
        REQUEST_TIMEOUT(408, "Request Timeout"),
        CONFLICT(409, "Conflict"),
        GONE(410, "Gone"),
        LENGTH_REQUIRED(411, "Length Required"),
        PRECONDITION_FAILED(412, "Precondition Failed"),
        REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
        REQUEST_URI_TOO_LONG(414, "Request-URI Too Long"),
        UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
        REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
        EXPECTATION_FAILED(417, "Expectation Failed"),
        PRECONDITION_REQUIRED(428, "Precondition Required"),
        TOO_MANY_REQUESTS(429, "Too Many Requests"),
        REQUEST_HEADER_FIELDS_TOO_LARGE(431, "Request Header Fields Too Large"),
        INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
        NOT_IMPLEMENTED(501, "Not Implemented"),
        BAD_GATEWAY(502, "Bad Gateway"),
        SERVICE_UNAVAILABLE(503, "Service Unavailable"),
        GATEWAY_TIMEOUT(504, "Gateway Timeout"),
        HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version Not Supported"),
        NETWORK_AUTHENTICATION_REQUIRED(511, "Network Authentication Required");

        private final int f_nStatusCode;
        private final String f_sReason;
        private final Family f_family;

        private Status(int statusCode, String reasonPhrase) {
            this.f_nStatusCode = statusCode;
            this.f_sReason = reasonPhrase;
            this.f_family = Family.familyOf(statusCode);
        }

        @Override
        public Family getFamily() {
            return this.f_family;
        }

        @Override
        public int getStatusCode() {
            return this.f_nStatusCode;
        }

        @Override
        public String getReasonPhrase() {
            return this.toString();
        }

        public String toString() {
            return this.f_sReason;
        }

        public static Status fromStatusCode(int statusCode) {
            for (Status s : Status.values()) {
                if (s.f_nStatusCode != statusCode) continue;
                return s;
            }
            return null;
        }

        public static enum Family {
            INFORMATIONAL,
            SUCCESSFUL,
            REDIRECTION,
            CLIENT_ERROR,
            SERVER_ERROR,
            OTHER;


            public static Family familyOf(int statusCode) {
                switch (statusCode / 100) {
                    case 1: {
                        return INFORMATIONAL;
                    }
                    case 2: {
                        return SUCCESSFUL;
                    }
                    case 3: {
                        return REDIRECTION;
                    }
                    case 4: {
                        return CLIENT_ERROR;
                    }
                    case 5: {
                        return SERVER_ERROR;
                    }
                }
                return OTHER;
            }
        }
    }
}

