/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.http;

import com.oracle.coherence.common.base.Logger;
import com.sun.net.httpserver.Headers;
import com.tangosol.internal.http.HttpException;
import com.tangosol.internal.http.HttpMethod;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RegexPathParameters;
import com.tangosol.internal.http.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class RequestRouter {
    private static final RequestHandler[] NO_HANDLERS = new RequestHandler[0];
    private final List<String> f_listRootPaths;
    private final Map<HttpMethod, Map<String, List<Endpoint>>> f_mapRoutes = new HashMap<HttpMethod, Map<String, List<Endpoint>>>();
    private final Map<HttpMethod, Map<Pattern, List<Endpoint>>> f_mapRegexRoutes = new HashMap<HttpMethod, Map<Pattern, List<Endpoint>>>();
    private String[] m_asProduces = new String[0];
    private String[] m_asConsumes = new String[0];
    private final Headers f_commonResponseHeaders = new Headers();
    private final List<RequestPreprocessor> f_listRequestPreprocessor = new ArrayList<RequestPreprocessor>();
    private final List<RequestHandlerPreprocessor> f_listRequestHandlerPreprocessor = new ArrayList<RequestHandlerPreprocessor>();

    public RequestRouter(String ... asRoots) {
        this.f_listRootPaths = asRoots == null || asRoots.length == 0 ? Collections.emptyList() : Arrays.stream(asRoots).filter(s -> !"/".equals(s)).filter(s -> s.length() > 0).map(RequestRouter::validatePath).distinct().collect(Collectors.toList());
    }

    public void setDefaultConsumes(String ... asMediaTypes) {
        this.m_asConsumes = asMediaTypes;
    }

    public void setDefaultProduces(String ... asMediaTypes) {
        this.m_asProduces = asMediaTypes;
    }

    public void addDefaultResponseHeader(String sKey, String sValue) {
        this.f_commonResponseHeaders.add(sKey, sValue);
    }

    public void addRequestPreprocessor(RequestPreprocessor processor) {
        this.f_listRequestPreprocessor.add(processor);
    }

    public void addRequestHandlerPreprocessor(RequestHandlerPreprocessor processor) {
        this.f_listRequestHandlerPreprocessor.add(processor);
    }

    public Endpoint addGet(String sPath, RequestHandler handler) {
        return this.addRoute(HttpMethod.GET, sPath, handler);
    }

    public Endpoint addGet(String sPath, SimpleRequestHandler handler) {
        return this.addRoute(HttpMethod.GET, sPath, handler);
    }

    public Endpoint addPost(String sPath, RequestHandler handler) {
        return this.addRoute(HttpMethod.POST, sPath, handler);
    }

    public Endpoint addPut(String sPath, RequestHandler handler) {
        return this.addRoute(HttpMethod.PUT, sPath, handler);
    }

    public Endpoint addDelete(String sPath, RequestHandler handler) {
        return this.addRoute(HttpMethod.DELETE, sPath, handler);
    }

    public Endpoint addRoute(HttpMethod method, String sPath, RequestHandler handler) {
        if (((String)sPath).isEmpty() || ((String)sPath).charAt(0) != '/') {
            sPath = "/" + (String)sPath;
        }
        Endpoint endpoint = new Endpoint(handler).produces(this.m_asProduces);
        if (method == HttpMethod.POST || method == HttpMethod.PUT) {
            endpoint.consumes(this.m_asConsumes);
        }
        if (((String)sPath).contains("{")) {
            String[] asSegment = ((String)sPath).split("/");
            StringBuilder s = new StringBuilder();
            for (int i = 1; i < asSegment.length; ++i) {
                s.append('/');
                String sSegment = asSegment[i];
                int cChar = sSegment.length();
                if (sSegment.charAt(0) == '{' && sSegment.charAt(cChar - 1) == '}') {
                    String sName = sSegment.substring(1, sSegment.length() - 1);
                    s.append("(?<").append(sName).append(">((?!/).)+)");
                    if (i + 1 != asSegment.length) continue;
                    s.append("(/?)");
                    continue;
                }
                s.append(sSegment);
            }
            this.f_mapRegexRoutes.computeIfAbsent(method, k -> new HashMap()).compute(Pattern.compile(s.toString()), (k, list) -> {
                if (list == null) {
                    list = new ArrayList<Endpoint>();
                }
                list.add(endpoint);
                return list;
            });
        } else {
            this.f_mapRoutes.computeIfAbsent(method, k -> new HashMap()).compute(sPath, (k, list) -> {
                if (list == null) {
                    list = new ArrayList<Endpoint>();
                }
                list.add(endpoint);
                return list;
            });
        }
        return endpoint;
    }

    public void addRoutes(String sRootPath, Routes routes) {
        routes.addRoutes(this, sRootPath);
    }

    public Response route(HttpRequest request) {
        Response response;
        try {
            Map<Pattern, List<Endpoint>> mapRegexHandler;
            List<Endpoint> listEndpoint;
            Map<String, List<Endpoint>> mapEndpoint;
            int nBase;
            if (!this.f_listRequestPreprocessor.isEmpty()) {
                for (RequestPreprocessor processor : this.f_listRequestPreprocessor) {
                    Optional<Response> opt = processor.process(request);
                    if (!opt.isPresent()) continue;
                    return opt.get();
                }
            }
            RequestHandler[] aHandlerExact = NO_HANDLERS;
            RequestHandler[] aHandlerRegEx = NO_HANDLERS;
            boolean fMatchedPath = false;
            URI uri = request.getRequestURI();
            String sPath = uri.getPath();
            String sRoot = this.f_listRootPaths.stream().filter(sPath::startsWith).findFirst().orElse("");
            if ((sRoot == null || sRoot.length() == 0) && (nBase = request.getBaseURI().getPath().length()) > 1) {
                sPath = uri.getPath().substring(nBase - 1);
                sRoot = this.f_listRootPaths.stream().filter(sPath::startsWith).findFirst().orElse("");
            }
            sPath = sPath.substring(sRoot.length());
            while (sPath.endsWith("/") && sPath.length() != 1) {
                sPath = sPath.substring(0, sPath.length() - 1);
            }
            if (sPath.isEmpty()) {
                sPath = "/";
            }
            if ((mapEndpoint = this.f_mapRoutes.get((Object)request.getMethod())) != null && (listEndpoint = mapEndpoint.get(sPath)) != null && !listEndpoint.isEmpty()) {
                fMatchedPath = true;
                aHandlerExact = (RequestHandler[])listEndpoint.stream().filter(e -> this.matchesMediaTypes(request, (Endpoint)e)).map(Endpoint::getHandler).toArray(RequestHandler[]::new);
            }
            if ((mapRegexHandler = this.f_mapRegexRoutes.get((Object)request.getMethod())) != null) {
                ArrayList listMatched = new ArrayList();
                Matcher matcherMatched = null;
                for (Map.Entry<Pattern, List<Endpoint>> entry : mapRegexHandler.entrySet()) {
                    List list;
                    List<Endpoint> listEndpoint2;
                    Matcher matcher = entry.getKey().matcher(sPath);
                    if (!matcher.matches()) continue;
                    fMatchedPath = true;
                    if (matcherMatched != null && matcher.groupCount() > matcherMatched.groupCount() || (listEndpoint2 = entry.getValue()) == null || listEndpoint2.isEmpty() || (list = listEndpoint2.stream().filter(e -> this.matchesMediaTypes(request, (Endpoint)e)).map(Endpoint::getHandler).map(h -> new RegExRequestHandler((RequestHandler)h, matcher)).collect(Collectors.toList())).size() <= 0) continue;
                    if (matcherMatched == null || matcher.groupCount() < matcherMatched.groupCount()) {
                        listMatched.clear();
                        matcherMatched = matcher;
                    }
                    listMatched.addAll(list);
                }
                aHandlerRegEx = listMatched.toArray(new RequestHandler[0]);
            }
            if (aHandlerExact.length == 0 && aHandlerRegEx.length == 0) {
                response = fMatchedPath ? Response.status(Response.Status.UNSUPPORTED_MEDIA_TYPE).build() : Response.notFound().build();
            } else if (aHandlerExact.length == 1) {
                for (RequestHandlerPreprocessor processor : this.f_listRequestHandlerPreprocessor) {
                    processor.process(request, aHandlerExact[0]);
                }
                response = aHandlerExact[0].handle(request);
            } else if (aHandlerRegEx.length == 1) {
                for (RequestHandlerPreprocessor processor : this.f_listRequestHandlerPreprocessor) {
                    processor.process(request, aHandlerRegEx[0]);
                }
                response = aHandlerRegEx[0].handle(request);
            } else {
                Logger.err("Found too many endpoints matching http request path='" + sPath + " mediaType=");
                response = Response.notFound().build();
            }
        }
        catch (HttpException e2) {
            response = Response.status(e2.getStatus()).entity(e2.getMessage()).build();
        }
        catch (Throwable e3) {
            Logger.err(e3);
            response = Response.serverError().build();
        }
        return response.addHeadersIfNotPresent(this.f_commonResponseHeaders);
    }

    public void dumpRoutes() {
        TreeSet setEndpoint = new TreeSet();
        for (HttpMethod method : HttpMethod.values()) {
            for (String sRoot : this.f_listRootPaths) {
                this.f_mapRoutes.getOrDefault((Object)method, Collections.emptyMap()).keySet().forEach(s -> setEndpoint.add(method.name() + ": " + sRoot + s));
                this.f_mapRegexRoutes.getOrDefault((Object)method, Collections.emptyMap()).keySet().stream().map(Pattern::pattern).forEach(s -> setEndpoint.add(method.name() + ": " + sRoot + s));
            }
        }
        Logger.info("Routes:");
        setEndpoint.forEach(s -> Logger.info("    " + s));
    }

    private boolean matchesMediaTypes(HttpRequest request, Endpoint endpoint) {
        return true;
    }

    private static String validatePath(String sPath) {
        if (((String)sPath).charAt(0) != '/') {
            sPath = "/" + (String)sPath;
        }
        if (((String)sPath).charAt(((String)sPath).length() - 1) == '/') {
            sPath = ((String)sPath).substring(0, ((String)sPath).length() - 1);
        }
        return sPath;
    }

    @FunctionalInterface
    public static interface RequestHandler {
        public Response handle(HttpRequest var1);
    }

    public static class Endpoint {
        private final RequestHandler f_handler;
        private RequestHandlerPreprocessor[] f_aPreProcessor;
        private String[] m_asProduces;
        private String[] m_asConsumes;

        public Endpoint(RequestHandler handler) {
            this.f_handler = handler;
        }

        public RequestHandler getHandler() {
            return this.f_handler;
        }

        public Endpoint consumes(String ... asMediaType) {
            this.m_asConsumes = asMediaType;
            return this;
        }

        public String[] getConsumes() {
            return this.m_asConsumes;
        }

        public Endpoint produces(String ... asMediaType) {
            this.m_asProduces = asMediaType;
            return this;
        }

        public String[] getProduces() {
            return this.m_asProduces;
        }

        public Endpoint requestPreProcessors(RequestHandlerPreprocessor ... processors) {
            this.f_aPreProcessor = processors;
            return this;
        }

        public RequestHandlerPreprocessor[] getRequestPreProcessors() {
            return this.f_aPreProcessor;
        }
    }

    public static interface Routes {
        public void addRoutes(RequestRouter var1, String var2);
    }

    public static interface RequestPreprocessor {
        public Optional<Response> process(HttpRequest var1);
    }

    public static interface RequestHandlerPreprocessor {
        public void process(HttpRequest var1, RequestHandler var2);
    }

    public class RegExRequestHandler
    implements RequestHandler {
        private final RequestHandler m_handler;
        private final Matcher m_matcher;

        public RegExRequestHandler(RequestHandler handler, Matcher matcher) {
            this.m_handler = handler;
            this.m_matcher = matcher;
        }

        @Override
        public Response handle(HttpRequest request) {
            request.setPathParameters(new RegexPathParameters(this.m_matcher));
            return this.m_handler.handle(request);
        }
    }

    @FunctionalInterface
    public static interface SimpleRequestHandler
    extends RequestHandler {
        public Response handle();

        @Override
        default public Response handle(HttpRequest request) {
            return this.handle();
        }
    }
}

