/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.http;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface HttpResponse {
    public HttpResponse setStatus(int var1);

    default public HttpResponse ok() {
        return this.setStatus(200);
    }

    default public HttpResponse badRequest() {
        return this.setStatus(400);
    }

    default public HttpResponse notFound() {
        return this.setStatus(404);
    }

    default public HttpResponse unsupportedMediaType() {
        return this.setStatus(415);
    }

    default public HttpResponse error() {
        return this.setStatus(500);
    }

    public int getStatus();

    default public boolean isOK() {
        return this.getStatus() == 200;
    }

    public void setEntity(Map<String, Object> var1);

    public void setEntity(InputStream var1);

    default public void setEntityAndStatus(Map<String, Object> entity) {
        if (entity == null) {
            this.notFound();
        } else {
            this.ok().setEntity(entity);
        }
    }

    default public void setEntityAndStatus(Entity entity) {
        if (entity == null) {
            this.notFound();
        } else if (entity.hasFailures()) {
            this.badRequest().setEntity(entity.toJson());
        } else {
            this.ok().setEntity(entity.toJson());
        }
    }

    public void addHeaders(Map<String, List<String>> var1);

    public void addHeader(String var1, String var2);

    public static interface Entity {
        public boolean hasFailures();

        public Map<String, Object> toJson();
    }
}

