/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.http;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsExchange;
import com.tangosol.internal.http.HttpException;
import com.tangosol.internal.http.HttpMethod;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.PathParameters;
import com.tangosol.internal.http.QueryParameters;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.http.ServiceAwareHandler;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.Service;
import com.tangosol.net.management.MapJsonBodyHandler;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SimpleResourceRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;

public abstract class BaseHttpHandler
implements ServiceAwareHandler {
    public static final byte[] EMPTY_BODY = new byte[0];
    private static final String SLASH = "/";
    protected final RequestRouter f_router;
    protected final BodyWriter<Object> f_bodyWriter;
    protected Service m_service;

    public BaseHttpHandler() {
        this(new RequestRouter(new String[0]), MapJsonBodyHandler.ensureMapJsonBodyHandler());
    }

    protected BaseHttpHandler(RequestRouter router, BodyWriter bodyWriter) {
        this.f_router = Objects.requireNonNull(router);
        this.f_bodyWriter = Objects.requireNonNull(bodyWriter);
        this.configureRoutes(this.f_router);
    }

    @Override
    public void setService(Service service) {
        this.m_service = service;
    }

    @Override
    public Service getService() {
        return this.m_service;
    }

    @Override
    public void handle(HttpExchange exchange) {
        try {
            URI uriBase;
            Object sDecodedBasePath = exchange.getHttpContext().getPath();
            if (!((String)sDecodedBasePath).endsWith(SLASH)) {
                sDecodedBasePath = (String)sDecodedBasePath + SLASH;
            }
            String sScheme = exchange instanceof HttpsExchange ? "https" : "http";
            Object listHostHeader = exchange.getRequestHeaders().get("Host");
            if (listHostHeader == null) {
                InetSocketAddress address = exchange.getLocalAddress();
                uriBase = new URI(sScheme, null, address.getHostName(), address.getPort(), (String)sDecodedBasePath, null, null);
            } else {
                uriBase = new URI(sScheme + "://" + (String)listHostHeader.get(0) + (String)sDecodedBasePath);
            }
            Request request = new Request(exchange, uriBase);
            this.beforeRouting(request);
            Response response = this.f_router.route(request);
            this.send(exchange, response);
        }
        catch (HttpException e) {
            String sMsg = e.getMessage();
            if (sMsg == null) {
                BaseHttpHandler.send(exchange, e.getStatus(), e.getMessage());
            } else {
                BaseHttpHandler.send(exchange, e.getStatus());
            }
        }
        catch (Throwable t) {
            Logger.err("Error handling management http request", t);
            BaseHttpHandler.send(exchange, 500, t.getMessage());
        }
    }

    protected void configureRoutes(RequestRouter router) {
    }

    protected abstract void beforeRouting(HttpRequest var1);

    private void send(HttpExchange exchange, Response response) throws IOException {
        Object oEntity;
        boolean fGzip = false;
        String sEncoding = exchange.getRequestHeaders().getFirst("Accept-Encoding");
        if (sEncoding != null) {
            fGzip = Arrays.stream(sEncoding.split(",")).map(String::trim).anyMatch("gzip"::equalsIgnoreCase);
        }
        Headers headers = exchange.getResponseHeaders();
        response.getHeaders().forEach((sName, list) -> list.forEach(sValue -> headers.add((String)sName, (String)sValue)));
        if (fGzip) {
            headers.set("Content-Encoding", "gzip");
        }
        int nLength = (oEntity = response.getEntity()) == null ? -1 : 0;
        exchange.sendResponseHeaders(response.getStatus().getStatusCode(), nLength);
        if (oEntity != null) {
            try (OutputStream out = fGzip ? new GZIPOutputStream(exchange.getResponseBody()) : exchange.getResponseBody();){
                if (oEntity instanceof WriteBuffer) {
                    oEntity = ((WriteBuffer)oEntity).getBufferOutput();
                }
                if (oEntity instanceof WriteBuffer.BufferOutput) {
                    WriteBuffer buffer = ((WriteBuffer.BufferOutput)oEntity).getBuffer();
                    buffer.getReadBuffer().writeTo(out);
                } else if (oEntity instanceof InputStream) {
                    int cBytes;
                    InputStream in = (InputStream)oEntity;
                    byte[] ab = new byte[8192];
                    while ((cBytes = in.read(ab)) > 0) {
                        out.write(ab, 0, cBytes);
                    }
                } else {
                    this.f_bodyWriter.write(oEntity, out);
                }
            }
        }
    }

    private static void send(HttpExchange t, int status) {
        BaseHttpHandler.send(t, status, null);
    }

    private static void send(HttpExchange t, int status, String sMessage) {
        try {
            byte[] ab = sMessage == null ? EMPTY_BODY : sMessage.getBytes(StandardCharsets.UTF_8);
            t.sendResponseHeaders(status, ab.length);
            try (OutputStream os = t.getResponseBody();){
                os.write(ab);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface BodyWriter<T> {
        public void write(T var1, OutputStream var2);
    }

    static class Request
    implements HttpRequest {
        private final HttpExchange f_exchange;
        private final URI f_uriBase;
        private final URI f_uriRequest;
        private final QueryParameters f_queryParameters;
        private final ResourceRegistry f_resourceRegistry;
        private PathParameters m_pathParameters;
        private Map<String, Object> m_mapBody;

        Request(HttpExchange exchange, URI uriBase) {
            this.f_exchange = exchange;
            this.f_uriBase = uriBase;
            this.f_uriRequest = uriBase.resolve(exchange.getRequestURI());
            this.f_queryParameters = Request.createQueryParameter(exchange);
            this.f_resourceRegistry = new SimpleResourceRegistry();
        }

        @Override
        public HttpMethod getMethod() {
            return HttpMethod.valueOf(this.f_exchange.getRequestMethod());
        }

        @Override
        public String getHeaderString(String name) {
            Object list = this.f_exchange.getRequestHeaders().get(name);
            if (list == null) {
                return null;
            }
            return String.join((CharSequence)",", (Iterable<? extends CharSequence>)list);
        }

        @Override
        public URI getBaseURI() {
            return this.f_uriBase;
        }

        @Override
        public URI getRequestURI() {
            return this.f_uriRequest;
        }

        @Override
        public QueryParameters getQueryParameters() {
            return this.f_queryParameters == null ? QueryParameters.EMPTY : this.f_queryParameters;
        }

        @Override
        public PathParameters getPathParameters() {
            return this.m_pathParameters == null ? PathParameters.EMPTY : this.m_pathParameters;
        }

        @Override
        public void setPathParameters(PathParameters parameters) {
            this.m_pathParameters = parameters;
        }

        @Override
        public InputStream getBody() {
            return this.f_exchange.getRequestBody();
        }

        @Override
        public synchronized Map<String, Object> getJsonBody(Function<InputStream, Map<String, Object>> fnParser) {
            if (this.m_mapBody == null) {
                Map<String, Object> mapBody = fnParser.apply(this.getBody());
                this.m_mapBody = mapBody == null ? Collections.emptyMap() : mapBody;
            }
            return this.m_mapBody;
        }

        @Override
        public ResourceRegistry getResourceRegistry() {
            return this.f_resourceRegistry;
        }

        static QueryParameters createQueryParameter(HttpExchange exchange) {
            String sQuery = exchange.getRequestURI().getRawQuery();
            if (sQuery == null || sQuery.length() == 0) {
                return QueryParameters.EMPTY;
            }
            Headers params = new Headers();
            Request.parseQueryString(sQuery).forEach(params::add);
            return new RequestQueryParameters(params);
        }

        static Map<String, String> parseQueryString(String sQuery) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (sQuery == null || sQuery.trim().isEmpty()) {
                return result;
            }
            int nLast = 0;
            int cChars = sQuery.length();
            while (nLast < cChars) {
                int nNext = sQuery.indexOf(38, nLast);
                if (nNext == -1) {
                    nNext = cChars;
                }
                if (nNext > nLast) {
                    int nEqPos = sQuery.indexOf(61, nLast);
                    try {
                        if (nEqPos < 0 || nEqPos > nNext) {
                            result.put(URLDecoder.decode(sQuery.substring(nLast, nNext), "utf-8"), "");
                        } else {
                            result.put(URLDecoder.decode(sQuery.substring(nLast, nEqPos), "utf-8"), URLDecoder.decode(sQuery.substring(nEqPos + 1, nNext), "utf-8"));
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        throw Exceptions.ensureRuntimeException(e);
                    }
                }
                nLast = nNext + 1;
            }
            return result;
        }
    }

    public static class StringBodyWriter
    implements BodyWriter<String> {
        public static final BodyWriter<String> INSTANCE = new StringBodyWriter();

        @Override
        public void write(String sBody, OutputStream out) {
            try {
                out.write(sBody.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw Exceptions.ensureRuntimeException(e);
            }
        }
    }

    public static class BytesBodyWriter
    implements BodyWriter<byte[]> {
        public static final BodyWriter<byte[]> INSTANCE = new BytesBodyWriter();

        @Override
        public void write(byte[] abBody, OutputStream out) {
            try {
                out.write(abBody);
            }
            catch (IOException e) {
                throw Exceptions.ensureRuntimeException(e);
            }
        }
    }

    static class RequestQueryParameters
    implements QueryParameters {
        private final Headers f_queryParams;

        RequestQueryParameters(Headers queryParams) {
            this.f_queryParams = queryParams;
        }

        @Override
        public String getFirst(String sKey) {
            return this.f_queryParams.getFirst(sKey);
        }
    }
}

