/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.health;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.http.BaseHttpHandler;
import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.Member;
import com.tangosol.net.MemberIdentity;
import com.tangosol.net.Service;
import com.tangosol.net.management.MapJsonBodyHandler;
import com.tangosol.net.management.Registry;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HealthHttpHandler
extends BaseHttpHandler {
    protected static final String APPLICATION_JSON = "application/json";
    public static final String DEFAULT_SERVICE_NAME = "$SYS:HealthHttpProxy";
    private static volatile String s_sServiceName = "$SYS:HealthHttpProxy";

    public HealthHttpHandler() {
        super(new RequestRouter(new String[0]), HealthHttpHandler.ensureBodyWriter());
    }

    @Override
    protected void configureRoutes(RequestRouter router) {
        router.setDefaultProduces(APPLICATION_JSON);
        router.setDefaultConsumes(APPLICATION_JSON);
        router.addDefaultResponseHeader("X-Content-Type-Options", "nosniff");
        router.addDefaultResponseHeader("Content-type", APPLICATION_JSON);
        router.addDefaultResponseHeader("Vary", "Accept-Encoding");
        router.addGet("/ready", this::ready);
        router.addGet("/started", this::started);
        router.addGet("/live", this::live);
        router.addGet("/healthz", this::live);
        router.addGet("/safe", this::safe);
        router.addGet("/ha", this::safe);
        router.addGet("/suspend", this::suspend);
        router.addPut("/suspend", this::suspend);
        router.addGet("/suspend/{serviceName}", this::suspend);
        router.addPut("/suspend/{serviceName}", this::suspend);
        router.addGet("/resume", this::resume);
        router.addPut("/resume", this::resume);
        router.addGet("/resume/{serviceName}", this::resume);
        router.addPut("/resume/{serviceName}", this::resume);
    }

    @Override
    protected void beforeRouting(HttpRequest request) {
    }

    @Override
    public void setService(Service service) {
        super.setService(service);
        s_sServiceName = service.getInfo().getServiceName();
    }

    public Response ready(HttpRequest request) {
        Logger.log("Health: checking readiness", 9);
        try {
            Registry management = CacheFactory.getCluster().getManagement();
            if (management == null) {
                Logger.log("Health: checking readiness failed, no management service present", 9);
                return Response.status(503).build();
            }
            if (management.allHealthChecksReady()) {
                return Response.ok().build();
            }
            Logger.log("Health: checking readiness failed, allHealthChecksReady==false", 9);
            return Response.status(503).build();
        }
        catch (Exception e) {
            Logger.finer("Health: checking readiness failed: " + e.getMessage());
            return Response.status(503).build();
        }
    }

    public Response live(HttpRequest request) {
        Logger.log("Health: checking liveness", 9);
        Registry management = CacheFactory.getCluster().getManagement();
        if (management == null) {
            return Response.status(503).build();
        }
        return management.allHealthChecksLive() ? Response.ok().build() : Response.status(503).build();
    }

    public Response started(HttpRequest request) {
        Logger.log("Health: checking started", 9);
        Registry management = CacheFactory.getCluster().getManagement();
        if (management == null) {
            return Response.status(503).build();
        }
        return management.allHealthChecksStarted() ? Response.ok().build() : Response.status(503).build();
    }

    public Response safe(HttpRequest request) {
        Logger.log("Health: checking safe", 9);
        Registry management = CacheFactory.getCluster().getManagement();
        if (management == null) {
            return Response.status(503).build();
        }
        return management.allHealthChecksSafe() ? Response.ok().build() : Response.status(503).build();
    }

    protected Response suspend(HttpRequest request) {
        Cluster cluster = this.m_service.getCluster();
        Member member = cluster.getLocalMember();
        String sRole = member.getRoleName();
        String sService = request.getFirstPathParameter("serviceName");
        if (sService != null) {
            Logger.info("Health: Suspending service " + sService + " if active persistence enabled and service present only in members with role " + sRole);
            this.suspendService(sService);
        } else {
            Logger.info("Health: Suspending all active persistence enabled services present only in members with role " + sRole);
            Enumeration<String> names = cluster.getServiceNames();
            while (names.hasMoreElements()) {
                String sName = names.nextElement();
                this.suspendService(sName);
            }
        }
        return Response.ok().build();
    }

    protected void suspendService(String sName) {
        Cluster cluster = this.m_service.getCluster();
        Service service = cluster.getService(sName);
        if (service == null) {
            return;
        }
        Logger.finest("Maybe suspending " + sName);
        if (service instanceof DistributedCacheService && ((DistributedCacheService)service).isLocalStorageEnabled()) {
            DistributedCacheService distributedCacheService = (DistributedCacheService)service;
            List listRole = distributedCacheService.getOwnershipEnabledMembers().stream().map(MemberIdentity::getRoleName).distinct().collect(Collectors.toList());
            if (listRole.size() <= 1) {
                String sMode = distributedCacheService.getPersistenceMode();
                if ("active".equalsIgnoreCase(sMode)) {
                    Logger.info("Health: Suspending service " + sName);
                    cluster.suspendService(sName);
                } else {
                    Logger.finest("Skipping suspension of " + sName + " - active persistence is not enabled");
                }
            } else {
                Logger.finest("Skipping suspension of " + sName + " - service exists in multiple roles " + String.valueOf(listRole));
            }
        } else {
            Logger.finest("Skipping suspension of " + sName + " - not a storage enabled DistributedCacheService");
        }
    }

    protected Response resume(HttpRequest request) {
        Cluster cluster = this.m_service.getCluster();
        String sService = request.getFirstPathParameter("serviceName");
        String sExcludes = request.getFirstQueryParameter("exclude");
        if (sService == null) {
            Enumeration<String> enumNames = cluster.getServiceNames();
            Set setExclude = sExcludes == null ? Collections.emptySet() : Arrays.stream(sExcludes.split(",")).map(String::trim).collect(Collectors.toSet());
            Logger.info("Health: Resuming all suspended services, exclusions=" + String.valueOf(setExclude));
            while (enumNames.hasMoreElements()) {
                Service service;
                sService = enumNames.nextElement();
                if (setExclude.contains(sService) || (service = cluster.getService(sService)) == null || !service.isSuspended()) continue;
                Logger.info("Health: Resuming service " + sService);
                cluster.resumeService(sService);
            }
        } else {
            Service service = cluster.getService(sService);
            if (service != null && service.isSuspended()) {
                Logger.info("Health: Resuming service " + sService);
                cluster.resumeService(sService);
            }
        }
        return Response.ok().build();
    }

    private static BaseHttpHandler.BodyWriter<?> ensureBodyWriter() {
        try {
            return MapJsonBodyHandler.ensureMapJsonBodyHandler();
        }
        catch (Exception e) {
            return new HealthBodyWriter();
        }
    }

    public static String getServiceName() {
        return s_sServiceName;
    }

    private static class HealthBodyWriter
    implements BaseHttpHandler.BodyWriter<Object> {
        private HealthBodyWriter() {
        }

        @Override
        public void write(Object body, OutputStream out) {
            try {
                if (body != null) {
                    out.write(String.valueOf(body).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw Exceptions.ensureRuntimeException(e);
            }
        }
    }
}

