/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.health;

import com.tangosol.internal.health.HealthCheckWrapperMBean;
import com.tangosol.util.HealthCheck;
import java.util.Objects;

public class HealthCheckWrapper
implements HealthCheckWrapperMBean {
    private final HealthCheck f_delegate;
    private final String f_sSubType;

    public HealthCheckWrapper(HealthCheck healthCheck) {
        this(healthCheck, "Application");
    }

    public HealthCheckWrapper(HealthCheck healthCheck, String sSybType) {
        this.f_delegate = Objects.requireNonNull(healthCheck);
        this.f_sSubType = sSybType == null || sSybType.isEmpty() ? "Application" : sSybType;
    }

    public HealthCheck getHealthCheck() {
        return this.f_delegate;
    }

    @Override
    public String getSubType() {
        return this.f_sSubType;
    }

    @Override
    public String getClassName() {
        return this.f_delegate.getClass().getName();
    }

    @Override
    public String getDescription() {
        return this.f_delegate.toString();
    }

    @Override
    public String getName() {
        return this.f_delegate.getName();
    }

    @Override
    public boolean isMemberHealthCheck() {
        return this.f_delegate.isMemberHealthCheck();
    }

    @Override
    public boolean isReady() {
        return this.f_delegate.isReady();
    }

    @Override
    public boolean isLive() {
        return this.f_delegate.isLive();
    }

    @Override
    public boolean isStarted() {
        return this.f_delegate.isStarted();
    }

    @Override
    public boolean isSafe() {
        return this.f_delegate.isSafe();
    }

    public static String getMBeanName(HealthCheck healthCheck) {
        String sSubType;
        String string = sSubType = healthCheck instanceof HealthCheckWrapperMBean ? ((HealthCheckWrapperMBean)healthCheck).getSubType() : "Application";
        if ("Cluster".equals(sSubType)) {
            return String.format("type=Health,subType=%s", sSubType);
        }
        return String.format("type=Health,subType=%s,name=%s", sSubType, healthCheck.getName());
    }
}

