/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.classgraph.nonapi.classloaderhandler;

import com.tangosol.internal.classgraph.nonapi.classloaderhandler.ClassLoaderHandler;
import com.tangosol.internal.classgraph.nonapi.classpath.ClassLoaderOrder;
import com.tangosol.internal.classgraph.nonapi.classpath.ClasspathOrder;
import com.tangosol.internal.classgraph.nonapi.scanspec.ScanSpec;
import com.tangosol.internal.classgraph.nonapi.utils.LogNode;

class UnoOneJarClassLoaderHandler
implements ClassLoaderHandler {
    private UnoOneJarClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "com.needhamsoftware.unojar.JarClassLoader".equals(classLoaderClass.getName()) || "com.simontuffs.onejar.JarClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        String unoJarOneJarPath = (String)classpathOrder.reflectionUtils.invokeMethod(false, classLoader, "getOneJarPath");
        classpathOrder.addClasspathEntry((Object)unoJarOneJarPath, classLoader, scanSpec, log);
        String unoJarJarPath = System.getProperty("uno-jar.jar.path");
        classpathOrder.addClasspathEntry((Object)unoJarJarPath, classLoader, scanSpec, log);
        String oneJarJarPath = System.getProperty("one-jar.jar.path");
        classpathOrder.addClasspathEntry((Object)oneJarJarPath, classLoader, scanSpec, log);
        String oneJarClassPath = System.getProperty("one-jar.class.path");
        if (oneJarClassPath != null) {
            classpathOrder.addClasspathEntryObject(oneJarClassPath.split("\\|"), classLoader, scanSpec, log);
        }
    }
}

