/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.classgraph.nonapi.classloaderhandler;

import com.tangosol.internal.classgraph.nonapi.classloaderhandler.ClassLoaderHandler;
import com.tangosol.internal.classgraph.nonapi.classpath.ClassLoaderOrder;
import com.tangosol.internal.classgraph.nonapi.classpath.ClasspathOrder;
import com.tangosol.internal.classgraph.nonapi.scanspec.ScanSpec;
import com.tangosol.internal.classgraph.nonapi.utils.LogNode;
import java.net.URL;
import java.net.URLClassLoader;

class URLClassLoaderHandler
implements ClassLoaderHandler {
    private URLClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "java.net.URLClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        URL[] urls = ((URLClassLoader)classLoader).getURLs();
        if (urls != null) {
            for (URL url : urls) {
                if (url == null) continue;
                classpathOrder.addClasspathEntry((Object)url, classLoader, scanSpec, log);
            }
        }
    }
}

