/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.classgraph.nonapi.classloaderhandler;

import com.tangosol.internal.classgraph.nonapi.classloaderhandler.ClassLoaderHandler;
import com.tangosol.internal.classgraph.nonapi.classpath.ClassLoaderOrder;
import com.tangosol.internal.classgraph.nonapi.classpath.ClasspathOrder;
import com.tangosol.internal.classgraph.nonapi.scanspec.ScanSpec;
import com.tangosol.internal.classgraph.nonapi.utils.LogNode;
import java.io.File;

class OSGiDefaultClassLoaderHandler
implements ClassLoaderHandler {
    private OSGiDefaultClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object classpathManager = classpathOrder.reflectionUtils.invokeMethod(false, classLoader, "getClasspathManager");
        Object[] entries = (Object[])classpathOrder.reflectionUtils.getFieldVal(false, classpathManager, "entries");
        if (entries != null) {
            for (Object entry : entries) {
                Object bundleFile = classpathOrder.reflectionUtils.invokeMethod(false, entry, "getBundleFile");
                File baseFile = (File)classpathOrder.reflectionUtils.invokeMethod(false, bundleFile, "getBaseFile");
                if (baseFile == null) continue;
                classpathOrder.addClasspathEntry((Object)baseFile.getPath(), classLoader, scanSpec, log);
            }
        }
    }
}

