/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.classgraph.nonapi.classloaderhandler;

import com.tangosol.internal.classgraph.nonapi.classloaderhandler.ClassLoaderHandler;
import com.tangosol.internal.classgraph.nonapi.classpath.ClassLoaderOrder;
import com.tangosol.internal.classgraph.nonapi.classpath.ClasspathOrder;
import com.tangosol.internal.classgraph.nonapi.scanspec.ScanSpec;
import com.tangosol.internal.classgraph.nonapi.utils.LogNode;
import java.net.URL;

class JPMSClassLoaderHandler
implements ClassLoaderHandler {
    private JPMSClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "jdk.internal.loader.ClassLoaders$AppClassLoader".equals(classLoaderClass.getName()) || "jdk.internal.loader.BuiltinClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object ucpVal = classpathOrder.reflectionUtils.getFieldVal(false, (Object)classLoader, "ucp");
        if (ucpVal != null) {
            URL[] urls = (URL[])classpathOrder.reflectionUtils.invokeMethod(false, ucpVal, "getURLs");
            classpathOrder.addClasspathEntryObject(urls, classLoader, scanSpec, log);
        }
    }
}

