/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.classgraph.nonapi.classloaderhandler;

import com.tangosol.internal.classgraph.ClassGraphClassLoader;
import com.tangosol.internal.classgraph.nonapi.classloaderhandler.ClassLoaderHandler;
import com.tangosol.internal.classgraph.nonapi.classpath.ClassLoaderOrder;
import com.tangosol.internal.classgraph.nonapi.classpath.ClasspathOrder;
import com.tangosol.internal.classgraph.nonapi.scanspec.ScanSpec;
import com.tangosol.internal.classgraph.nonapi.utils.LogNode;
import java.net.URL;

class ClassGraphClassLoaderHandler
implements ClassLoaderHandler {
    private ClassGraphClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        boolean matches = "com.tangosol.internal.classgraph.ClassGraphClassLoader".equals(classLoaderClass.getName());
        if (matches && log != null) {
            log.log("Sharing a `ClassGraphClassLoader` between multiple nested scans is not advisable, because scan criteria may differ between scans. See: https://github.com/classgraph/classgraph/issues/485");
        }
        return matches;
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        for (URL url : ((ClassGraphClassLoader)classLoader).getURLs()) {
            if (url == null) continue;
            classpathOrder.addClasspathEntry((Object)url, classLoader, scanSpec, log);
        }
    }
}

