/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.engarde;

import com.tangosol.engarde.ApplicationEntry;
import com.tangosol.engarde.ApplicationReader;
import com.tangosol.engarde.ApplicationWriter;
import com.tangosol.util.Base;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarStorage
extends Base
implements ApplicationReader,
ApplicationWriter {
    private boolean m_fAllowRead;
    private boolean m_fAllowWrite;
    private JarFile m_jar;
    private File m_fileOut;
    private JarOutputStream m_jarOut;
    private Entry m_currEntry;
    private boolean m_fAdded;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    private static final String CLASS = "JarStorage";

    public JarStorage(JarFile jarFile) throws IOException {
        JarStorage.azzert(jarFile != null);
        this.m_jar = jarFile;
        this.m_fAllowRead = true;
    }

    public JarStorage(File fileJar, Manifest manifest) throws IOException {
        FileOutputStream stream = new FileOutputStream(fileJar);
        this.m_fileOut = fileJar;
        this.m_jarOut = manifest == null ? new JarOutputStream(stream) : new JarOutputStream((OutputStream)stream, manifest);
        this.m_fAllowWrite = true;
    }

    public JarFile getJar() {
        return this.m_jar;
    }

    public JarOutputStream getJarOut() {
        return this.m_jarOut;
    }

    public String toString() {
        return CLASS + (String)(this.m_jar != null ? " Reader: " + this.m_jar.getName() : "") + (String)(this.m_fileOut != null ? " Writer: " + this.m_fileOut.getName() : "");
    }

    @Override
    public InputStream getInputStream(ApplicationEntry entry) throws IOException {
        if (!this.m_fAllowRead) {
            throw new IllegalStateException("ApplicationReader operation is not allowed at: " + String.valueOf(this));
        }
        JarEntry je = entry instanceof Entry ? ((Entry)entry).getJarEntry() : this.m_jar.getJarEntry(entry.getName());
        return je == null ? null : this.m_jar.getInputStream(je);
    }

    @Override
    public ApplicationReader extractApplication(String sName) throws IOException {
        if (!this.m_fAllowRead) {
            throw new IllegalStateException("ApplicationReader operation is not allowed at: " + String.valueOf(this));
        }
        JarFile jar = com.tangosol.dev.component.JarStorage.extractJar(this.m_jar, sName);
        return jar == null ? null : new JarStorage(jar);
    }

    @Override
    public ApplicationEntry getEntry(String sName) {
        if (!this.m_fAllowRead) {
            throw new IllegalStateException("ApplicationReader operation is not allowed at: " + String.valueOf(this));
        }
        JarEntry je = this.m_jar.getJarEntry(sName);
        return je == null ? null : new Entry(je);
    }

    @Override
    public Enumeration entries() {
        if (!this.m_fAllowRead) {
            throw new IllegalStateException("ApplicationReader operation is not allowed at: " + String.valueOf(this));
        }
        final Enumeration<JarEntry> enmr = this.m_jar.entries();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return enmr.hasMoreElements();
            }

            public Object nextElement() {
                return new Entry((JarEntry)enmr.nextElement());
            }
        };
    }

    @Override
    public void close() {
        try {
            if (this.m_fAllowRead) {
                JarFile jar = this.m_jar;
                if (jar != null) {
                    jar.close();
                    this.m_jar = null;
                }
                this.m_fAllowRead = false;
            }
            if (this.m_fAllowWrite) {
                this.closeEntry();
                JarOutputStream jarOut = this.m_jarOut;
                if (jarOut != null) {
                    jarOut.close();
                    this.m_jarOut = null;
                    this.m_fileOut = null;
                }
                this.m_fAllowWrite = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public ApplicationEntry createEntry(String sName) throws IOException {
        if (!this.m_fAllowWrite) {
            throw new IllegalStateException("ApplicationWriter operation is not allowed at: " + String.valueOf(this));
        }
        Entry entry = this.m_currEntry;
        if (entry != null) {
            this.closeEntry();
        }
        JarEntry je = new JarEntry(sName);
        this.m_currEntry = entry = new Entry(je);
        return entry;
    }

    @Override
    public ApplicationEntry createEntry(ApplicationEntry entry) throws IOException {
        JarEntry je;
        if (!this.m_fAllowWrite) {
            throw new IllegalStateException("ApplicationWriter operation is not allowed at: " + String.valueOf(this));
        }
        Entry entryCurr = this.m_currEntry;
        if (entryCurr != null) {
            this.closeEntry();
        }
        if (entry instanceof Entry) {
            je = new JarEntry(((Entry)entry).getJarEntry());
            je.setCompressedSize(-1L);
        } else {
            je = new JarEntry(entry.getName());
            je.setTime(entry.getTime());
            je.setSize(entry.getSize());
            je.setMethod(8);
        }
        this.m_currEntry = entryCurr = new Entry(je);
        return entryCurr;
    }

    @Override
    public void writeEntryData(byte[] ab, int of, int cb) throws IOException {
        if (!this.m_fAllowWrite) {
            throw new IllegalStateException("ApplicationWriter operation is not allowed: " + String.valueOf(this));
        }
        Entry entry = this.m_currEntry;
        if (entry == null) {
            throw new IllegalStateException("Request is out of sequence");
        }
        JarOutputStream jarOut = this.m_jarOut;
        if (!this.m_fAdded) {
            jarOut.putNextEntry(entry.getJarEntry());
            this.m_fAdded = true;
        }
        if (cb > 0) {
            jarOut.write(ab, of, cb);
        }
    }

    @Override
    public void closeEntry() throws IOException {
        if (!this.m_fAllowWrite) {
            throw new IllegalStateException("ApplicationWriter operation is not allowed: " + String.valueOf(this));
        }
        Entry entry = this.m_currEntry;
        if (entry != null) {
            this.m_jarOut.closeEntry();
            this.m_currEntry = null;
            this.m_fAdded = false;
        }
    }

    public static class Entry
    implements ApplicationEntry {
        private JarEntry m_entry;

        protected Entry(JarEntry entry) {
            Base.azzert(entry != null);
            this.m_entry = entry;
        }

        public JarEntry getJarEntry() {
            return this.m_entry;
        }

        @Override
        public String getName() {
            return this.m_entry.getName();
        }

        @Override
        public long getTime() {
            return this.m_entry.getTime();
        }

        @Override
        public void setTime(long lTime) {
            this.m_entry.setTime(lTime);
        }

        @Override
        public long getSize() {
            return this.m_entry.getSize();
        }

        @Override
        public void setSize(long lSize) {
            JarEntry je = this.m_entry;
            je.setMethod(8);
            je.setSize(lSize);
            je.setCompressedSize(-1L);
        }

        public String toString() {
            return "JarStorage$Entry: " + this.getName();
        }
    }
}

