/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.tools;

import com.tangosol.dev.tools.CommandLineTool;
import java.io.File;
import java.util.Enumeration;

public class Touch
extends CommandLineTool {
    public static void main(String[] asArgs) {
        try {
            Enumeration enmrFiles;
            int cArgs = asArgs.length;
            if (cArgs < 1) {
                Touch.showInstructions();
                return;
            }
            String sFileSpec = asArgs[0];
            if (sFileSpec.length() < 1) {
                Touch.showInstructions();
                return;
            }
            boolean fPrompt = false;
            boolean fRecurse = false;
            boolean fVerbose = false;
            for (int i = 1; i < cArgs; ++i) {
                String sOpt = asArgs[i];
                if (sOpt.length() < 2 || sOpt.charAt(0) != '-') {
                    Touch.showInstructions();
                    return;
                }
                block8: for (int of = 1; of < sOpt.length(); ++of) {
                    switch (sOpt.charAt(of)) {
                        case 'P': 
                        case 'p': {
                            fPrompt = true;
                            continue block8;
                        }
                        case 'D': 
                        case 'd': {
                            fRecurse = true;
                            continue block8;
                        }
                        case 'V': 
                        case 'v': {
                            fVerbose = true;
                            continue block8;
                        }
                        default: {
                            Touch.showInstructions();
                            return;
                        }
                    }
                }
            }
            if (fVerbose) {
                Touch.out();
                Touch.out("File Spec   :  \"" + sFileSpec + "\"");
                Touch.out("Selected Options:");
                if (fRecurse) {
                    Touch.out("  -d  Recurse sub-directories");
                }
                if (fPrompt) {
                    Touch.out("  -p  Prompt before touching each file");
                }
                Touch.out("  -v  Verbose mode");
            }
            if (fVerbose) {
                Touch.out();
                Touch.out("Selecting files ...");
            }
            if ((enmrFiles = Touch.applyFilter(sFileSpec, fRecurse)) == null) {
                Touch.out();
                Touch.out("Invalid directory or file specification:  " + sFileSpec);
                Touch.showInstructions();
                return;
            }
            if (fVerbose) {
                Touch.out();
                Touch.out("Processing files ...");
            }
            boolean cTotal = false;
            int cFiles = 0;
            long lTime = System.currentTimeMillis();
            while (enmrFiles.hasMoreElements()) {
                File file = (File)enmrFiles.nextElement();
                boolean fReadable = file.canRead();
                boolean fWriteable = file.canWrite();
                boolean fHidden = file.isHidden();
                boolean fNameShown = false;
                if (fPrompt || fVerbose) {
                    StringBuffer sb = new StringBuffer();
                    if (fReadable) {
                        sb.append("r");
                    }
                    if (fWriteable) {
                        sb.append("w");
                    }
                    if (fHidden) {
                        sb.append("h");
                    }
                    Touch.out(file.getPath() + " (" + sb.toString() + ")");
                    fNameShown = true;
                }
                if (!fReadable || !fWriteable || fHidden) {
                    String sText = "";
                    if (!fReadable) {
                        sText = "(not readable)";
                    } else if (!fWriteable) {
                        sText = "(not writeable)";
                    } else if (fHidden) {
                        sText = "(hidden)";
                    }
                    Touch.out("Skipping " + file.getPath() + " " + sText);
                    continue;
                }
                int chAns = 89;
                if (fPrompt && (chAns = (int)Touch.in("Touch? (Y/N): ")) != 89 && chAns != 121) continue;
                if (file.setLastModified(lTime)) {
                    ++cFiles;
                    continue;
                }
                Touch.out("Failed to touch " + file.getPath());
            }
            Touch.out();
            Touch.out("Total files:  " + cFiles);
            Touch.out();
        }
        catch (Throwable t) {
            Touch.out();
            Touch.out("Caught \"" + String.valueOf(t) + "\"");
            Touch.out("(begin stack trace)");
            Touch.out(t);
            Touch.out("(end stack trace)");
            Touch.out();
        }
    }

    static void showInstructions() {
        Touch.out();
        Touch.out("Usage:");
        Touch.out("  Touch <filespec>");
        Touch.out();
        Touch.out("Options:");
        Touch.out("  -d  Recurse sub-directories");
        Touch.out("  -p  Prompt before touching each file");
        Touch.out("  -v  Verbose mode");
        Touch.out();
        Touch.out("Example:");
        Touch.out("  java com.tangosol.dev.tools.Touch \"*.java\" -d");
        Touch.out();
    }
}

