/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.packager.PackagerEntry;
import com.tangosol.dev.packager.PackagerPath;
import com.tangosol.dev.packager.ResourceSet;
import com.tangosol.dev.packager.UnexpectedPackagerException;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;

public abstract class PackagerSet
extends ResourceSet {
    private Hashtable packagerEntries = new Hashtable();
    private Properties attributes = new Properties();

    protected PackagerSet() {
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Properties attributes) {
        this.attributes = attributes;
    }

    @Override
    public boolean containsKey(PackagerPath path) {
        String pathName = path.getPathName();
        return this.packagerEntries.get(pathName) != null;
    }

    public PackagerEntry getPackagerEntry(PackagerPath path) {
        String pathName = path.getPathName();
        return (PackagerEntry)this.packagerEntries.get(pathName);
    }

    public void recordEntry(PackagerEntry entry) {
        String pathName = entry.getPath().getPathName();
        this.packagerEntries.put(pathName, entry);
    }

    public Collection getCollectedEntries() {
        return this.packagerEntries.values();
    }

    public abstract void materialize(ClassLoader var1) throws IOException, UnexpectedPackagerException;
}

