/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.packager.FilePackagerPath;
import com.tangosol.dev.packager.PackagerBaseEntry;
import com.tangosol.dev.packager.PackagerDependencyElement;
import com.tangosol.dev.packager.PackagerEntryNotFoundException;
import com.tangosol.dev.packager.PackagerPath;
import com.tangosol.dev.packager.UnexpectedPackagerException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class PackagerFileEntry
extends PackagerBaseEntry
implements PackagerDependencyElement {
    private String filePath;
    private String packagedDirectoryPath;

    public PackagerFileEntry() {
    }

    public PackagerFileEntry(String filePath, String packagedDirectoryPath) {
        this.setFilePath(filePath);
        this.setPackagedDirectoryPath(packagedDirectoryPath);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getPackagedDirectoryPath() {
        return this.packagedDirectoryPath;
    }

    public void setPackagedDirectoryPath(String directoryPath) {
        if (((String)(directoryPath = ((String)directoryPath).replace('\\', '/'))).length() > 0 && !((String)directoryPath).endsWith("/")) {
            directoryPath = (String)directoryPath + "/";
        }
        this.packagedDirectoryPath = directoryPath;
    }

    @Override
    public PackagerPath getPath() {
        File entryFile = this.getFile();
        String directoryPath = this.getPackagedDirectoryPath();
        return new FilePackagerPath(directoryPath + entryFile.getName());
    }

    public File getFile() {
        return new File(this.getFilePath());
    }

    @Override
    public byte[] getData(ClassLoader classLoader) throws PackagerEntryNotFoundException {
        File entryFile = this.getFile();
        if (!entryFile.exists()) {
            throw new PackagerEntryNotFoundException(entryFile.toString());
        }
        try {
            return PackagerFileEntry.read(entryFile);
        }
        catch (IOException ioe) {
            throw new UnexpectedPackagerException(ioe);
        }
    }

    @Override
    public String getComment() {
        return null;
    }

    public String toString() {
        return "FileEntry: " + String.valueOf(this.getPath());
    }

    @Override
    public List getDependents(ClassLoader classLoader) {
        return null;
    }

    @Override
    public List getPackagerEntries() {
        LinkedList<PackagerFileEntry> list = new LinkedList<PackagerFileEntry>();
        list.add(this);
        return list;
    }
}

