/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.packager;

import com.tangosol.dev.packager.PackagerPath;
import com.tangosol.dev.packager.ResourceSet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class PackageOwnerResourceSet
extends ResourceSet {
    private List ownedPackageList = new LinkedList();

    public PackageOwnerResourceSet() {
    }

    public PackageOwnerResourceSet(String packageName) {
        this.addOwnedPackageName(packageName);
    }

    @Override
    public boolean containsKey(PackagerPath entryPath) {
        String pathName = entryPath.getPathName();
        for (String packageName : this.ownedPackageList) {
            if (!pathName.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public String[] getOwnedPackageNames() {
        return this.ownedPackageList.toArray(new String[this.ownedPackageList.size()]);
    }

    public void setOwnedPackageNames(String[] packageNames) {
        PackageOwnerResourceSet.azzert(packageNames != null);
        this.ownedPackageList = new LinkedList<String>(Arrays.asList(packageNames));
    }

    public void addOwnedPackageName(String packageName) {
        PackageOwnerResourceSet.azzert(packageName != null);
        Object packagePath = packageName.replace('.', '/');
        if (!((String)packagePath).endsWith("/")) {
            packagePath = (String)packagePath + "/";
        }
        this.ownedPackageList.add(packagePath);
    }
}

