/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import com.tangosol.dev.disassembler.Attribute;
import com.tangosol.dev.disassembler.ClassConstant;
import com.tangosol.dev.disassembler.Constant;
import com.tangosol.dev.disassembler.MarkedByteArrayInputStream;
import com.tangosol.dev.disassembler.Member;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class Method
extends Member {
    private int m_iClass;
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    public static final int NOP = 0;
    public static final int ACONST_NULL = 1;
    public static final int ICONST_M1 = 2;
    public static final int ICONST_0 = 3;
    public static final int ICONST_1 = 4;
    public static final int ICONST_2 = 5;
    public static final int ICONST_3 = 6;
    public static final int ICONST_4 = 7;
    public static final int ICONST_5 = 8;
    public static final int LCONST_0 = 9;
    public static final int LCONST_1 = 10;
    public static final int FCONST_0 = 11;
    public static final int FCONST_1 = 12;
    public static final int FCONST_2 = 13;
    public static final int DCONST_0 = 14;
    public static final int DCONST_1 = 15;
    public static final int BIPUSH = 16;
    public static final int SIPUSH = 17;
    public static final int LDC = 18;
    public static final int LDC_W = 19;
    public static final int LDC2_W = 20;
    public static final int ILOAD = 21;
    public static final int LLOAD = 22;
    public static final int FLOAD = 23;
    public static final int DLOAD = 24;
    public static final int ALOAD = 25;
    public static final int ILOAD_0 = 26;
    public static final int ILOAD_1 = 27;
    public static final int ILOAD_2 = 28;
    public static final int ILOAD_3 = 29;
    public static final int LLOAD_0 = 30;
    public static final int LLOAD_1 = 31;
    public static final int LLOAD_2 = 32;
    public static final int LLOAD_3 = 33;
    public static final int FLOAD_0 = 34;
    public static final int FLOAD_1 = 35;
    public static final int FLOAD_2 = 36;
    public static final int FLOAD_3 = 37;
    public static final int DLOAD_0 = 38;
    public static final int DLOAD_1 = 39;
    public static final int DLOAD_2 = 40;
    public static final int DLOAD_3 = 41;
    public static final int ALOAD_0 = 42;
    public static final int ALOAD_1 = 43;
    public static final int ALOAD_2 = 44;
    public static final int ALOAD_3 = 45;
    public static final int IALOAD = 46;
    public static final int LALOAD = 47;
    public static final int FALOAD = 48;
    public static final int DALOAD = 49;
    public static final int AALOAD = 50;
    public static final int BALOAD = 51;
    public static final int CALOAD = 52;
    public static final int SALOAD = 53;
    public static final int ISTORE = 54;
    public static final int LSTORE = 55;
    public static final int FSTORE = 56;
    public static final int DSTORE = 57;
    public static final int ASTORE = 58;
    public static final int ISTORE_0 = 59;
    public static final int ISTORE_1 = 60;
    public static final int ISTORE_2 = 61;
    public static final int ISTORE_3 = 62;
    public static final int LSTORE_0 = 63;
    public static final int LSTORE_1 = 64;
    public static final int LSTORE_2 = 65;
    public static final int LSTORE_3 = 66;
    public static final int FSTORE_0 = 67;
    public static final int FSTORE_1 = 68;
    public static final int FSTORE_2 = 69;
    public static final int FSTORE_3 = 70;
    public static final int DSTORE_0 = 71;
    public static final int DSTORE_1 = 72;
    public static final int DSTORE_2 = 73;
    public static final int DSTORE_3 = 74;
    public static final int ASTORE_0 = 75;
    public static final int ASTORE_1 = 76;
    public static final int ASTORE_2 = 77;
    public static final int ASTORE_3 = 78;
    public static final int IASTORE = 79;
    public static final int LASTORE = 80;
    public static final int FASTORE = 81;
    public static final int DASTORE = 82;
    public static final int AASTORE = 83;
    public static final int BASTORE = 84;
    public static final int CASTORE = 85;
    public static final int SASTORE = 86;
    public static final int POP = 87;
    public static final int POP2 = 88;
    public static final int DUP = 89;
    public static final int DUP_X1 = 90;
    public static final int DUP_X2 = 91;
    public static final int DUP2 = 92;
    public static final int DUP2_X1 = 93;
    public static final int DUP2_X2 = 94;
    public static final int SWAP = 95;
    public static final int IADD = 96;
    public static final int LADD = 97;
    public static final int FADD = 98;
    public static final int DADD = 99;
    public static final int ISUB = 100;
    public static final int LSUB = 101;
    public static final int FSUB = 102;
    public static final int DSUB = 103;
    public static final int IMUL = 104;
    public static final int LMUL = 105;
    public static final int FMUL = 106;
    public static final int DMUL = 107;
    public static final int IDIV = 108;
    public static final int LDIV = 109;
    public static final int FDIV = 110;
    public static final int DDIV = 111;
    public static final int IREM = 112;
    public static final int LREM = 113;
    public static final int FREM = 114;
    public static final int DREM = 115;
    public static final int INEG = 116;
    public static final int LNEG = 117;
    public static final int FNEG = 118;
    public static final int DNEG = 119;
    public static final int ISHL = 120;
    public static final int LSHL = 121;
    public static final int ISHR = 122;
    public static final int LSHR = 123;
    public static final int IUSHR = 124;
    public static final int LUSHR = 125;
    public static final int IAND = 126;
    public static final int LAND = 127;
    public static final int IOR = 128;
    public static final int LOR = 129;
    public static final int IXOR = 130;
    public static final int LXOR = 131;
    public static final int IINC = 132;
    public static final int I2L = 133;
    public static final int I2F = 134;
    public static final int I2D = 135;
    public static final int L2I = 136;
    public static final int L2F = 137;
    public static final int L2D = 138;
    public static final int F2I = 139;
    public static final int F2L = 140;
    public static final int F2D = 141;
    public static final int D2I = 142;
    public static final int D2L = 143;
    public static final int D2F = 144;
    public static final int I2B = 145;
    public static final int I2C = 146;
    public static final int I2S = 147;
    public static final int LCMP = 148;
    public static final int FCMPL = 149;
    public static final int FCMPG = 150;
    public static final int DCMPL = 151;
    public static final int DCMPG = 152;
    public static final int IFEQ = 153;
    public static final int IFNE = 154;
    public static final int IFLT = 155;
    public static final int IFGE = 156;
    public static final int IFGT = 157;
    public static final int IFLE = 158;
    public static final int IF_ICMPEQ = 159;
    public static final int IF_ICMPNE = 160;
    public static final int IF_ICMPLT = 161;
    public static final int IF_ICMPGE = 162;
    public static final int IF_ICMPGT = 163;
    public static final int IF_ICMPLE = 164;
    public static final int IF_ACMPEQ = 165;
    public static final int IF_ACMPNE = 166;
    public static final int GOTO = 167;
    public static final int JSR = 168;
    public static final int RET = 169;
    public static final int TABLESWITCH = 170;
    public static final int LOOKUPSWITCH = 171;
    public static final int IRETURN = 172;
    public static final int LRETURN = 173;
    public static final int FRETURN = 174;
    public static final int DRETURN = 175;
    public static final int ARETURN = 176;
    public static final int RETURN = 177;
    public static final int GETSTATIC = 178;
    public static final int PUTSTATIC = 179;
    public static final int GETFIELD = 180;
    public static final int PUTFIELD = 181;
    public static final int INVOKEVIRTUAL = 182;
    public static final int INVOKESPECIAL = 183;
    public static final int INVOKESTATIC = 184;
    public static final int INVOKEINTERFACE = 185;
    public static final int NEW = 187;
    public static final int NEWARRAY = 188;
    public static final int ANEWARRAY = 189;
    public static final int ARRAYLENGTH = 190;
    public static final int ATHROW = 191;
    public static final int CHECKCAST = 192;
    public static final int INSTANCEOF = 193;
    public static final int MONITORENTER = 194;
    public static final int MONITOREXIT = 195;
    public static final int WIDE = 196;
    public static final int MULTIANEWARRAY = 197;
    public static final int IFNULL = 198;
    public static final int IFNONNULL = 199;
    public static final int GOTO_W = 200;
    public static final int JSR_W = 201;
    private static final String[] OPNAME = new String[256];

    public static Method[] readMethods(DataInput stream, Constant[] aconst, int iClass) throws IOException {
        int cMethods = stream.readUnsignedShort();
        Method[] aMethods = new Method[cMethods];
        for (int i = 0; i < cMethods; ++i) {
            aMethods[i] = new Method(stream, aconst, iClass);
        }
        return aMethods;
    }

    public Method(DataInput stream, Constant[] aconst, int iClass) throws IOException {
        super(stream, aconst);
        this.m_iClass = iClass;
    }

    public String[] getParameters() {
        return Method.getParameters(this.getSignature());
    }

    public String getActualDeclaration() {
        StringBuffer sb = new StringBuffer();
        String[] asSig = this.getParameters();
        sb.append(Method.getType(asSig[0])).append(' ').append(this.getName()).append('(');
        int c = asSig.length;
        for (int i = 1; i < c; ++i) {
            if (i > 1) {
                sb.append(", ");
            }
            sb.append(Method.getType(asSig[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    public String getDeclaration() {
        String sName = this.getName();
        if (sName.equals("<init>")) {
            StringBuffer sb = new StringBuffer();
            sb.append(((ClassConstant)this.m_aconst[this.m_iClass]).getSimpleName()).append('(');
            String[] asSig = this.getParameters();
            int c = asSig.length;
            for (int i = 1; i < c; ++i) {
                if (i > 1) {
                    sb.append(", ");
                }
                sb.append(Method.getType(asSig[i]));
            }
            sb.append(')');
            return sb.toString();
        }
        if (sName.equals("<clinit>")) {
            return this.isStatic() ? "" : "<clinit>";
        }
        return this.getActualDeclaration();
    }

    public String[] getThrows() {
        Attribute attr = this.getAttribute("Exceptions");
        if (attr == null) {
            return null;
        }
        try {
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(attr.getInfo()));
            int c = stream.readUnsignedShort();
            String[] as = new String[c];
            for (int i = 0; i < c; ++i) {
                as[i] = ((ClassConstant)this.m_aconst[stream.readUnsignedShort()]).getName();
            }
            return as;
        }
        catch (IOException e) {
            throw new RuntimeException("Illegal \"Exceptions\" Attribute structure.  (" + e.toString() + ")");
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString(1343));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.getDeclaration());
        return sb.toString();
    }

    public void dump(PrintWriter out, String sBaseIndent) {
        String sPkg = ((ClassConstant)this.m_aconst[this.m_iClass]).getPackageName();
        String sIndent = "    ";
        out.print(sBaseIndent + this.toString());
        String[] asThrows = this.getThrows();
        if (asThrows != null && asThrows.length > 0) {
            String sThrowsIndent = sBaseIndent + sIndent + sIndent;
            int c = asThrows.length;
            for (int i = 0; i < c; ++i) {
                String sThrows = asThrows[i];
                if (sThrows.startsWith(sPkg) && sThrows.lastIndexOf(46) == sPkg.length()) {
                    sThrows = sThrows.substring(sPkg.length() + 1);
                }
                if (i == 0) {
                    out.println();
                    out.print(sThrowsIndent + "throws " + sThrows);
                    continue;
                }
                out.println(',');
                out.print(sThrowsIndent + "       " + sThrows);
            }
        }
        if (this.isAbstract()) {
            out.println(';');
        } else {
            String sCodeIndent = sBaseIndent + sIndent;
            out.println();
            out.println(sCodeIndent + "{");
            this.dumpCode(out, sCodeIndent);
            out.println(sCodeIndent + "}");
        }
    }

    public void dumpCode(PrintWriter out, String sIndent) {
        if (this.isNative()) {
            out.println(sIndent + "<native>");
            return;
        }
        Attribute attr = this.getAttribute("Code");
        byte[] abInfo = attr.getInfo();
        int cbInfo = abInfo.length;
        try {
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(abInfo));
            out.println(sIndent + "#pragma max_stack " + stream.readUnsignedShort());
            out.println(sIndent + "#pragma max_locals " + stream.readUnsignedShort());
            int ofCode = 8;
            int cbCode = stream.readInt();
            int cHexDigits = 0;
            int cDecDigits = 0;
            int cbTemp = cbCode - 1;
            do {
                cHexDigits += 2;
            } while ((cbTemp /= 256) > 0);
            cbTemp = cbCode - 1;
            do {
                ++cDecDigits;
            } while ((cbTemp /= 10) > 0);
            cDecDigits = Math.max(cDecDigits, 2);
            int cchHead = cDecDigits + cHexDigits + 17;
            char[] achHead = new char[cchHead];
            for (int i = 0; i < cchHead; ++i) {
                achHead[i] = 32;
            }
            achHead[0] = 91;
            achHead[cDecDigits + 1] = 47;
            achHead[cDecDigits + cHexDigits + 2] = 93;
            String sFill = "                         ";
            String sTab = "  ";
            MarkedByteArrayInputStream streamRaw = new MarkedByteArrayInputStream(abInfo, ofCode, cbCode);
            stream = new DataInputStream(streamRaw);
            boolean fSwitch = false;
            boolean fTable = false;
            boolean fDft = false;
            int cCases = 0;
            int nCase = 0;
            int ofOp = 0;
            int ofDft = 0;
            do {
                Object sDisp;
                Object sParms = null;
                Object sNotes = null;
                Object sName = null;
                if (fSwitch) {
                    if (fDft || cCases == 0) {
                        sParms = "default:  goto " + (ofOp + ofDft);
                        fSwitch = false;
                        fDft = false;
                    } else {
                        int n = fTable ? nCase++ : stream.readInt();
                        int of = stream.readInt();
                        sParms = "case " + n + ":  goto " + (ofOp + of);
                        if (--cCases == 0) {
                            fDft = true;
                        }
                    }
                } else {
                    boolean fWide;
                    int op = stream.readUnsignedByte();
                    sName = OPNAME[op];
                    if (sName == null) {
                        throw new RuntimeException("Illegal byte code (" + op + ") at offset " + streamRaw.getMarkedOffset() + ".");
                    }
                    boolean bl = fWide = op == 196;
                    if (fWide) {
                        op = stream.readUnsignedByte();
                        sName = (String)sName + " " + OPNAME[op];
                    }
                    switch (op) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 169: {
                            int n = fWide ? stream.readUnsignedShort() : stream.readUnsignedByte();
                            sParms = Integer.toString(n);
                            break;
                        }
                        case 187: 
                        case 189: 
                        case 192: 
                        case 193: {
                            int n = stream.readUnsignedShort();
                            sParms = Integer.toString(n);
                            sNotes = this.m_aconst[n].toString();
                            break;
                        }
                        case 16: {
                            int n = stream.readUnsignedByte();
                            sParms = Integer.toString(n);
                            sNotes = "(0x" + Integer.toHexString(n) + ")";
                            break;
                        }
                        case 178: 
                        case 179: 
                        case 180: 
                        case 181: {
                            int n = stream.readUnsignedShort();
                            sParms = Integer.toString(n);
                            sNotes = this.m_aconst[n].toString();
                            break;
                        }
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 168: 
                        case 198: 
                        case 199: {
                            ofOp = streamRaw.getMarkedOffset();
                            short n = stream.readShort();
                            sParms = Integer.toString(ofOp + n);
                            break;
                        }
                        case 200: 
                        case 201: {
                            ofOp = streamRaw.getMarkedOffset();
                            int n = stream.readInt();
                            sParms = Integer.toString(ofOp + n);
                            break;
                        }
                        case 132: {
                            short n;
                            int v;
                            if (fWide) {
                                v = stream.readUnsignedShort();
                                n = stream.readShort();
                                sNotes = "(0x" + Integer.toHexString(n & 0xFFFF) + ")";
                            } else {
                                v = stream.readUnsignedByte();
                                n = stream.readByte();
                                sNotes = "(0x" + Integer.toHexString(n & 0xFF) + ")";
                            }
                            sParms = Integer.toString(v) + "," + Integer.toString(n);
                            break;
                        }
                        case 185: {
                            int n = stream.readUnsignedShort();
                            int c = stream.readUnsignedByte();
                            stream.readUnsignedByte();
                            sParms = Integer.toString(n) + "," + Integer.toString(c);
                            sNotes = this.m_aconst[n].toString();
                            break;
                        }
                        case 182: 
                        case 183: 
                        case 184: {
                            int n = stream.readUnsignedShort();
                            sParms = Integer.toString(n);
                            sNotes = this.m_aconst[n].toString();
                            break;
                        }
                        case 18: 
                        case 19: 
                        case 20: {
                            int n = op == 18 ? stream.readUnsignedByte() : stream.readUnsignedShort();
                            sParms = Integer.toString(n);
                            sNotes = this.m_aconst[n].toString();
                            break;
                        }
                        case 171: {
                            fSwitch = true;
                            fTable = false;
                            ofOp = streamRaw.getMarkedOffset();
                            while ((streamRaw.getCurrentOffset() & 3) != 0) {
                                if (stream.readUnsignedByte() == 0) continue;
                                throw new RuntimeException("lookupswitch not alligned using NOP at " + ofOp);
                            }
                            ofDft = stream.readInt();
                            cCases = stream.readInt();
                            break;
                        }
                        case 197: {
                            int n = stream.readUnsignedShort();
                            int c = stream.readUnsignedByte();
                            sParms = Integer.toString(n) + "," + Integer.toString(c);
                            sNotes = this.m_aconst[n].toString();
                            break;
                        }
                        case 188: {
                            int n = stream.readUnsignedByte();
                            sParms = Integer.toString(n);
                            switch (n) {
                                case 4: {
                                    sNotes = "boolean";
                                    break;
                                }
                                case 5: {
                                    sNotes = "char";
                                    break;
                                }
                                case 6: {
                                    sNotes = "float";
                                    break;
                                }
                                case 7: {
                                    sNotes = "double";
                                    break;
                                }
                                case 8: {
                                    sNotes = "byte";
                                    break;
                                }
                                case 9: {
                                    sNotes = "short";
                                    break;
                                }
                                case 10: {
                                    sNotes = "int";
                                    break;
                                }
                                case 11: {
                                    sNotes = "long";
                                }
                            }
                            break;
                        }
                        case 17: {
                            short n = stream.readShort();
                            sParms = Integer.toString(n);
                            sNotes = "(0x" + Integer.toHexString(n) + ")";
                            break;
                        }
                        case 170: {
                            fSwitch = true;
                            fTable = true;
                            ofOp = streamRaw.getMarkedOffset();
                            while ((streamRaw.getCurrentOffset() & 3) != 0) {
                                if (stream.readUnsignedByte() == 0) continue;
                                throw new RuntimeException("tableswitch not alligned using NOP at " + ofOp);
                            }
                            ofDft = stream.readInt();
                            nCase = stream.readInt();
                            cCases = stream.readInt() - nCase + 1;
                        }
                    }
                }
                int ofStart = streamRaw.getMarkedOffset();
                int ofEnd = streamRaw.getCurrentOffset();
                byte[] abBytes = streamRaw.getMarkedBytes();
                this.formatOpHeader(achHead, ofStart, cDecDigits, cHexDigits, abBytes, 0);
                Object object = sDisp = sName == null ? "    " : (String)sName + " ";
                if (sParms != null) {
                    sDisp = (String)sDisp + (String)sParms;
                }
                if (((String)sDisp).length() < 25) {
                    sDisp = ((String)sDisp + sFill).substring(0, 25);
                }
                if (sNotes != null) {
                    sDisp = (String)sDisp + sTab + (String)sNotes;
                }
                out.print(sIndent);
                out.print(achHead);
                out.println((String)sDisp);
                if (abBytes.length <= 4) continue;
                for (int of = ofStart + 4; of < ofEnd; of += 4) {
                    this.formatOpHeader(achHead, of, cDecDigits, cHexDigits, abBytes, of - ofStart);
                    out.print(sIndent);
                    out.println(achHead);
                }
            } while (streamRaw.available() != 0);
        }
        catch (IOException e) {
            Method.out(e);
            throw new RuntimeException("Illegal \"Code\" Attribute structure.  (" + e.toString() + ")");
        }
    }

    private void formatOpHeader(char[] ach, int nOffset, int cDecDigits, int cHexDigits, byte[] ab, int iFirst) {
        int of = cDecDigits;
        int n = nOffset;
        while (of > 0) {
            ach[of--] = (char)(48 + n % 10);
            n /= 10;
        }
        of = cDecDigits + cHexDigits + 1;
        for (int i = 0; i < cHexDigits; ++i) {
            ach[of--] = HEX[nOffset & 0xF];
            nOffset >>= 4;
        }
        of = cDecDigits + cHexDigits + 4;
        int iLast = iFirst + 4;
        int cb = ab.length;
        for (int i = iFirst; i < iLast; ++i) {
            if (i >= cb) {
                ach[of] = 32;
                ach[of + 1] = 32;
            } else {
                n = ab[i] & 0xFF;
                ach[of] = HEX[(n & 0xF0) >> 4];
                ach[of + 1] = HEX[n & 0xF];
            }
            of += 3;
        }
    }

    static {
        Method.OPNAME[0] = "nop";
        Method.OPNAME[1] = "aconst_null";
        Method.OPNAME[2] = "iconst_m1";
        Method.OPNAME[3] = "iconst_0";
        Method.OPNAME[4] = "iconst_1";
        Method.OPNAME[5] = "iconst_2";
        Method.OPNAME[6] = "iconst_3";
        Method.OPNAME[7] = "iconst_4";
        Method.OPNAME[8] = "iconst_5";
        Method.OPNAME[9] = "lconst_0";
        Method.OPNAME[10] = "lconst_1";
        Method.OPNAME[11] = "fconst_0";
        Method.OPNAME[12] = "fconst_1";
        Method.OPNAME[13] = "fconst_2";
        Method.OPNAME[14] = "dconst_0";
        Method.OPNAME[15] = "dconst_1";
        Method.OPNAME[16] = "bipush";
        Method.OPNAME[17] = "sipush";
        Method.OPNAME[18] = "ldc";
        Method.OPNAME[19] = "ldc_w";
        Method.OPNAME[20] = "ldc2_w";
        Method.OPNAME[21] = "iload";
        Method.OPNAME[22] = "lload";
        Method.OPNAME[23] = "fload";
        Method.OPNAME[24] = "dload";
        Method.OPNAME[25] = "aload";
        Method.OPNAME[26] = "iload_0";
        Method.OPNAME[27] = "iload_1";
        Method.OPNAME[28] = "iload_2";
        Method.OPNAME[29] = "iload_3";
        Method.OPNAME[30] = "lload_0";
        Method.OPNAME[31] = "lload_1";
        Method.OPNAME[32] = "lload_2";
        Method.OPNAME[33] = "lload_3";
        Method.OPNAME[34] = "fload_0";
        Method.OPNAME[35] = "fload_1";
        Method.OPNAME[36] = "fload_2";
        Method.OPNAME[37] = "fload_3";
        Method.OPNAME[38] = "dload_0";
        Method.OPNAME[39] = "dload_1";
        Method.OPNAME[40] = "dload_2";
        Method.OPNAME[41] = "dload_3";
        Method.OPNAME[42] = "aload_0";
        Method.OPNAME[43] = "aload_1";
        Method.OPNAME[44] = "aload_2";
        Method.OPNAME[45] = "aload_3";
        Method.OPNAME[46] = "iaload";
        Method.OPNAME[47] = "laload";
        Method.OPNAME[48] = "faload";
        Method.OPNAME[49] = "daload";
        Method.OPNAME[50] = "aaload";
        Method.OPNAME[51] = "baload";
        Method.OPNAME[52] = "caload";
        Method.OPNAME[53] = "saload";
        Method.OPNAME[54] = "istore";
        Method.OPNAME[55] = "lstore";
        Method.OPNAME[56] = "fstore";
        Method.OPNAME[57] = "dstore";
        Method.OPNAME[58] = "astore";
        Method.OPNAME[59] = "istore_0";
        Method.OPNAME[60] = "istore_1";
        Method.OPNAME[61] = "istore_2";
        Method.OPNAME[62] = "istore_3";
        Method.OPNAME[63] = "lstore_0";
        Method.OPNAME[64] = "lstore_1";
        Method.OPNAME[65] = "lstore_2";
        Method.OPNAME[66] = "lstore_3";
        Method.OPNAME[67] = "fstore_0";
        Method.OPNAME[68] = "fstore_1";
        Method.OPNAME[69] = "fstore_2";
        Method.OPNAME[70] = "fstore_3";
        Method.OPNAME[71] = "dstore_0";
        Method.OPNAME[72] = "dstore_1";
        Method.OPNAME[73] = "dstore_2";
        Method.OPNAME[74] = "dstore_3";
        Method.OPNAME[75] = "astore_0";
        Method.OPNAME[76] = "astore_1";
        Method.OPNAME[77] = "astore_2";
        Method.OPNAME[78] = "astore_3";
        Method.OPNAME[79] = "iastore";
        Method.OPNAME[80] = "lastore";
        Method.OPNAME[81] = "fastore";
        Method.OPNAME[82] = "dastore";
        Method.OPNAME[83] = "aastore";
        Method.OPNAME[84] = "bastore";
        Method.OPNAME[85] = "castore";
        Method.OPNAME[86] = "sastore";
        Method.OPNAME[87] = "pop";
        Method.OPNAME[88] = "pop2";
        Method.OPNAME[89] = "dup";
        Method.OPNAME[90] = "dup_x1";
        Method.OPNAME[91] = "dup_x2";
        Method.OPNAME[92] = "dup2";
        Method.OPNAME[93] = "dup2_x1";
        Method.OPNAME[94] = "dup2_x2";
        Method.OPNAME[95] = "swap";
        Method.OPNAME[96] = "iadd";
        Method.OPNAME[97] = "ladd";
        Method.OPNAME[98] = "fadd";
        Method.OPNAME[99] = "dadd";
        Method.OPNAME[100] = "isub";
        Method.OPNAME[101] = "lsub";
        Method.OPNAME[102] = "fsub";
        Method.OPNAME[103] = "dsub";
        Method.OPNAME[104] = "imul";
        Method.OPNAME[105] = "lmul";
        Method.OPNAME[106] = "fmul";
        Method.OPNAME[107] = "dmul";
        Method.OPNAME[108] = "idiv";
        Method.OPNAME[109] = "ldiv";
        Method.OPNAME[110] = "fdiv";
        Method.OPNAME[111] = "ddiv";
        Method.OPNAME[112] = "irem";
        Method.OPNAME[113] = "lrem";
        Method.OPNAME[114] = "frem";
        Method.OPNAME[115] = "drem";
        Method.OPNAME[116] = "ineg";
        Method.OPNAME[117] = "lneg";
        Method.OPNAME[118] = "fneg";
        Method.OPNAME[119] = "dneg";
        Method.OPNAME[120] = "ishl";
        Method.OPNAME[121] = "lshl";
        Method.OPNAME[122] = "ishr";
        Method.OPNAME[123] = "lshr";
        Method.OPNAME[124] = "iushr";
        Method.OPNAME[125] = "lushr";
        Method.OPNAME[126] = "iand";
        Method.OPNAME[127] = "land";
        Method.OPNAME[128] = "ior";
        Method.OPNAME[129] = "lor";
        Method.OPNAME[130] = "ixor";
        Method.OPNAME[131] = "lxor";
        Method.OPNAME[132] = "iinc";
        Method.OPNAME[133] = "i2l";
        Method.OPNAME[134] = "i2f";
        Method.OPNAME[135] = "i2d";
        Method.OPNAME[136] = "l2i";
        Method.OPNAME[137] = "l2f";
        Method.OPNAME[138] = "l2d";
        Method.OPNAME[139] = "f2i";
        Method.OPNAME[140] = "f2l";
        Method.OPNAME[141] = "f2d";
        Method.OPNAME[142] = "d2i";
        Method.OPNAME[143] = "d2l";
        Method.OPNAME[144] = "d2f";
        Method.OPNAME[145] = "i2b";
        Method.OPNAME[146] = "i2c";
        Method.OPNAME[147] = "i2s";
        Method.OPNAME[148] = "lcmp";
        Method.OPNAME[149] = "fcmpl";
        Method.OPNAME[150] = "fcmpg";
        Method.OPNAME[151] = "dcmpl";
        Method.OPNAME[152] = "dcmpg";
        Method.OPNAME[153] = "ifeq";
        Method.OPNAME[154] = "ifne";
        Method.OPNAME[155] = "iflt";
        Method.OPNAME[156] = "ifge";
        Method.OPNAME[157] = "ifgt";
        Method.OPNAME[158] = "ifle";
        Method.OPNAME[159] = "if_icmpeq";
        Method.OPNAME[160] = "if_icmpne";
        Method.OPNAME[161] = "if_icmplt";
        Method.OPNAME[162] = "if_icmpge";
        Method.OPNAME[163] = "if_icmpgt";
        Method.OPNAME[164] = "if_icmple";
        Method.OPNAME[165] = "if_acmpeq";
        Method.OPNAME[166] = "if_acmpne";
        Method.OPNAME[167] = "goto";
        Method.OPNAME[168] = "jsr";
        Method.OPNAME[169] = "ret";
        Method.OPNAME[170] = "tableswitch";
        Method.OPNAME[171] = "lookupswitch";
        Method.OPNAME[172] = "ireturn";
        Method.OPNAME[173] = "lreturn";
        Method.OPNAME[174] = "freturn";
        Method.OPNAME[175] = "dreturn";
        Method.OPNAME[176] = "areturn";
        Method.OPNAME[177] = "return";
        Method.OPNAME[178] = "getstatic";
        Method.OPNAME[179] = "putstatic";
        Method.OPNAME[180] = "getfield";
        Method.OPNAME[181] = "putfield";
        Method.OPNAME[182] = "invokevirtual";
        Method.OPNAME[183] = "invokespecial";
        Method.OPNAME[184] = "invokestatic";
        Method.OPNAME[185] = "invokeinterface";
        Method.OPNAME[187] = "new";
        Method.OPNAME[188] = "newarray";
        Method.OPNAME[189] = "anewarray";
        Method.OPNAME[190] = "arraylength";
        Method.OPNAME[191] = "athrow";
        Method.OPNAME[192] = "checkcast";
        Method.OPNAME[193] = "instanceof";
        Method.OPNAME[194] = "monitorenter";
        Method.OPNAME[195] = "monitorexit";
        Method.OPNAME[196] = "wide";
        Method.OPNAME[197] = "multianewarray";
        Method.OPNAME[198] = "ifnull";
        Method.OPNAME[199] = "ifnonnull";
        Method.OPNAME[200] = "goto_w";
        Method.OPNAME[201] = "jsr_w";
    }
}

