/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import com.tangosol.dev.compiler.java.LiteralToken;
import com.tangosol.dev.disassembler.Attribute;
import com.tangosol.dev.disassembler.Constant;
import com.tangosol.dev.disassembler.DoubleConstant;
import com.tangosol.dev.disassembler.FloatConstant;
import com.tangosol.dev.disassembler.IntConstant;
import com.tangosol.dev.disassembler.LongConstant;
import com.tangosol.dev.disassembler.Member;
import com.tangosol.dev.disassembler.StringConstant;
import java.io.DataInput;
import java.io.IOException;

public class Field
extends Member {
    public static Field[] readFields(DataInput stream, Constant[] aconst) throws IOException {
        int cFields = stream.readUnsignedShort();
        Field[] aFields = new Field[cFields];
        for (int i = 0; i < cFields; ++i) {
            aFields[i] = new Field(stream, aconst);
        }
        return aFields;
    }

    public Field(DataInput stream, Constant[] aconst) throws IOException {
        super(stream, aconst);
    }

    public String getType() {
        return Field.getType(this.getSignature());
    }

    public boolean isConstant() {
        return this.getAttribute("ConstantValue") != null;
    }

    public String getConstant() {
        Attribute attr = this.getAttribute("ConstantValue");
        if (attr == null) {
            return null;
        }
        byte[] abConst = attr.getInfo();
        if (abConst == null || abConst.length != 2) {
            throw new RuntimeException("Illegal \"ConstantValue\" Attribute structure.");
        }
        int iConst = (abConst[0] & 0xFF) << 8 | abConst[1] & 0xFF;
        Constant constant = this.m_aconst[iConst];
        switch (constant.getType()) {
            case 8: {
                return LiteralToken.printableString(((StringConstant)constant).getText());
            }
            case 3: {
                int n = ((IntConstant)constant).getInt();
                switch (this.getSignature().charAt(0)) {
                    case 'Z': {
                        return n == 0 ? "false" : "true";
                    }
                    case 'C': {
                        return LiteralToken.printableChar((char)n);
                    }
                }
                return Integer.toString(n);
            }
            case 4: {
                float fl = ((FloatConstant)constant).getFloat();
                return new StringBuffer().append(fl).append('F').toString();
            }
            case 5: {
                long l = ((LongConstant)constant).getLong();
                return new StringBuffer().append(l).append('L').toString();
            }
            case 6: {
                double dfl = ((DoubleConstant)constant).getDouble();
                return Double.toString(dfl);
            }
        }
        throw new RuntimeException("Illegal \"ConstantValue\" data type (" + constant.getType() + ").");
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString(223));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(this.getType()).append(' ').append(this.getName());
        return sb.toString();
    }
}

