/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import com.tangosol.dev.disassembler.Access;
import com.tangosol.dev.disassembler.Attribute;
import com.tangosol.dev.disassembler.ClassConstant;
import com.tangosol.dev.disassembler.Constant;
import com.tangosol.dev.disassembler.Field;
import com.tangosol.dev.disassembler.Method;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintWriter;

public class ClassFile
extends Access {
    private Constant[] m_aconst;
    private int m_iClass;
    private int m_iSuper;
    private int[] m_aiIface;
    private Field[] m_afield;
    private Method[] m_amethod;
    private Attribute[] m_aAttr;

    public ClassFile(DataInput stream) throws IOException {
        int nMagic = stream.readInt();
        if (nMagic != -889275714) {
            throw new IOException("Format Error:  Java .class files start with 0xCAFEBABE");
        }
        int nMinor = stream.readUnsignedShort();
        int nMajor = stream.readUnsignedShort();
        this.m_aconst = Constant.readConstants(stream);
        this.readAccess(stream);
        this.m_iClass = stream.readUnsignedShort();
        this.m_iSuper = stream.readUnsignedShort();
        int c = stream.readUnsignedShort();
        this.m_aiIface = new int[c];
        for (int i = 0; i < c; ++i) {
            this.m_aiIface[i] = stream.readUnsignedShort();
        }
        this.m_afield = Field.readFields(stream, this.m_aconst);
        this.m_amethod = Method.readMethods(stream, this.m_aconst, this.m_iClass);
        this.m_aAttr = Attribute.readAttributes(stream, this.m_aconst);
    }

    public int getClassIndex() {
        return this.m_iClass;
    }

    public int getSuperIndex() {
        return this.m_iSuper;
    }

    public int getInterfaceCount() {
        return this.m_aiIface.length;
    }

    public int getInterfaceIndex(int i) {
        return this.m_aiIface[i];
    }

    public int getFieldCount() {
        return this.m_afield.length;
    }

    public Field getField(int i) {
        return this.m_afield[i];
    }

    public int getMethodCount() {
        return this.m_amethod.length;
    }

    public Method getMethod(int i) {
        return this.m_amethod[i];
    }

    public int getConstantCount() {
        return this.m_aconst.length;
    }

    public Constant getConstant(int i) {
        return this.m_aconst[i];
    }

    public Attribute[] getAttributes() {
        return (Attribute[])this.m_aAttr.clone();
    }

    public int getAttributeCount() {
        return this.m_aAttr.length;
    }

    public Attribute getAttribute(int i) {
        return this.m_aAttr[i];
    }

    @Override
    public String toString() {
        int c;
        ClassConstant constSuper;
        String sMod;
        StringBuffer sb = new StringBuffer();
        String sIndent = "    ";
        ClassConstant constThis = (ClassConstant)this.m_aconst[this.m_iClass];
        String sThis = constThis.getSimpleName();
        String sPkgThis = constThis.getPackageName();
        if (sPkgThis.length() > 0) {
            sb.append("package ").append(sPkgThis).append(";\n\n");
        }
        if ((sMod = super.toString(this.isInterface() ? 17 : 1073)).length() > 0) {
            sb.append(sMod).append(' ');
        }
        sb.append(this.isInterface() ? "interface " : "class ").append(sThis);
        if (this.m_iSuper != 0 && !(constSuper = (ClassConstant)this.m_aconst[this.m_iSuper]).getName().equals("java.lang.Object")) {
            sb.append(" extends ");
            if (sPkgThis.equals(constSuper.getPackageName())) {
                sb.append(constSuper.getSimpleName());
            } else {
                sb.append(constSuper.getName());
            }
        }
        if ((c = this.m_aiIface.length) > 0) {
            String sSubIndent = null;
            for (int i = 0; i < c; ++i) {
                if (i == 0) {
                    String sKeyword;
                    if (this.isInterface()) {
                        sKeyword = "extends ";
                        sSubIndent = "        ";
                    } else {
                        sKeyword = "implements ";
                        sSubIndent = "           ";
                    }
                    sb.append('\n').append(sIndent).append(sKeyword);
                } else {
                    sb.append(",\n").append(sIndent).append(sSubIndent);
                }
                ClassConstant constant = (ClassConstant)this.m_aconst[this.m_aiIface[i]];
                if (sPkgThis.equals(constant.getPackageName())) {
                    sb.append(constant.getSimpleName());
                    continue;
                }
                sb.append(constant.getName());
            }
        }
        return sb.toString();
    }

    public void dump(PrintWriter out) {
        String sIndent = "    ";
        out.println(this.toString());
        out.println(sIndent + "{");
        for (Field field : this.m_afield) {
            out.print(sIndent + field.toString());
            if (field.isConstant()) {
                out.println(" = " + field.getConstant() + ";");
                continue;
            }
            out.println(';');
        }
        int c = this.m_amethod.length;
        for (int i = 0; i < c; ++i) {
            if (i == 0 && this.m_afield.length > 0 || i > 0) {
                out.println();
            }
            this.m_amethod[i].dump(out, sIndent);
        }
        out.println(sIndent + "}");
    }

    public static String indentString(String sText, String sIndent, boolean fIndentFirstLine) {
        char[] ach = sText.toCharArray();
        int cch = ach.length;
        StringBuffer sb = new StringBuffer();
        int iLine = 0;
        int of = 0;
        int ofPrev = 0;
        while (of < cch) {
            if (ach[of++] != '\n' && of != cch) continue;
            if (iLine++ > 0 || fIndentFirstLine) {
                sb.append(sIndent);
            }
            sb.append(sText.substring(ofPrev, of));
            ofPrev = of;
        }
        return sb.toString();
    }
}

