/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.disassembler;

import com.tangosol.util.Base;
import java.io.DataInput;
import java.io.IOException;

public abstract class Access
extends Base {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_ALL = 2047;
    public static final int ACC_CLASS = 1073;
    public static final int ACC_IFACE = 17;
    public static final int ACC_FIELD = 223;
    public static final int ACC_METHOD = 1343;
    private int m_nAccess;

    protected Access() {
    }

    protected Access(DataInput stream) throws IOException {
        this.m_nAccess = stream.readUnsignedShort();
    }

    protected void readAccess(DataInput stream) throws IOException {
        this.m_nAccess = stream.readUnsignedShort();
    }

    public boolean isPublic() {
        return (this.m_nAccess & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.m_nAccess & 2) != 0;
    }

    public boolean isProtected() {
        return (this.m_nAccess & 4) != 0;
    }

    public boolean isStatic() {
        return (this.m_nAccess & 8) != 0;
    }

    public boolean isFinal() {
        return (this.m_nAccess & 0x10) != 0;
    }

    public boolean isSynchronized() {
        return (this.m_nAccess & 0x20) != 0;
    }

    public boolean isVolatile() {
        return (this.m_nAccess & 0x40) != 0;
    }

    public boolean isTransient() {
        return (this.m_nAccess & 0x80) != 0;
    }

    public boolean isNative() {
        return (this.m_nAccess & 0x100) != 0;
    }

    public boolean isInterface() {
        return (this.m_nAccess & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.m_nAccess & 0x400) != 0;
    }

    public String toString() {
        return this.toString(2047);
    }

    public String toString(int nMask) {
        StringBuffer sb = new StringBuffer();
        int nAccess = this.m_nAccess & nMask;
        if ((nAccess & 1) != 0) {
            sb.append(" public");
        }
        if ((nAccess & 2) != 0) {
            sb.append(" private");
        }
        if ((nAccess & 4) != 0) {
            sb.append(" protected");
        }
        if ((nAccess & 8) != 0) {
            sb.append(" static");
        }
        if ((nAccess & 0x10) != 0) {
            sb.append(" final");
        }
        if ((nAccess & 0x20) != 0) {
            sb.append(" synchronized");
        }
        if ((nAccess & 0x40) != 0) {
            sb.append(" volatile");
        }
        if ((nAccess & 0x80) != 0) {
            sb.append(" transient");
        }
        if ((nAccess & 0x100) != 0) {
            sb.append(" native");
        }
        if ((nAccess & 0x200) != 0) {
            sb.append(" interface");
        }
        if ((nAccess & 0x400) != 0) {
            sb.append(" abstract");
        }
        return sb.length() == 0 ? "" : sb.toString().substring(1);
    }
}

