/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.component.JarStorage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class WarStorage
extends JarStorage {
    private static final String CLASS = "WarStorage";
    private static final String ROOT = "WEB-INF/classes/";

    public WarStorage(File fileWar) {
        super(fileWar, ROOT);
    }

    public WarStorage(File fileEar, String sName) {
        super(fileEar, sName + "!/WEB-INF/classes/");
    }

    @Override
    public byte[] loadOriginalResource(String sName) throws IOException {
        byte[] ab = super.loadOriginalResource(sName);
        if (ab == null) {
            try {
                ab = this.loadFileBytes("/" + sName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return ab;
    }

    @Override
    protected int getEntryType(String sEntry) {
        int iType = super.getEntryType(sEntry);
        if (iType == -1 && !sEntry.endsWith("/") && !sEntry.equalsIgnoreCase("META-INF/Manifest.mf")) {
            iType = 5;
        }
        return iType;
    }

    @Override
    public String toString() {
        return "WarStorage(" + this.getJar().getName() + ")";
    }
}

