/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.coherence.config.Config;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Constants;
import com.tangosol.dev.component.DerivationException;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.SubChangeEvent;
import com.tangosol.dev.component.SubChangeListener;
import com.tangosol.dev.component.VetoableSubChangeListener;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.ErrorList;
import com.tangosol.util.IllegalStringException;
import com.tangosol.util.Listeners;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.StringMap;
import com.tangosol.util.StringTable;
import com.tangosol.util.UID;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;

public abstract class Trait
extends Base
implements Constants {
    public static final String ATTR_UID = "UID";
    public static final String ATTR_TIP = "Tip";
    public static final String ATTR_TEXT = "Text";
    public static final String ATTR_REPDESC = "ReplaceDescription";
    public static final String ATTR_DESC = "Description";
    private static final String CLASS = "Trait";
    protected static final boolean DEBUG;
    private static final int ORIGIN_LEVEL = 3;
    private static final int ORIGIN_THIS = 0;
    private static final int ORIGIN_BASE = 1;
    private static final int ORIGIN_SUPER = 2;
    private static final int ORIGIN_MANUAL = 4;
    private static final int ORIGIN_TRAIT = 8;
    private Listeners notifyPre = new Listeners();
    private Listeners notifyPost = new Listeners();
    private Listeners notifySubPre = new Listeners();
    private Listeners notifySubPost = new Listeners();
    private Trait m_parent;
    private int m_nMode;
    private UID m_uid = null;
    private int m_nOrigin;
    private StringTable m_tblOrigin;
    private String m_sTip = "";
    private transient String m_sPrevTip = "";
    private String m_sDesc = "";
    private String m_sPrevDesc = "";
    private boolean m_fReplaceDesc = false;
    private transient boolean m_fPrevReplaceDesc = false;
    private transient boolean m_fDispatch = false;
    private transient int m_nState = 0;

    protected Trait(Trait parent, int nMode) {
        if (nMode != 1 && nMode != 2 && nMode != 3) {
            throw new IllegalArgumentException("Trait:  Invalid mode for Trait construction (" + nMode + ")");
        }
        this.m_parent = parent;
        this.m_nMode = nMode;
    }

    protected Trait(Trait base, Trait parent, int nMode) {
        this(parent, nMode);
        if (base == null || base.getClass() != this.getClass()) {
            throw new IllegalArgumentException("Trait:  Invalid base for blank Trait construction (" + String.valueOf(base) + ")");
        }
        this.m_uid = base.m_uid;
    }

    protected Trait(Trait parent, Trait that) {
        this(parent, that.m_nMode);
        StringTable tbl = that.m_tblOrigin;
        if (tbl != null) {
            tbl = (StringTable)tbl.clone();
        }
        this.m_uid = that.m_uid;
        this.m_nOrigin = that.m_nOrigin;
        this.m_tblOrigin = tbl;
        this.m_sTip = that.m_sTip;
        this.m_sPrevTip = that.m_sPrevTip;
        this.m_sDesc = that.m_sDesc;
        this.m_sPrevDesc = that.m_sPrevDesc;
        this.m_fReplaceDesc = that.m_fReplaceDesc;
        this.m_fPrevReplaceDesc = that.m_fPrevReplaceDesc;
        this.m_nState = that.m_nState;
    }

    protected Trait(Trait parent, DataInput stream, int nVersion) throws IOException {
        this(parent, stream.readUnsignedByte());
        this.m_sTip = Trait.readString(stream);
        this.m_sDesc = Trait.readString(stream);
        this.m_fReplaceDesc = stream.readBoolean();
        if (this.m_fReplaceDesc && this.m_sDesc == "") {
            this.m_fReplaceDesc = false;
        }
        if (stream.readBoolean()) {
            this.m_uid = new UID(stream);
        }
        this.m_nOrigin = stream.readUnsignedByte();
        int cTraits = stream.readUnsignedByte();
        if (cTraits > 0) {
            StringTable tbl = new StringTable();
            for (int i = 0; i < cTraits; ++i) {
                tbl.add(stream.readUTF());
            }
            this.m_tblOrigin = tbl;
        }
        this.m_nState = 1;
    }

    protected Trait(Trait parent, XmlElement xml, int nVersion) throws IOException {
        this(parent, Trait.parseMode(xml.getSafeElement("mode").getString()));
        XmlElement xmlUid;
        XmlElement xmlDesc = xml.getElement("description");
        if (xmlDesc != null) {
            this.m_sTip = Trait.readString(xmlDesc.getElement("tip"));
            this.m_sDesc = Trait.readString(xmlDesc.getElement("text"));
            this.m_fReplaceDesc = Trait.readBoolean(xmlDesc.getElement("replace"));
        }
        if ((xmlUid = xml.getElement("uid")) != null) {
            this.m_uid = new UID(xmlUid.getString());
        }
        int nOrigin = 2;
        StringTable tblTraits = null;
        XmlElement xmlOrigin = xml.getElement("origin");
        if (xmlOrigin != null) {
            XmlElement xmlTraits;
            String sLevel = Trait.readString(xmlOrigin.getElement("level"));
            if (sLevel.length() > 0) {
                switch (sLevel.charAt(0)) {
                    case 'T': 
                    case 't': {
                        nOrigin = 0;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        nOrigin = 1;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        nOrigin = 2;
                        break;
                    }
                    default: {
                        throw new IOException("invalid origin level: " + sLevel);
                    }
                }
            }
            if (Trait.readBoolean(xmlOrigin.getElement("manual"))) {
                nOrigin |= 4;
            }
            if ((xmlTraits = xmlOrigin.getElement("traits")) != null) {
                List listTraits = xmlTraits.getElementList();
                for (XmlElement xmlTrait : listTraits) {
                    String sTrait;
                    if (!xmlTrait.getName().equals("trait") || (sTrait = Trait.readString(xmlTrait)).length() <= 0) continue;
                    if (tblTraits == null) {
                        tblTraits = new StringTable();
                        nOrigin |= 8;
                    }
                    tblTraits.add(sTrait);
                }
            }
        }
        this.m_nOrigin = nOrigin;
        this.m_tblOrigin = tblTraits;
        this.m_nState = 1;
    }

    protected synchronized void save(DataOutput stream) throws IOException {
        if (this.m_nMode != 1 && this.m_nMode != 2 && this.m_nMode != 3) {
            throw new IOException("Trait.save:  Trait contains invalid mode (" + this.toString() + ", " + this.m_nMode + ")");
        }
        stream.writeByte(this.m_nMode);
        stream.writeUTF(this.m_sTip);
        stream.writeUTF(this.m_sDesc);
        stream.writeBoolean(this.m_fReplaceDesc);
        boolean fHasUID = this.m_uid != null;
        stream.writeBoolean(fHasUID);
        if (fHasUID) {
            this.m_uid.save(stream);
        }
        stream.writeByte(this.m_nOrigin);
        StringTable tbl = this.m_tblOrigin;
        int cTraits = tbl == null ? 0 : tbl.getSize();
        stream.writeByte(cTraits);
        if (cTraits > 0) {
            Enumeration enmr = tbl.keys();
            while (enmr.hasMoreElements()) {
                stream.writeUTF((String)enmr.nextElement());
            }
        }
    }

    protected synchronized void save(XmlElement xml) throws IOException {
        xml.addElement("mode").setString(switch (this.m_nMode) {
            case 1 -> "resolved";
            case 2 -> "derivation";
            case 3 -> "modification";
            default -> throw new IOException("Trait.save:  Trait contains invalid mode (" + this.toString() + ", " + this.m_nMode + ")");
        });
        String sTip = this.m_sTip;
        String sText = this.m_sDesc;
        boolean fReplace = this.m_fReplaceDesc;
        if (sTip != "" || sText != "" || fReplace) {
            XmlElement xmlDesc = xml.addElement("description");
            if (sTip != "") {
                xmlDesc.addElement("tip").setString(this.m_sTip);
            }
            if (sText != "" || fReplace) {
                xmlDesc.addElement("text").setString(sText);
            }
            if (fReplace) {
                xmlDesc.addElement("replace").setBoolean(true);
            }
        }
        if (this.m_uid != null) {
            xml.addElement("uid").setString(this.m_uid.toString());
        }
        int nOrigin = this.m_nOrigin;
        StringTable tblOrigin = this.m_tblOrigin;
        if (nOrigin != 2 || tblOrigin != null && !tblOrigin.isEmpty()) {
            XmlElement xmlOrigin = xml.addElement("origin");
            xmlOrigin.addElement("level").setString(switch (nOrigin & 3) {
                case 0 -> "this";
                case 1 -> "base";
                case 2 -> "super";
                default -> "invalid";
            });
            if ((nOrigin & 4) != 0) {
                xmlOrigin.addElement("manual").setBoolean(true);
            }
            if (tblOrigin != null && !tblOrigin.isEmpty()) {
                XmlElement xmlTraits = xmlOrigin.addElement("traits");
                Enumeration enmr = tblOrigin.keys();
                while (enmr.hasMoreElements()) {
                    xmlTraits.addElement("trait").setString((String)enmr.nextElement());
                }
            }
        }
    }

    protected static String readString(DataInput stream) throws IOException {
        String s = stream.readUTF();
        return s.length() > 0 ? s : "";
    }

    private static int parseMode(String s) {
        int nMode = 1;
        if (s != null && s.length() > 1) {
            switch (s.charAt(0)) {
                case 'D': 
                case 'd': {
                    nMode = 2;
                    break;
                }
                case 'M': 
                case 'm': {
                    nMode = 3;
                }
            }
        }
        return nMode;
    }

    protected static String readString(XmlValue xml) {
        String s = null;
        if (xml != null) {
            s = xml.getString();
        }
        if (s == null || s.length() == 0) {
            s = "";
        }
        return s;
    }

    protected static boolean readBoolean(XmlValue xml) {
        boolean f = false;
        if (xml != null) {
            f = xml.getBoolean();
        }
        return f;
    }

    protected static int readFlags(XmlElement xml, String sName, int nDefault) {
        String sFlags;
        int nFlags = nDefault;
        if ((xml = xml.getElement(sName)) != null && (sFlags = xml.getString()) != null && sFlags.length() > 0) {
            nFlags = sFlags.length() > 2 && sFlags.charAt(0) == '0' && (sFlags.charAt(1) == 'x' || sFlags.charAt(1) == 'X') ? Integer.parseInt(sFlags.substring(2), 16) : Integer.parseInt(sFlags);
        }
        return nFlags;
    }

    protected static void saveFlags(XmlElement xml, String sName, int nFlags, int nDefault) {
        if (nFlags != nDefault) {
            xml.addElement(sName).setString("0x" + Trait.toHexString(nFlags, 8));
        }
    }

    protected static void saveTable(XmlElement xml, StringTable tbl, String sTable, String sEntry) throws IOException {
        if (tbl != null && !tbl.isEmpty()) {
            xml = xml.addElement(sTable);
            Enumeration enmr = tbl.elements();
            while (enmr.hasMoreElements()) {
                Trait trait = (Trait)enmr.nextElement();
                trait.save(xml.addElement(sEntry));
            }
        }
    }

    protected static void saveTableKeys(XmlElement xml, StringTable tbl, String sTable, String sEntry) throws IOException {
        if (tbl != null && !tbl.isEmpty()) {
            xml = xml.addElement(sTable);
            Enumeration enmr = tbl.keys();
            while (enmr.hasMoreElements()) {
                xml.addElement(sEntry).setString((String)enmr.nextElement());
            }
        }
    }

    protected static StringTable readTableKeys(XmlElement xml, String sTable, String sEntry) throws IOException {
        StringTable tbl = null;
        if ((xml = xml.getElement(sTable)) != null) {
            List listEntry = xml.getElementList();
            for (XmlElement xmlEntry : listEntry) {
                if (!xmlEntry.getName().equals(sEntry)) continue;
                if (tbl == null) {
                    tbl = new StringTable();
                }
                tbl.add(xmlEntry.getString());
            }
        }
        return tbl;
    }

    protected static void saveStringMap(XmlElement xml, String sMap, String sEntry, StringMap map) throws IOException {
        if (!map.isEmpty()) {
            xml = xml.addElement(sMap);
            Enumeration enmr = map.primaryStrings();
            while (enmr.hasMoreElements()) {
                String sKey = (String)enmr.nextElement();
                String sValue = map.get(sKey);
                XmlElement xmlEntry = xml.addElement(sEntry);
                xmlEntry.addElement("map-from").setString(sKey);
                xmlEntry.addElement("map-to").setString(sValue);
            }
        }
    }

    protected static StringMap readStringMap(XmlElement xml, String sMap, String sEntry) throws IOException {
        StringMap map = new StringMap();
        if ((xml = xml.getElement(sMap)) != null) {
            List listEntry = xml.getElementList();
            for (XmlElement xmlEntry : listEntry) {
                if (!xmlEntry.getName().equals(sEntry)) continue;
                String sKey = Trait.readString(xmlEntry.getElement("map-from"));
                String sValue = Trait.readString(xmlEntry.getElement("map-to"));
                try {
                    map.put(sKey, sValue);
                }
                catch (IllegalStringException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
        return map;
    }

    protected abstract Trait getBlankDerivedTrait(Trait var1, int var2);

    protected Trait getNullDerivedTrait(Trait parent, int nMode) {
        if (nMode == 1) {
            throw new IllegalArgumentException("Trait.getNullDerivedTrait:  :  Invalid mode for null Trait construction (" + nMode + ")");
        }
        return this.getBlankDerivedTrait(parent, nMode);
    }

    protected Trait resolveDelta(Trait delta, Loader loader, ErrorList errlist) throws ComponentException {
        Trait base = this;
        switch (base.m_nMode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("Trait.resolveDelta:  Illegal base mode (" + base.m_nMode + ") for resolving modification!");
            }
        }
        switch (delta.m_nMode) {
            case 2: {
                if (base.m_nMode == 1) break;
            }
            case 1: {
                delta = delta.extract(base, delta.m_parent, loader, errlist);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Trait.resolveDelta:  Illegal delta mode (" + delta.m_nMode + ")");
            }
        }
        return delta;
    }

    protected Trait resolve(Trait delta, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Trait base = this;
        Trait derived = null;
        derived = base.getBlankDerivedTrait(parent, base.m_nMode);
        derived.m_sTip = delta.m_sTip;
        derived.m_sPrevTip = delta.m_sPrevTip != "" ? delta.m_sPrevTip : (base.m_sTip != "" ? base.m_sTip : base.m_sPrevTip);
        derived.m_sDesc = delta.m_sDesc;
        derived.m_fReplaceDesc = delta.m_fReplaceDesc;
        if (delta.m_fPrevReplaceDesc) {
            derived.m_sPrevDesc = delta.m_sPrevDesc;
            derived.m_fPrevReplaceDesc = true;
        } else {
            derived.m_sPrevDesc = Trait.getDescription(delta.m_sPrevDesc, base.getDescription(), false);
            boolean bl = derived.m_fPrevReplaceDesc = base.m_fReplaceDesc || base.m_fPrevReplaceDesc;
        }
        if (base.m_uid == null) {
            derived.m_uid = delta.m_uid;
        } else if (!base.m_uid.equals(delta.m_uid)) {
            this.logError("RES-001", 2, new Object[]{delta.toString(), delta.toPathString()}, errlist);
        }
        int n = derived.m_nOrigin = base.isFromSuper() || delta.m_nMode == 2 ? 2 : 1;
        if (delta.isFromManual()) {
            derived.setFromManual();
        }
        derived.m_nMode = base.m_nMode;
        delta.m_nState = 1;
        return derived;
    }

    protected void finalizeResolve(Loader loader, ErrorList errlist) throws ComponentException {
        if (this.m_sTip == "") {
            this.m_sTip = this.m_sPrevTip;
        }
        if (this.m_nMode != 1) {
            this.logError("RES-002", 2, new Object[]{this.toString(), this.toPathString()}, errlist);
            this.m_nMode = 1;
        }
        this.m_fPrevReplaceDesc = false;
        this.m_nState = 2;
    }

    protected int getExtractMode(Trait base) {
        if (this.m_nMode == 1 && base.m_nMode == 1) {
            return this.m_parent.getExtractMode(base.m_parent);
        }
        return 3;
    }

    protected Trait extract(Trait base, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        int nMode = this.getExtractMode(base);
        if (nMode != 2 && nMode != 3) {
            throw new IllegalArgumentException("Trait.extract:  Illegal extract mode (" + nMode + ")");
        }
        Trait derived = this;
        Trait delta = base.getBlankDerivedTrait(parent, nMode);
        String sTip = derived.m_sTip;
        String sPrevTip = derived.m_sPrevTip;
        if (derived.m_nState == 2) {
            if (sTip.equals(sPrevTip)) {
                sTip = "";
            }
            sPrevTip = "";
        }
        if (sTip != "") {
            if (base.m_sTip != "") {
                sPrevTip = base.m_sTip;
            } else if (base.m_sPrevTip != "") {
                sPrevTip = base.m_sPrevTip;
            }
        }
        delta.m_sTip = sTip;
        delta.m_sPrevTip = sPrevTip;
        boolean fReplaceDesc = derived.m_fReplaceDesc;
        String sDesc = derived.m_sDesc;
        boolean fPrevReplaceDesc = derived.m_fPrevReplaceDesc;
        String sPrevDesc = derived.m_sPrevDesc;
        switch (derived.m_nState) {
            case 1: {
                if (fReplaceDesc == base.m_fReplaceDesc && sDesc.equals(base.m_sDesc)) {
                    fReplaceDesc = false;
                    sDesc = "";
                }
                fPrevReplaceDesc = false;
                sPrevDesc = "";
                break;
            }
            case 2: {
                fPrevReplaceDesc = false;
                sPrevDesc = "";
            }
            default: {
                if (!fReplaceDesc && sDesc == "") break;
                if (base.m_fReplaceDesc || base.m_sDesc != "") {
                    fPrevReplaceDesc = base.m_fReplaceDesc;
                    sPrevDesc = base.m_sDesc;
                    break;
                }
                if (!base.m_fPrevReplaceDesc && base.m_sPrevDesc == "") break;
                fPrevReplaceDesc = base.m_fPrevReplaceDesc;
                sPrevDesc = base.m_sPrevDesc;
            }
        }
        delta.m_fReplaceDesc = fReplaceDesc;
        delta.m_sDesc = sDesc;
        delta.m_fPrevReplaceDesc = fPrevReplaceDesc;
        delta.m_sPrevDesc = sPrevDesc;
        if (base.m_uid == null) {
            delta.m_uid = derived.m_uid;
        } else if (!base.m_uid.equals(derived.m_uid)) {
            this.logError("EXT-001", 2, new Object[]{derived.toString(), derived.toPathString()}, errlist);
        }
        delta.m_nState = 3;
        return delta;
    }

    protected synchronized void finalizeExtract(Loader loader, ErrorList errlist) throws ComponentException {
        if (this.m_nMode != 1) {
            if (this.m_sTip.equals(this.m_sPrevTip)) {
                this.m_sTip = "";
            }
            if (this.m_fReplaceDesc == this.m_fPrevReplaceDesc && this.m_sDesc.equals(this.m_sPrevDesc)) {
                this.m_fReplaceDesc = false;
                this.m_sDesc = "";
            }
        }
        this.m_sPrevTip = "";
        this.m_fPrevReplaceDesc = false;
        this.m_sPrevDesc = "";
        this.m_nOrigin &= 4;
        this.m_tblOrigin = null;
    }

    protected boolean isDiscardable() {
        switch (this.m_nMode) {
            case 1: {
                if (this.isFromNothing()) {
                    Trait trait = this.m_parent;
                    while (trait != null) {
                        int nMode = trait.m_nMode;
                        if (nMode == 2 || nMode == 3) {
                            return false;
                        }
                        trait = trait.m_parent;
                    }
                    break;
                }
                return false;
            }
            case 2: 
            case 3: {
                if (this.m_fReplaceDesc || this.m_sTip != "" || this.m_sDesc != "" || this.isFromManual()) {
                    return false;
                }
                Enumeration enmr = this.getSubTraits();
                while (enmr.hasMoreElements()) {
                    Trait trait = (Trait)enmr.nextElement();
                    if (trait.isDiscardable()) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    protected boolean isClassDiscardable(Trait base) {
        return this.getDescription().equals(base.getDescription()) && this.getTip().equals(base.getTip());
    }

    protected boolean isClassDiscardableFromSubtraitTable(StringTable tblThis, StringTable tblThat) {
        if (!tblThis.keysEquals(tblThat)) {
            return false;
        }
        Enumeration enmr = tblThis.keys();
        while (enmr.hasMoreElements()) {
            Trait traitThat;
            String s = (String)enmr.nextElement();
            Trait traitThis = (Trait)tblThis.get(s);
            if (traitThis.isClassDiscardable(traitThat = (Trait)tblThat.get(s))) continue;
            return false;
        }
        return true;
    }

    public void logError(String sCode, int nSeverity, Object[] aoParam, ErrorList errlist) throws DerivationException {
        if (errlist != null) {
            try {
                errlist.add(new ErrorList.Item(sCode, nSeverity, null, aoParam, null, RESOURCES));
            }
            catch (ErrorList.OverflowException e) {
                throw new DerivationException("Error list full");
            }
        }
    }

    public boolean isModifiable() {
        return this.m_parent == null || this.m_parent.isModifiable();
    }

    protected Trait getParentTrait() {
        return this.m_parent;
    }

    protected Enumeration getSubTraits() {
        return NullImplementation.getEnumeration();
    }

    public Component getParentComponent() {
        Trait parent;
        for (parent = this.getParentTrait(); parent != null && !(parent instanceof Component); parent = parent.getParentTrait()) {
        }
        return (Component)parent;
    }

    public int getMode() {
        return this.m_nMode;
    }

    protected void setMode(int nMode) {
        if (nMode != this.m_nMode) {
            switch (nMode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.m_nMode = nMode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Trait.setMode:  Illegal mode value (" + nMode + ")");
                }
            }
        }
    }

    protected int getProcessState() {
        return this.m_nState;
    }

    protected void validate() {
        if ((this.m_parent == null || this.m_parent.m_fDispatch) && !this.m_fDispatch) {
            this.m_fDispatch = true;
            Enumeration enmr = this.getSubTraits();
            while (enmr.hasMoreElements()) {
                ((Trait)enmr.nextElement()).validate();
            }
        }
    }

    protected void invalidate() {
        if (this.m_nMode != 0) {
            this.m_fDispatch = false;
            this.notifyPre.removeAll();
            this.notifyPost.removeAll();
            this.notifySubPre.removeAll();
            this.notifySubPost.removeAll();
            this.setMode(0);
            Enumeration enmr = this.getSubTraits();
            while (enmr.hasMoreElements()) {
                ((Trait)enmr.nextElement()).invalidate();
            }
            this.notifyPre = null;
            this.notifyPost = null;
            this.notifySubPre = null;
            this.notifySubPost = null;
            this.m_parent = null;
            this.m_uid = null;
            this.m_tblOrigin = null;
            this.m_sTip = null;
            this.m_sPrevTip = null;
            this.m_sDesc = null;
            this.m_sPrevDesc = null;
        }
    }

    public boolean isDeclaredAtThisLevel() {
        return (this.m_nOrigin & 3) == 0;
    }

    public boolean isFromBase() {
        return (this.m_nOrigin & 3) == 1;
    }

    protected void setFromBase() {
        Trait.azzert((this.m_nOrigin & 3) != 2);
        this.m_nOrigin = this.m_nOrigin & 0xFFFFFFFC | 1;
    }

    public boolean isFromSuper() {
        return (this.m_nOrigin & 3) == 2;
    }

    public boolean isFromTrait() {
        return (this.m_nOrigin & 8) != 0;
    }

    public boolean isFromTrait(Trait trait) {
        StringTable tbl = this.m_tblOrigin;
        return tbl != null && tbl.contains(trait.getUniqueDescription());
    }

    protected Enumeration getOriginTraits() {
        StringTable tbl = this.m_tblOrigin;
        return tbl == null ? NullImplementation.getEnumeration() : tbl.keys();
    }

    protected boolean isFromTraitDescriptor(String sDescriptor) {
        StringTable tbl = this.m_tblOrigin;
        return tbl != null && tbl.stringsStartingWith(sDescriptor + " ").length > 0;
    }

    protected Enumeration getOriginTraits(String sDescriptor) {
        StringTable tbl = this.m_tblOrigin;
        if (tbl == null) {
            return NullImplementation.getEnumeration();
        }
        String[] asDesc = tbl.stringsStartingWith(sDescriptor + " ");
        int cDesc = asDesc.length;
        if (cDesc < 1) {
            return NullImplementation.getEnumeration();
        }
        for (int i = 0; i < cDesc; ++i) {
            String sDesc = asDesc[i];
            asDesc[i] = sDesc.substring(sDesc.indexOf(32) + 1);
        }
        return new SimpleEnumerator<String>(asDesc);
    }

    protected void addOriginTrait(Trait trait) {
        StringTable tbl = this.m_tblOrigin;
        if (tbl == null) {
            this.m_tblOrigin = tbl = new StringTable();
            this.m_nOrigin |= 8;
        }
        tbl.add(trait.getUniqueDescription());
    }

    protected void removeOriginTrait(Trait trait) {
        StringTable tbl = this.m_tblOrigin;
        if (tbl != null) {
            tbl.remove(trait.getUniqueDescription());
            if (tbl.isEmpty()) {
                this.m_tblOrigin = null;
                this.m_nOrigin &= 0xFFFFFFF7;
            }
        }
    }

    public boolean isFromManual() {
        return (this.m_nOrigin & 4) != 0;
    }

    protected void setFromManual() {
        this.m_nOrigin |= 4;
    }

    protected void clearFromManual() {
        this.m_nOrigin &= 0xFFFFFFFB;
    }

    public boolean isFromNonManual() {
        return (this.m_nOrigin & 0xFFFFFFFB) != 0;
    }

    public boolean isFromNothing() {
        return this.m_nOrigin == 0;
    }

    public UID getUID() {
        return this.m_uid;
    }

    protected void setUID(UID uid) throws PropertyVetoException {
        this.setUID(uid, true);
    }

    protected synchronized void setUID(UID uid, boolean fVetoable) throws PropertyVetoException {
        UID prev = this.m_uid;
        if (uid == null ? prev == null : uid.equals(prev)) {
            return;
        }
        if (fVetoable) {
            if (!this.isModifiable()) {
                this.readOnlyAttribute(ATTR_UID, prev, uid);
            }
            this.fireVetoableChange(ATTR_UID, prev, uid);
        }
        this.m_uid = uid;
        this.firePropertyChange(ATTR_UID, prev, uid);
    }

    protected void assignUID() {
        if (this.m_uid == null) {
            try {
                this.setUID(new UID(), false);
            }
            catch (PropertyVetoException e) {
                throw new IllegalStateException("Trait.assignUID:  Unexpected Veto Exception!");
            }
        }
    }

    protected void clearUID() {
        try {
            this.setUID(null, false);
        }
        catch (PropertyVetoException e) {
            throw new IllegalStateException("Trait.assignUID:  Unexpected Veto Exception!");
        }
    }

    protected abstract String getUniqueName();

    protected abstract String getUniqueDescription();

    protected static Hashtable getUIDTable(Enumeration enmr) {
        Hashtable<UID, String> tbl = new Hashtable<UID, String>();
        while (enmr.hasMoreElements()) {
            Trait trait = (Trait)enmr.nextElement();
            tbl.put(trait.getUID(), trait.getUniqueName());
        }
        return tbl;
    }

    public String getTip() {
        return this.m_sTip;
    }

    public boolean isTipSettable() {
        return this.isModifiable();
    }

    public void setTip(String sTip) throws PropertyVetoException {
        this.setTip(sTip, true);
    }

    protected synchronized void setTip(String sTip, boolean fVetoable) throws PropertyVetoException {
        String sPrev = this.m_sTip;
        if (sTip == null) {
            sTip = "";
        }
        if (sTip.equals(sPrev)) {
            return;
        }
        if (fVetoable) {
            if (!this.isTipSettable()) {
                this.readOnlyAttribute(ATTR_TIP, sPrev, sTip);
            }
            if (sTip.length() == 0) {
                sTip = this.m_sPrevTip;
            }
            this.fireVetoableChange(ATTR_TIP, sPrev, sTip);
        }
        this.m_sTip = sTip;
        this.firePropertyChange(ATTR_TIP, sPrev, sTip);
    }

    public String getText() {
        return this.m_sDesc;
    }

    public boolean isTextSettable() {
        return this.isModifiable();
    }

    public void setText(String sDesc) throws PropertyVetoException {
        this.setText(sDesc, true);
    }

    protected synchronized void setText(String sDesc, boolean fVetoable) throws PropertyVetoException {
        String sPrev = this.getText();
        if (sDesc == null || sDesc.length() == 0) {
            sDesc = "";
        }
        if (sDesc.equals(sPrev)) {
            return;
        }
        if (fVetoable) {
            if (!this.isTextSettable()) {
                this.readOnlyAttribute(ATTR_TEXT, sPrev, sDesc);
            }
            this.fireVetoableChange(ATTR_TEXT, sPrev, sDesc);
        }
        this.m_sDesc = sDesc;
        this.firePropertyChange(ATTR_TEXT, sPrev, sDesc);
    }

    public boolean isReplaceDescription() {
        return this.m_fReplaceDesc;
    }

    public boolean isReplaceDescriptionSettable() {
        return this.isModifiable();
    }

    public void setReplaceDescription(boolean fReplaceDesc) throws PropertyVetoException {
        this.setReplaceDescription(fReplaceDesc, true);
    }

    protected synchronized void setReplaceDescription(boolean fReplaceDesc, boolean fVetoable) throws PropertyVetoException {
        boolean fPrev = this.m_fReplaceDesc;
        if (fReplaceDesc == fPrev) {
            return;
        }
        Boolean value = Trait.toBoolean(fReplaceDesc);
        Boolean prev = Trait.toBoolean(fPrev);
        if (fVetoable) {
            if (!this.isReplaceDescriptionSettable()) {
                this.readOnlyAttribute(ATTR_REPDESC, prev, value);
            }
            this.fireVetoableChange(ATTR_REPDESC, prev, value);
        }
        this.m_fReplaceDesc = fReplaceDesc;
        this.firePropertyChange(ATTR_REPDESC, prev, value);
    }

    public String getDescription() {
        return Trait.getDescription(this.m_sDesc, this.m_sPrevDesc, this.m_fReplaceDesc);
    }

    protected static String getDescription(String sDesc, String sPrevDesc, boolean fReplaceDesc) {
        if (fReplaceDesc || sPrevDesc == "") {
            return sDesc;
        }
        if (sDesc == "") {
            return sPrevDesc;
        }
        return sPrevDesc + "\n" + sDesc;
    }

    public boolean isDescriptionSettable() {
        return this.isTextSettable();
    }

    public void setDescription(String sDesc) throws PropertyVetoException {
        this.setDescription(sDesc, true);
    }

    protected synchronized void setDescription(String sDesc, boolean fVetoable) throws PropertyVetoException {
        String sPrevDesc = this.getDescription();
        if (sDesc == null || sDesc.length() == 0) {
            sDesc = "";
        }
        if (sDesc.equals(sPrevDesc)) {
            return;
        }
        if (fVetoable) {
            if (!this.isDescriptionSettable()) {
                this.readOnlyAttribute(ATTR_DESC, sPrevDesc, sDesc);
            }
            this.fireVetoableChange(ATTR_DESC, sPrevDesc, sDesc);
        }
        boolean bl = this.m_fReplaceDesc = !sDesc.startsWith(this.m_sPrevDesc);
        if (!this.m_fReplaceDesc) {
            sDesc = Trait.extractDescription(sDesc, this.m_sPrevDesc);
        }
        this.m_sDesc = sDesc;
        this.firePropertyChange(ATTR_DESC, sPrevDesc, sDesc);
    }

    protected static String extractDescription(String sThisDesc, String sBaseDesc) {
        int cchBaseDesc;
        int cchThisDesc = sThisDesc.length();
        if (cchThisDesc == (cchBaseDesc = sBaseDesc.length()) || cchThisDesc == cchBaseDesc + 1 && sThisDesc.charAt(cchBaseDesc) == '\n') {
            sThisDesc = "";
        } else if (cchBaseDesc > 0 && cchThisDesc > cchBaseDesc && sThisDesc.startsWith(sBaseDesc)) {
            int cchLF = sThisDesc.charAt(cchBaseDesc) == '\n' ? 1 : 0;
            sThisDesc = sThisDesc.substring(cchBaseDesc + cchLF);
        }
        return sThisDesc;
    }

    public boolean equalsUID(Trait that) {
        return this.m_uid == null ? that.m_uid == null : this.m_uid.equals(that.m_uid);
    }

    public boolean equalsOrigin(Trait that) {
        if (this.m_nOrigin != that.m_nOrigin) {
            return false;
        }
        if (this.m_tblOrigin != null) {
            return this.m_tblOrigin.equals(that.m_tblOrigin);
        }
        return true;
    }

    protected boolean equalsOriginSansManual(Trait that) {
        if (((this.m_nOrigin ^ that.m_nOrigin) & 0xFFFFFFFB) != 0) {
            return false;
        }
        if (this.m_tblOrigin != null) {
            return this.m_tblOrigin.equals(that.m_tblOrigin);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Trait) {
            Trait that = (Trait)obj;
            return this == that || this.m_nMode == that.m_nMode && this.m_fReplaceDesc == that.m_fReplaceDesc && this.m_sTip.equals(that.m_sTip) && this.m_sDesc.equals(that.m_sDesc) && this.equalsOrigin(that) && this.equalsUID(that);
        }
        return false;
    }

    public String toString() {
        return this.getUniqueDescription();
    }

    public String toPathString() {
        Trait parent = this.m_parent;
        return parent == null ? this.toString() : parent.toPathString() + ", " + this.toString();
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.notifyPre.add(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.notifyPre.remove(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.notifyPost.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.notifyPost.remove(listener);
    }

    public void addVetoableSubChangeListener(VetoableSubChangeListener listener) {
        this.notifySubPre.add(listener);
    }

    public void removeVetoableSubChangeListener(VetoableSubChangeListener listener) {
        this.notifySubPre.remove(listener);
    }

    public void addSubChangeListener(SubChangeListener listener) {
        this.notifySubPost.add(listener);
    }

    public void removeSubChangeListener(SubChangeListener listener) {
        this.notifySubPost.remove(listener);
    }

    protected static Boolean toBoolean(boolean f) {
        return f ? Boolean.TRUE : Boolean.FALSE;
    }

    protected void readOnlyAttribute(String sAttribute, Object oPrevVal, Object oNewVal) throws PropertyVetoException {
        String sDesc = RESOURCES.getString("ATTR-001", new String[]{sAttribute}, "The \"{0}\" attribute is not modifiable.");
        PropertyChangeEvent evt = new PropertyChangeEvent(this, sAttribute, oPrevVal, oNewVal);
        throw new PropertyVetoException(sDesc, evt);
    }

    protected void illegalAttributeValue(String sAttribute, Object oPrevVal, Object oNewVal) throws PropertyVetoException {
        String sDesc = RESOURCES.getString("ATTR-002", new String[]{sAttribute}, "An attempt was made to set the \"{0}\" attribute to an illegal value.");
        PropertyChangeEvent evt = new PropertyChangeEvent(this, sAttribute, oPrevVal, oNewVal);
        throw new PropertyVetoException(sDesc, evt);
    }

    protected void subNotAddable(String sAttribute, Object oValue) throws PropertyVetoException {
        String sDesc = RESOURCES.getString("ATTR-003", new String[]{sAttribute}, "The \"{0}\" sub-trait is not addable.");
        PropertyChangeEvent evt = new PropertyChangeEvent(this, sAttribute, null, oValue);
        throw new PropertyVetoException(sDesc, evt);
    }

    protected void subNotRemovable(String sAttribute, Object oValue) throws PropertyVetoException {
        String sDesc = RESOURCES.getString("ATTR-004", new String[]{sAttribute}, "The \"{0}\" sub-trait is not removable.");
        PropertyChangeEvent evt = new PropertyChangeEvent(this, sAttribute, oValue, null);
        throw new PropertyVetoException(sDesc, evt);
    }

    protected void subNotUnremovable(String sAttribute, Object oValue) throws PropertyVetoException {
        String sDesc = RESOURCES.getString("ATTR-005", new String[]{sAttribute}, "The \"{0}\" sub-trait is not unremovable.");
        PropertyChangeEvent evt = new PropertyChangeEvent(this, sAttribute, null, oValue);
        throw new PropertyVetoException(sDesc, evt);
    }

    protected void fireVetoableChange(String sAttribute, Object oPrevVal, Object oNewVal) throws PropertyVetoException {
        this.fireAttributeChange(sAttribute, oPrevVal, oNewVal, 0, null);
    }

    protected void firePropertyChange(String sAttribute, Object oPrevVal, Object oNewVal) {
        try {
            this.fireAttributeChange(sAttribute, oPrevVal, oNewVal, 2, null);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException("Trait.firePropertyChange:  Illegal PropertyVetoException: " + e.toString());
        }
    }

    private void fireAttributeChange(String sAttribute, Object oPrevVal, Object oNewVal, int nContext, Object oStop) throws PropertyVetoException {
        if (!this.m_fDispatch) {
            return;
        }
        boolean fPre = nContext != 2;
        PropertyChangeEvent evtChange = null;
        Listeners notify = fPre ? this.notifyPre : this.notifyPost;
        EventListener[] listeners = notify.listeners();
        int cListeners = listeners.length;
        block18: for (int iListener = 0; iListener < cListeners; ++iListener) {
            if (evtChange == null) {
                evtChange = new PropertyChangeEvent(this, sAttribute, oPrevVal, oNewVal);
            }
            switch (nContext) {
                case 0: {
                    VetoableChangeListener listener = (VetoableChangeListener)listeners[iListener];
                    try {
                        listener.vetoableChange(evtChange);
                        continue block18;
                    }
                    catch (PropertyVetoException e) {
                        this.fireAttributeChange(sAttribute, oNewVal, oPrevVal, 1, listener);
                        throw e;
                    }
                }
                case 1: {
                    VetoableChangeListener listener = (VetoableChangeListener)listeners[iListener];
                    try {
                        listener.vetoableChange(evtChange);
                    }
                    catch (PropertyVetoException e) {
                        // empty catch block
                    }
                    if (listener != oStop) continue block18;
                    return;
                }
                case 2: {
                    ((PropertyChangeListener)listeners[iListener]).propertyChange(evtChange);
                }
            }
        }
        SubChangeEvent evtSub = null;
        Trait trait = this.m_parent;
        while (trait != null) {
            notify = fPre ? trait.notifySubPre : trait.notifySubPost;
            listeners = notify.listeners();
            cListeners = listeners.length;
            block20: for (int iListener = 0; iListener < cListeners; ++iListener) {
                if (evtSub == null) {
                    if (evtChange == null) {
                        evtChange = new PropertyChangeEvent(this, sAttribute, oPrevVal, oNewVal);
                    }
                    evtSub = new SubChangeEvent(this, this, 0, nContext, evtChange);
                }
                switch (nContext) {
                    case 0: {
                        VetoableSubChangeListener listener = (VetoableSubChangeListener)listeners[iListener];
                        try {
                            listener.vetoableSubChange(evtSub);
                            continue block20;
                        }
                        catch (PropertyVetoException e) {
                            this.fireAttributeChange(sAttribute, oNewVal, oPrevVal, 1, listener);
                            throw e;
                        }
                    }
                    case 1: {
                        VetoableSubChangeListener listener = (VetoableSubChangeListener)listeners[iListener];
                        try {
                            listener.vetoableSubChange(evtSub);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        if (listener != oStop) continue block20;
                        return;
                    }
                    case 2: {
                        ((SubChangeListener)listeners[iListener]).subChange(evtSub);
                    }
                }
            }
            trait = trait.m_parent;
        }
    }

    protected void fireVetoableSubChange(Trait traitSub, int nAction) throws PropertyVetoException {
        this.fireSubChange(traitSub, nAction, 0, null);
    }

    protected void fireSubChange(Trait traitSub, int nAction) {
        try {
            this.fireSubChange(traitSub, nAction, 2, null);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException("Trait.fireSubChange:  Illegal PropertyVetoException: " + e.toString());
        }
    }

    private void fireSubChange(Trait traitSub, int nAction, int nContext, Object oStop) throws PropertyVetoException {
        if (!this.m_fDispatch) {
            return;
        }
        SubChangeEvent evt = null;
        Trait trait = this;
        while (trait != null) {
            Listeners notify = nContext == 2 ? trait.notifySubPost : trait.notifySubPre;
            EventListener[] listeners = notify.listeners();
            int cListeners = listeners.length;
            block10: for (int iListener = 0; iListener < cListeners; ++iListener) {
                if (evt == null) {
                    evt = new SubChangeEvent(this, traitSub, nAction, nContext, null);
                }
                switch (nContext) {
                    case 0: {
                        VetoableSubChangeListener listener = (VetoableSubChangeListener)listeners[iListener];
                        try {
                            listener.vetoableSubChange(evt);
                            continue block10;
                        }
                        catch (PropertyVetoException e) {
                            int nUndoAction = nAction == 2 ? 1 : 2;
                            this.fireSubChange(traitSub, nUndoAction, 1, listener);
                            throw e;
                        }
                    }
                    case 1: {
                        VetoableSubChangeListener listener = (VetoableSubChangeListener)listeners[iListener];
                        try {
                            listener.vetoableSubChange(evt);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        if (listener != oStop) continue block10;
                        return;
                    }
                    case 2: {
                        ((SubChangeListener)listeners[iListener]).subChange(evt);
                    }
                }
            }
            trait = trait.m_parent;
        }
    }

    public void dump() {
        PrintWriter out = Trait.getOut();
        this.dumpTree(out, "");
        out.println();
        this.dump(out, "");
    }

    public void dumpTree(PrintWriter out, String sIndent) {
        out.println(sIndent + this.getUniqueDescription());
        Enumeration enmr = this.getSubTraits();
        while (enmr.hasMoreElements()) {
            Trait trait = (Trait)enmr.nextElement();
            trait.dumpTree(out, Trait.nextIndent(sIndent));
        }
    }

    public void dump(PrintWriter out, String sIndent) {
        String NULL = "<null>";
        String sMode = switch (this.m_nMode) {
            case 1 -> "resolved";
            case 2 -> "derivation";
            case 3 -> "modification";
            case 0 -> "invalid";
            default -> "<unknown>";
        };
        String sState = switch (this.m_nState) {
            case 0 -> "new";
            case 1 -> "resolving";
            case 2 -> "resolved";
            case 3 -> "extracting";
            default -> "<unknown>";
        };
        out.print(sIndent + "Parent=");
        out.println((String)(this.m_parent == null ? "<null>" : this.m_parent.toString() + " (depth=" + this.getDepth() + ")"));
        out.print(sIndent + "Mode=" + sMode);
        out.print(", Processing State=" + sState);
        out.print(", Modifiable=" + Trait.toBoolean(this.isModifiable()).toString());
        out.println(", UID=" + (this.m_uid == null ? "<null>" : this.m_uid.toString()));
        out.print(sIndent + "Origin level=" + (switch (this.m_nOrigin & 3) {
            case 0 -> "this";
            case 1 -> "base";
            case 2 -> "super";
            default -> "<invalid>";
        }));
        out.print(", Manual=" + Trait.toBoolean((this.m_nOrigin & 4) != 0).toString());
        out.print(", Trait=" + Trait.toBoolean((this.m_nOrigin & 8) != 0).toString());
        out.println(" " + String.valueOf(this.m_tblOrigin));
        out.println(sIndent + "Tip=" + this.dump(this.m_sTip));
        out.println(sIndent + "Previous Tip=" + this.dump(this.m_sPrevTip));
        out.print(sIndent + "Description ");
        out.print(this.m_fReplaceDesc ? "(replaced)=" : "(added)=");
        out.println(Trait.indentString(this.dump(this.m_sDesc), sIndent, false));
        out.print(sIndent + "Previous Description ");
        out.print(this.m_fPrevReplaceDesc ? "(replaced)=" : "(added)=");
        out.println(Trait.indentString(this.dump(this.m_sPrevDesc), sIndent, false));
    }

    protected String dump(String s) {
        if (s == "") {
            return "<blank>";
        }
        if (s == null) {
            return "<null>";
        }
        return "\"" + s + "\"";
    }

    protected static void dump(PrintWriter out, String sIndent, StringTable tbl, String sDesc) {
        out.println(sIndent + (String)(tbl == null ? "<null>" : "" + tbl.getSize()) + " " + sDesc);
        if (tbl == null) {
            return;
        }
        if (!tbl.isEmpty()) {
            String[] as = tbl.strings();
            int c = as.length;
            for (int i = 0; i < c; ++i) {
                String sName = as[i];
                Trait trait = (Trait)tbl.get(sName);
                out.print(sIndent + "[" + i + "] " + sName + ":");
                if (trait == null) {
                    out.println("  <null>");
                    continue;
                }
                out.println();
                trait.dump(out, Trait.nextIndent(sIndent));
            }
        }
    }

    protected static String nextIndent(String sIndent) {
        return sIndent + "  ";
    }

    protected int getDepth() {
        int cLevels = 0;
        Trait trait = this;
        while (trait.m_parent != null) {
            trait = trait.m_parent;
            ++cLevels;
        }
        return cLevels;
    }

    protected static String arrayDescription(Object[] ao) {
        if (ao == null) {
            return "<null>";
        }
        int c = ao.length;
        if (c == 0) {
            return "<none>";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('[').append(c).append("] (");
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ao[i].toString());
        }
        sb.append(')');
        return sb.toString();
    }

    protected static String flagsDescription(int nFlags, int nMask, boolean fSpecOnly) {
        StringBuffer sb = new StringBuffer();
        if ((nMask & Integer.MIN_VALUE) != 0 && (nFlags & Integer.MIN_VALUE) != 0) {
            sb.append(" throwable");
        }
        if ((nMask & 0x40000000) != 0) {
            sb.append((nFlags & 0x40000000) == 0 ? " class" : " interface");
        }
        if (!((nMask & 1) == 0 || (nFlags & 1) == 0 && fSpecOnly)) {
            switch (nFlags & 6) {
                case 6: {
                    sb.append(" non-existent");
                    break;
                }
                case 2: {
                    sb.append(" insert");
                    break;
                }
                case 0: {
                    sb.append(" update");
                    break;
                }
                case 4: {
                    sb.append(" delete");
                    break;
                }
                default: {
                    sb.append(" <illegal exists>");
                }
            }
        }
        if (!((nMask & 8) == 0 || (nFlags & 8) == 0 && fSpecOnly)) {
            switch (nFlags & 0x30) {
                case 48: {
                    sb.append(" public");
                    break;
                }
                case 32: {
                    sb.append(" protected");
                    break;
                }
                case 16: {
                    sb.append(" package-private");
                    break;
                }
                case 0: {
                    sb.append(" private");
                    break;
                }
                default: {
                    sb.append(" <illegal access>");
                }
            }
        }
        if (!((nMask & 0x40) == 0 || (nFlags & 0x40) == 0 && fSpecOnly)) {
            sb.append((nFlags & 0x80) == 128 ? " synchronized" : " no-monitor");
        }
        if (!((nMask & 0x100) == 0 || (nFlags & 0x100) == 0 && fSpecOnly)) {
            sb.append((nFlags & 0x200) == 0 ? " instance" : " static");
        }
        if (!((nMask & 0x400) == 0 || (nFlags & 0x400) == 0 && fSpecOnly)) {
            sb.append((nFlags & 0x800) == 0 ? " concrete" : " abstract");
        }
        if (!((nMask & 0x1000) == 0 || (nFlags & 0x1000) == 0 && fSpecOnly)) {
            sb.append((nFlags & 0x2000) == 0 ? " derivable" : " final");
        }
        if (!((nMask & 0x4000) == 0 || (nFlags & 0x4000) == 0 && fSpecOnly)) {
            sb.append((nFlags & 0x8000) == 0 ? " current" : " deprecated");
        }
        if (!((nMask & 0x10000) == 0 || (nFlags & 0x10000) == 0 && fSpecOnly)) {
            sb.append((nFlags & 0x20000) == 131072 ? " persistent" : " transient");
        }
        if (!((nMask & 0x40000) == 0 || (nFlags & 0x40000) == 0 && fSpecOnly)) {
            sb.append((nFlags & 0x180000) == 524288 ? " local" : " remote");
        }
        if (!((nMask & 0x200000) == 0 || (nFlags & 0x200000) == 0 && fSpecOnly)) {
            switch (nFlags & 0xC00000) {
                case 0x400000: {
                    sb.append(" in");
                    break;
                }
                case 0x800000: {
                    sb.append(" out");
                    break;
                }
                case 0xC00000: {
                    sb.append(" inout");
                    break;
                }
                default: {
                    sb.append(" <illegal direction>");
                }
            }
        }
        if (!((nMask & 0x1000000) == 0 || (nFlags & 0x1000000) == 0 && fSpecOnly)) {
            switch (nFlags & 0x6000000) {
                case 0x6000000: {
                    sb.append(" system");
                    break;
                }
                case 0x4000000: {
                    sb.append(" hidden");
                    break;
                }
                case 0x2000000: {
                    sb.append(" advanced");
                    break;
                }
                case 0: {
                    sb.append(" visible");
                    break;
                }
                default: {
                    sb.append(" <illegal visibility>");
                }
            }
        }
        if (!((nMask & 0x8000000) == 0 || (nFlags & 0x8000000) == 0 && fSpecOnly)) {
            switch (nFlags & 0x30000000) {
                case 0x10000000: {
                    sb.append(" single");
                    break;
                }
                case 0x30000000: {
                    sb.append(" indexed");
                    break;
                }
                case 0x20000000: {
                    sb.append(" indexed only");
                    break;
                }
                default: {
                    sb.append(" <illegal property>");
                }
            }
        }
        return sb.length() > 0 ? sb.toString().substring(1) : "<none>";
    }

    static {
        boolean fDebug = false;
        String sDebug = Config.getProperty("coherence.component.debug");
        if (sDebug != null && sDebug.length() > 0) {
            char ch = sDebug.charAt(0);
            switch (ch) {
                case '1': 
                case 'T': 
                case 'Y': 
                case 't': 
                case 'y': {
                    fDebug = true;
                }
            }
        }
        DEBUG = fDebug;
    }
}

