/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.component.Behavior;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.DataType;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.Trait;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ErrorList;
import java.beans.PropertyVetoException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;

public class ReturnValue
extends Trait {
    public static final String ATTR_DATATYPE = "DataType";
    private static final String CLASS = "ReturnValue";
    protected static final String DESCRIPTOR = "ReturnValue";
    private DataType m_dt;

    protected ReturnValue(Behavior behavior, DataType dt) {
        super((Trait)behavior, 1);
        if (behavior == null) {
            throw new IllegalArgumentException("ReturnValue:  Containing behavior required.");
        }
        if (dt == null) {
            throw new IllegalArgumentException("ReturnValue:  DataType required.");
        }
        this.m_dt = dt;
    }

    protected ReturnValue(ReturnValue base, Behavior behavior, int nMode) {
        super((Trait)base, behavior, nMode);
        this.m_dt = base.m_dt;
    }

    protected ReturnValue(Behavior behavior, ReturnValue that) {
        super((Trait)behavior, that);
        this.m_dt = that.m_dt;
    }

    protected ReturnValue(Behavior behavior, DataInput stream, int nVersion) throws IOException {
        super((Trait)behavior, stream, nVersion);
        this.m_dt = DataType.getType(stream.readUTF());
    }

    protected ReturnValue(Trait parent, XmlElement xml, int nVersion) throws IOException {
        super(parent, xml, nVersion);
        String sType = ReturnValue.readString(xml.getElement("type"));
        if (sType == "") {
            throw new IOException("type is missing");
        }
        this.m_dt = DataType.getType(sType);
    }

    @Override
    protected synchronized void save(DataOutput stream) throws IOException {
        super.save(stream);
        stream.writeUTF(this.m_dt.getTypeString());
    }

    @Override
    protected synchronized void save(XmlElement xml) throws IOException {
        xml.addElement("type").setString(this.m_dt.getTypeString());
        super.save(xml);
    }

    @Override
    protected Trait getBlankDerivedTrait(Trait parent, int nMode) {
        return new ReturnValue(this, (Behavior)parent, nMode);
    }

    @Override
    protected Trait resolve(Trait traitDelta, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        ReturnValue base = this;
        ReturnValue delta = (ReturnValue)this.resolveDelta(traitDelta, loader, errlist);
        ReturnValue derived = (ReturnValue)super.resolve(delta, parent, loader, errlist);
        if (delta.m_dt != base.m_dt) {
            if (this.getBehavior().getComponent().isSignature()) {
                derived.m_dt = delta.m_dt;
            } else {
                Object[] aoParam = new Object[]{base.getBehavior().toString(), delta.m_dt.toString(), base.m_dt.toString(), derived.toPathString()};
                this.logError("RES-401", 2, aoParam, errlist);
                derived.m_dt = base.m_dt;
            }
        }
        return derived;
    }

    @Override
    protected Trait extract(Trait traitBase, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        ReturnValue derived = this;
        ReturnValue base = (ReturnValue)traitBase;
        ReturnValue delta = (ReturnValue)super.extract(base, parent, loader, errlist);
        if (derived.m_dt != base.m_dt) {
            if (this.getBehavior().getComponent().isSignature()) {
                delta.m_dt = derived.m_dt;
            } else {
                Object[] aoParam = new Object[]{base.getBehavior().toString(), derived.m_dt.toString(), base.m_dt.toString(), derived.toPathString()};
                this.logError("EXT-401", 2, aoParam, errlist);
                delta.m_dt = base.m_dt;
            }
        }
        return delta;
    }

    @Override
    protected synchronized void invalidate() {
        super.invalidate();
        this.m_dt = null;
    }

    @Override
    protected String getUniqueName() {
        return this.m_dt.getTypeString();
    }

    @Override
    protected String getUniqueDescription() {
        return "ReturnValue " + this.getUniqueName();
    }

    public Behavior getBehavior() {
        return (Behavior)this.getParentTrait();
    }

    public DataType getDataType() {
        return this.m_dt;
    }

    public boolean isDataTypeSettable() {
        Behavior behavior = this.getBehavior();
        return this.isModifiable() && !behavior.isFromNonManual();
    }

    public boolean isDataTypeLegal(DataType dt) {
        return dt != null;
    }

    public void setDataType(DataType dt) throws PropertyVetoException {
        this.setDataType(dt, true);
    }

    protected synchronized void setDataType(DataType dt, boolean fVetoable) throws PropertyVetoException {
        DataType dtPrev = this.m_dt;
        if (dt == dtPrev) {
            return;
        }
        if (fVetoable) {
            if (!this.isDataTypeSettable()) {
                this.readOnlyAttribute(ATTR_DATATYPE, dtPrev, dt);
            }
            if (!this.isDataTypeLegal(dt)) {
                this.illegalAttributeValue(ATTR_DATATYPE, dtPrev, dt);
            }
            this.fireVetoableChange(ATTR_DATATYPE, dtPrev, dt);
        }
        this.m_dt = dt;
        this.firePropertyChange(ATTR_DATATYPE, dtPrev, dt);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ReturnValue) {
            ReturnValue that = (ReturnValue)obj;
            return this == that || this.m_dt == that.m_dt && super.equals(that);
        }
        return false;
    }

    @Override
    public void dump(PrintWriter out, String sIndent) {
        out.println(sIndent + "ReturnValue type=" + (this.m_dt == null ? "<null>" : this.m_dt.toString()));
        super.dump(out, sIndent);
    }
}

