/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.component.BaseStorage;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.util.ErrorList;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.StringTable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarStorage
extends BaseStorage {
    private static final String CLASS = "JarStorage";
    protected static final int T_COMPONENT = 0;
    protected static final int T_SIGNATURE = 1;
    protected static final int T_CLASS = 2;
    protected static final int T_JAVA = 3;
    protected static final int T_RES_SIG = 4;
    protected static final int T_RES_BINARY = 5;
    private JarFile m_jar;
    private String m_sRoot;
    private transient boolean m_fDeleteOnClose = false;
    protected transient StringTable m_tblClasses;
    protected transient StringTable m_tblClassPackages;
    protected transient StringTable m_tblResources;
    protected transient StringTable m_tblResourcePackages;

    public JarStorage(String sFile, String sRoot) {
        this(new File(sFile), sRoot);
    }

    public JarStorage(File file, String sRoot) {
        JarFile jar;
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("JarStorage:  Invalid file:  " + file.toString());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("JarStorage:  Read access required:  " + file.toString());
        }
        try {
            jar = new JarFile(file.getCanonicalFile());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("JarStorage:  Unable to open jar:  " + file.toString() + " (" + e.getMessage() + ")");
        }
        if (sRoot == null) {
            sRoot = "";
        } else {
            sRoot = sRoot.replace('\\', '/');
            while (sRoot.startsWith("/")) {
                sRoot = sRoot.substring(1);
            }
            if (sRoot.length() > 0) {
                StringTokenizer tokens = new StringTokenizer(sRoot, "!");
                while (tokens.hasMoreTokens()) {
                    JarFile jarInner;
                    String sPath = tokens.nextToken();
                    if (sPath.endsWith("/")) {
                        sRoot = sPath;
                        while (sRoot.startsWith("/")) {
                            sRoot = sRoot.substring(1);
                        }
                        if (!tokens.hasMoreTokens()) continue;
                        try {
                            jar.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new IllegalArgumentException("JarStorage: Illegal path " + sRoot + "!" + tokens.nextToken());
                    }
                    try {
                        jarInner = JarStorage.extractJar(jar, sPath);
                    }
                    catch (IOException e) {
                        throw JarStorage.ensureRuntimeException(e);
                    }
                    finally {
                        try {
                            jar.close();
                        }
                        catch (IOException iOException) {}
                    }
                    jar = jarInner;
                    sRoot = "";
                    this.m_fDeleteOnClose = true;
                }
            }
        }
        this.m_jar = jar;
        this.m_sRoot = sRoot;
    }

    @Override
    public Component loadComponent(String sName, boolean fReadOnly, ErrorList errlist) throws ComponentException {
        return Component.isQualifiedNameLegal(sName) ? null : this.loadSignature(sName);
    }

    @Override
    public void storeComponent(Component cd, ErrorList errlist) throws ComponentException {
        throw new UnsupportedOperationException("Read-only storage: " + String.valueOf(this));
    }

    @Override
    public void removeComponent(String sName) throws ComponentException {
        throw new UnsupportedOperationException("Read-only storage: " + String.valueOf(this));
    }

    @Override
    public Component loadSignature(String sName) throws ComponentException {
        ClassFile clzf = this.loadOriginalClass(sName);
        if (clzf == null) {
            return null;
        }
        String sScript = null;
        try {
            sScript = this.loadJava(sName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Component(clzf, sScript);
    }

    @Override
    public void storeSignature(Component cdJCS) throws ComponentException {
        throw new UnsupportedOperationException("Read-only storage: " + String.valueOf(this));
    }

    @Override
    public ClassFile loadOriginalClass(String sName) throws ComponentException {
        try {
            DataInputStream stream = this.loadFile(sName.replace('.', '/') + ".class");
            return stream == null ? null : new ClassFile(stream);
        }
        catch (IOException e) {
            throw new ComponentException(e.toString());
        }
    }

    @Override
    public ClassFile loadClass(String sName) throws ComponentException {
        return null;
    }

    @Override
    public void storeClass(ClassFile clz, String sListing) throws ComponentException {
        throw new UnsupportedOperationException("Read-only storage: " + String.valueOf(this));
    }

    @Override
    public String loadJava(String sName) throws IOException {
        int of;
        byte[] ab = this.loadFileBytes(sName.replace('.', '/') + ".java");
        if (ab == null && (of = sName.indexOf(36)) != -1) {
            sName = sName.substring(0, of).replace('.', '/');
            ab = this.loadFileBytes(sName + ".java");
        }
        return ab == null ? null : new String(ab);
    }

    @Override
    public byte[] loadOriginalResource(String sName) throws IOException {
        return this.loadFileBytes(sName);
    }

    @Override
    public byte[] loadResourceSignature(String sName) throws IOException {
        return this.loadOriginalResource(sName);
    }

    @Override
    public void storeResourceSignature(String sName, byte[] abData) throws IOException {
        throw new UnsupportedOperationException("Read-only storage: " + String.valueOf(this));
    }

    @Override
    public void removeResourceSignature(String sName) throws IOException {
        throw new UnsupportedOperationException("Read-only storage: " + String.valueOf(this));
    }

    @Override
    public byte[] loadResource(String sName) throws IOException {
        return null;
    }

    @Override
    public void storeResource(String sName, byte[] abData) throws IOException {
        throw new UnsupportedOperationException("Read-only storage: " + String.valueOf(this));
    }

    @Override
    public StringTable getSubComponents(String sComponent, boolean fQualify) {
        return new StringTable();
    }

    @Override
    public StringTable getPackageComponents(String sPackage, boolean fQualify) {
        return new StringTable();
    }

    @Override
    public StringTable getComponentPackages(String sPackage, boolean fQualify, boolean fSubs) {
        return new StringTable();
    }

    @Override
    public StringTable getPackageSignatures(String sPackage, boolean fQualify) {
        this.ensureContents();
        return this.getNamesFromPackage(this.m_tblClasses, sPackage, fQualify, '.');
    }

    @Override
    public StringTable getSignaturePackages(String sPackage, boolean fQualify, boolean fSubs) {
        StringTable tblAll = this.m_tblClassPackages;
        if (tblAll == null) {
            this.ensureContents();
            this.m_tblClassPackages = tblAll = this.ensurePackages(this.m_tblClasses);
        }
        return this.extractPackages(tblAll, sPackage, fQualify, fSubs, '.');
    }

    @Override
    public StringTable getPackageResources(String sPackage, boolean fQualify) {
        this.ensureContents();
        return this.getNamesFromPackage(this.m_tblResources, sPackage, fQualify, '/');
    }

    @Override
    public StringTable getResourcePackages(String sPackage, boolean fQualify, boolean fSubs) {
        StringTable tblAll = this.m_tblResourcePackages;
        if (tblAll == null) {
            this.ensureContents();
            this.m_tblResourcePackages = tblAll = this.ensurePackages(this.m_tblResources);
        }
        return this.extractPackages(tblAll, sPackage, fQualify, fSubs, '/');
    }

    public void close() {
        if (this.m_jar != null) {
            try {
                this.m_jar.close();
                if (this.m_fDeleteOnClose) {
                    new File(this.m_jar.getName()).delete();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.m_jar = null;
            }
        }
    }

    public JarFile getJar() {
        return this.m_jar;
    }

    public String getRoot() {
        return this.m_sRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarFile extractJar(JarFile jar, String sPath) throws IOException {
        InputStream streamIn;
        JarEntry entry = jar.getJarEntry(sPath);
        InputStream inputStream = streamIn = entry == null ? null : jar.getInputStream(entry);
        if (streamIn == null) {
            throw new IOException("JarStorage:  Unable to open contained jar:  " + jar.getName() + "!/" + sPath);
        }
        String sName = sPath.substring(sPath.lastIndexOf(47) + 1);
        int of = sName.lastIndexOf(46);
        String sPrefix = of >= 3 ? sName.substring(0, of) : "tmp";
        String sSuffix = of >= 0 && of < sName.length() - 3 ? sName.substring(of) : ".jar";
        File fileTemp = File.createTempFile(sPrefix, sSuffix, null);
        FileOutputStream streamOut = new FileOutputStream(fileTemp);
        try {
            int cb;
            int cbBlock = 4096;
            byte[] ab = new byte[cbBlock];
            while ((cb = JarStorage.read(streamIn, ab)) > 0) {
                streamOut.write(ab, 0, cb);
            }
        }
        finally {
            streamIn.close();
            streamOut.close();
        }
        return new JarFile(fileTemp);
    }

    protected DataInputStream loadFile(String sName) throws IOException {
        Object sEntry = sName.startsWith("/") ? sName.substring(1) : this.m_sRoot + sName;
        JarEntry entry = this.m_jar.getJarEntry((String)sEntry);
        return entry == null ? null : new DataInputStream(this.m_jar.getInputStream(entry));
    }

    protected byte[] loadFileBytes(String sName) throws IOException {
        long MAX_SIZE = 0x500000L;
        Object sEntry = sName.startsWith("/") ? sName.substring(1) : this.m_sRoot + sName;
        JarEntry entry = this.m_jar.getJarEntry((String)sEntry);
        if (entry == null) {
            return null;
        }
        long lSize = entry.getSize();
        if (lSize > 0x500000L) {
            throw new IOException("JarStorage.loadFileBytes: Entry " + (String)sEntry + " exceeds maximum size");
        }
        InputStream streamRaw = this.m_jar.getInputStream(entry);
        DataInputStream streamData = new DataInputStream(streamRaw);
        byte[] ab = JarStorage.read(streamData);
        if ((long)ab.length != lSize) {
            throw new EOFException("JarStorage.loadFileBytes: Premature EOF: " + (String)sEntry + " expected=" + lSize + " actual=" + ab.length);
        }
        streamRaw.close();
        return ab;
    }

    protected void ensureContents() {
        if (this.m_tblClasses != null) {
            return;
        }
        this.m_tblClasses = new StringTable();
        this.m_tblResources = new StringTable();
        String sPrefix = this.m_sRoot;
        Enumeration<JarEntry> enmr = this.m_jar.entries();
        while (enmr.hasMoreElements()) {
            JarEntry entry = enmr.nextElement();
            String sEntry = entry.getName();
            int iType = this.getEntryType(sEntry);
            if (iType == -1) continue;
            if (sEntry.startsWith(sPrefix)) {
                sEntry = sEntry.substring(sPrefix.length());
            }
            this.addContentEntry(sEntry, iType);
        }
    }

    protected int getEntryType(String sEntry) {
        String sPrefix = this.m_sRoot;
        if (sEntry.startsWith(sPrefix)) {
            if (sEntry.endsWith(".class")) {
                return 2;
            }
            if (!(sEntry.endsWith("/") || sEntry.endsWith("java") || sEntry.equalsIgnoreCase("META-INF/Manifest.mf"))) {
                return 5;
            }
        }
        return -1;
    }

    protected void addContentEntry(String sEntry, int iType) {
        switch (iType) {
            case 2: {
                String sClz = sEntry.substring(0, sEntry.length() - 6);
                this.m_tblClasses.put(sClz, this.getLocator());
                break;
            }
            case 5: {
                this.m_tblResources.put(sEntry, this.getLocator());
            }
        }
    }

    protected StringTable ensurePackages(StringTable tblNames) {
        Object oLocator = this.getLocator();
        StringTable tblPkg = new StringTable();
        String sPrev = "";
        Enumeration enmr = tblNames.keys();
        while (enmr.hasMoreElements()) {
            String sName = (String)enmr.nextElement();
            int of = sName.lastIndexOf(47);
            if (of <= 0 || (sName = sName.substring(0, of)).equals(sPrev)) continue;
            while ((of = sName.lastIndexOf(47, of - 1)) >= 0) {
                tblPkg.put(sName.substring(0, of), oLocator);
            }
            tblPkg.put(sName, oLocator);
            sPrev = sName;
        }
        return tblPkg;
    }

    protected StringTable getNamesFromPackage(StringTable tblAll, String sPackage, boolean fQualify, char chDelim) {
        StringTable tbl = new StringTable();
        String string = sPackage = sPackage == null || sPackage.length() == 0 ? "" : sPackage + "/";
        if (chDelim != '/') {
            sPackage = sPackage.replace(chDelim, '/');
        }
        boolean fPreserveAbsoluteName = false;
        if (sPackage.startsWith("/")) {
            fPreserveAbsoluteName = true;
            sPackage = sPackage.substring(1);
        }
        int cchPackage = sPackage.length();
        String[] asNames = tblAll.stringsStartingWith(sPackage);
        if (asNames.length == 0) {
            return tbl;
        }
        Object oLocator = this.getLocator();
        SimpleEnumerator<String> enmr = new SimpleEnumerator<String>(asNames);
        while (enmr.hasMoreElements()) {
            Object sName = (String)enmr.nextElement();
            if (((String)sName).indexOf(47, cchPackage) >= 0) continue;
            if (!fQualify) {
                sName = ((String)sName).substring(cchPackage);
            } else if (chDelim != '/') {
                sName = ((String)sName).replace('/', chDelim);
            }
            if (fPreserveAbsoluteName) {
                sName = "/" + (String)sName;
            }
            tbl.put((String)sName, oLocator);
        }
        return tbl;
    }

    protected StringTable extractPackages(StringTable tblAll, String sPackage, boolean fQualify, boolean fSubs, char chDelim) {
        if (fSubs) {
            fQualify = true;
        }
        StringTable tblSub = new StringTable();
        String string = sPackage = sPackage == null || sPackage.length() == 0 ? "" : sPackage + "/";
        if (chDelim != '/') {
            sPackage = sPackage.replace(chDelim, '/');
        }
        int cchPackage = sPackage.length();
        String[] asNames = tblAll.stringsStartingWith(sPackage);
        if (asNames.length == 0) {
            return tblSub;
        }
        Object oLocator = this.getLocator();
        SimpleEnumerator<String> enmr = new SimpleEnumerator<String>(asNames);
        while (enmr.hasMoreElements()) {
            String sName = (String)enmr.nextElement();
            int of = sName.indexOf(47, cchPackage);
            if (of >= 0) continue;
            if (!fQualify) {
                sName = sName.substring(cchPackage);
            } else if (chDelim != '/') {
                sName = sName.replace('/', chDelim);
            }
            tblSub.put(sName, oLocator);
            if (!fSubs) continue;
            tblSub.addAll(this.extractPackages(tblAll, sName, true, true, chDelim));
        }
        return tblSub;
    }

    public String toString() {
        return "JarStorage(" + this.m_jar.getName() + "!/" + this.m_sRoot + ")";
    }
}

