/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.component.Behavior;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Constants;
import com.tangosol.dev.component.DataType;
import com.tangosol.dev.component.Interface;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.Property;
import com.tangosol.dev.component.Trait;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ChainedEnumerator;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ErrorList;
import com.tangosol.util.IllegalStringException;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.StringMap;
import com.tangosol.util.StringTable;
import com.tangosol.util.WrapperException;
import java.beans.PropertyVetoException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Integration
extends Trait
implements Constants {
    public static final String ATTR_INTEGRATION_SIGNATURE = "IntegrationSignature";
    public static final String ATTR_INTEGRATION_MODEL = "IntegrationModel";
    public static final String ATTR_INTEGRATION_METHOD = "IntegrationMethod";
    public static final String ATTR_INTEGRATION_FIELD = "IntegrationField";
    private static final String CLASS = "Integration";
    protected static final String DESCRIPTOR = "Integration";
    private static final String NULL_STRING = "<null>";
    private static final String EQUAL_STRING = "<same>";
    private String m_sPrevSignature;
    private String m_sSignature;
    private String m_sPrevModel;
    private String m_sModel;
    private String m_sPrevMisc;
    private String m_sMisc;
    private StringMap m_mapPrevMethod;
    private StringMap m_mapMethod;
    private StringMap m_mapPrevField;
    private StringMap m_mapField;
    private Component m_jcs;
    private StringTable m_tblImplements;
    private StringTable m_tblDispatches;
    private StringTable m_tblBehaviors;
    private StringTable m_tblProperties;

    public Integration(Component parent, String sSignature) {
        super((Trait)parent, 1);
        if (sSignature == null || sSignature.length() == 0) {
            sSignature = "";
        }
        this.m_sPrevSignature = "";
        this.m_sSignature = sSignature;
        this.m_sPrevModel = "";
        this.m_sModel = "";
        this.m_sPrevMisc = "";
        this.m_sMisc = "";
        this.m_mapPrevMethod = new StringMap();
        this.m_mapMethod = new StringMap();
        this.m_mapPrevField = new StringMap();
        this.m_mapField = new StringMap();
        this.m_jcs = null;
    }

    public Integration(Component parent, Integration that) {
        super((Trait)parent, that);
        this.m_sPrevSignature = that.m_sPrevSignature;
        this.m_sSignature = that.m_sSignature;
        this.m_sPrevModel = that.m_sPrevModel;
        this.m_sModel = that.m_sModel;
        this.m_sPrevMisc = that.m_sPrevMisc;
        this.m_sMisc = that.m_sMisc;
        this.m_mapPrevMethod = that.m_mapPrevMethod;
        this.m_mapMethod = (StringMap)that.m_mapMethod.clone();
        this.m_mapPrevField = that.m_mapPrevField;
        this.m_mapField = (StringMap)that.m_mapField.clone();
        this.m_jcs = that.m_jcs;
    }

    protected Integration(Component cd, DataInput stream, int nVersion) throws IOException {
        super((Trait)cd, stream, nVersion);
        this.m_sSignature = stream.readUTF();
        if (this.m_sSignature.length() == 0) {
            this.m_sSignature = "";
        }
        this.m_sModel = stream.readUTF();
        if (this.m_sModel.length() == 0) {
            this.m_sModel = "";
        }
        this.m_sMisc = stream.readUTF();
        if (this.m_sMisc.length() == 0) {
            this.m_sMisc = "";
        }
        this.m_sPrevSignature = "";
        this.m_sPrevModel = "";
        this.m_sPrevMisc = "";
        this.m_mapPrevMethod = new StringMap();
        this.m_mapMethod = new StringMap(stream);
        this.m_mapPrevField = new StringMap();
        this.m_mapField = new StringMap(stream);
        this.m_jcs = null;
    }

    protected Integration(Trait parent, XmlElement xml, int nVersion) throws IOException {
        super(parent, xml, nVersion);
        this.m_sSignature = Integration.readString(xml.getElement("signature"));
        this.m_sModel = Integration.readString(xml.getElement("model"));
        this.m_sMisc = Integration.readString(xml.getElement("misc"));
        this.m_sPrevSignature = "";
        this.m_sPrevModel = "";
        this.m_sPrevMisc = "";
        this.m_mapPrevMethod = new StringMap();
        this.m_mapMethod = Integration.readStringMap(xml, "methods", "method");
        this.m_mapPrevField = new StringMap();
        this.m_mapField = Integration.readStringMap(xml, "fields", "field");
        this.m_jcs = null;
    }

    protected Integration(Integration base, Component parent, int nMode) {
        super((Trait)base, parent, nMode);
        this.m_sPrevSignature = "";
        this.m_sSignature = "";
        this.m_sPrevModel = "";
        this.m_sModel = "";
        this.m_sPrevMisc = "";
        this.m_sMisc = "";
        this.m_mapPrevMethod = new StringMap();
        this.m_mapMethod = new StringMap();
        this.m_mapPrevField = new StringMap();
        this.m_mapField = new StringMap();
        this.m_jcs = null;
    }

    @Override
    public synchronized void save(DataOutput stream) throws IOException {
        super.save(stream);
        stream.writeUTF(this.m_sSignature);
        stream.writeUTF(this.m_sModel);
        stream.writeUTF(this.m_sMisc);
        this.m_mapMethod.save(stream);
        this.m_mapField.save(stream);
    }

    @Override
    protected synchronized void save(XmlElement xml) throws IOException {
        xml.addElement("signature").setString(this.m_sSignature);
        xml.addElement("model").setString(this.m_sModel);
        xml.addElement("misc").setString(this.m_sMisc);
        super.save(xml);
        Integration.saveStringMap(xml, "methods", "method", this.m_mapMethod);
        Integration.saveStringMap(xml, "fields", "field", this.m_mapField);
    }

    @Override
    protected Trait getBlankDerivedTrait(Trait parent, int nMode) {
        return new Integration(this, (Component)parent, nMode);
    }

    protected Integration resolve(Integration traitDelta, Component parent, StringTable tblBehavior, StringTable tblProperty, StringTable tblDeferBehavior, StringTable tblDeferProperty, Loader loader, ErrorList errlist) throws ComponentException {
        boolean fAddable;
        String sPrimary;
        Integration base = this;
        Integration delta = (Integration)this.resolveDelta(traitDelta, loader, errlist);
        Integration derived = (Integration)super.resolve(delta, parent, loader, errlist);
        String signatureBase = base.m_sSignature;
        String signatureDelta = delta.m_sSignature;
        String signatureDerived = signatureBase;
        if (signatureDelta != "" && !signatureDelta.equals(signatureBase)) {
            if (derived.isSignatureLegal(signatureDelta)) {
                signatureDerived = signatureDelta;
            } else {
                Integration.out("TODO: log error -- Illegal signature " + signatureDelta);
            }
        }
        derived.m_sPrevSignature = signatureBase;
        derived.m_sSignature = signatureDerived;
        if (signatureDerived == "") {
            return derived;
        }
        String modelBase = base.m_sModel;
        String miscBase = base.m_sMisc;
        String modelDelta = delta.m_sModel;
        String miscDelta = delta.m_sMisc;
        String modelDerived = modelBase;
        String miscDerived = miscBase;
        if (!(modelDelta == "" && miscDelta == "" || modelDelta.equals(modelBase) && miscDelta.equals(miscBase))) {
            if (this.isModelLegal(modelDelta, miscDelta)) {
                modelDerived = modelDelta;
                miscDerived = miscDelta;
            } else {
                Integration.out("TODO: log error -- Illegal model " + modelDelta + " " + miscDelta);
            }
        }
        derived.m_sPrevModel = modelBase;
        derived.m_sModel = modelDerived;
        derived.m_sPrevMisc = miscBase;
        derived.m_sMisc = miscDerived;
        StringMap mapPrev = (StringMap)base.m_mapPrevMethod.clone();
        StringMap mapNew = base.m_mapMethod;
        Enumeration enmr = mapNew.primaryStrings();
        while (enmr.hasMoreElements()) {
            sPrimary = (String)enmr.nextElement();
            try {
                mapPrev.put(sPrimary, mapNew.get(sPrimary));
            }
            catch (IllegalStringException e) {
                throw new WrapperException(e);
            }
        }
        derived.m_mapPrevMethod = mapPrev;
        derived.m_mapMethod = new StringMap();
        mapPrev = (StringMap)base.m_mapPrevField.clone();
        mapNew = base.m_mapField;
        enmr = mapNew.primaryStrings();
        while (enmr.hasMoreElements()) {
            sPrimary = (String)enmr.nextElement();
            try {
                mapPrev.put(sPrimary, mapNew.get(sPrimary));
            }
            catch (IllegalStringException e) {
                throw new WrapperException(e);
            }
        }
        derived.m_mapPrevField = mapPrev;
        derived.m_mapField = new StringMap();
        String sDerivedName = parent.getQualifiedName();
        Component jcsDerived = loader.loadSignature(signatureDerived);
        if (jcsDerived == null) {
            this.logError("RES-115", 3, new Object[]{signatureDerived, ATTR_INTEGRATION_SIGNATURE, sDerivedName}, errlist);
            return derived;
        }
        Enumeration enmr2 = delta.getMethods();
        while (enmr2.hasMoreElements()) {
            fAddable = true;
            String sMethod = (String)enmr2.nextElement();
            Behavior method = null;
            method = jcsDerived.getBehavior(sMethod);
            if (method == null) {
                fAddable = false;
                this.logError("IFACE-002", 2, new Object[]{signatureDerived, sDerivedName, sMethod, jcsDerived.getName()}, errlist);
            } else {
                int nAccess = method.getAccess();
                if (nAccess != 48 && nAccess != 32) {
                    fAddable = false;
                    this.logError("IFACE-003", 2, new Object[]{signatureDerived, sDerivedName, sMethod, jcsDerived.getName()}, errlist);
                }
            }
            String sBehavior = delta.getBehavior(sMethod);
            Behavior behavior = parent.getBehavior(sBehavior);
            if (behavior == null) {
                if (parent.isBehaviorReserved(sBehavior)) {
                    fAddable = false;
                    this.logError("IFACE-004", 2, new Object[]{signatureDerived, sDerivedName, sBehavior}, errlist);
                }
            } else if (method != null) {
                int nSeverity;
                boolean fFixable = !behavior.isFromNonManual();
                int n = nSeverity = fFixable ? 1 : 2;
                if (method.isStatic() != behavior.isStatic()) {
                    fAddable = fAddable && fFixable;
                    this.logError("IFACE-005", nSeverity, new Object[]{signatureDerived, sDerivedName, sBehavior, sMethod}, errlist);
                }
                if (method.getReturnValue().getDataType() != behavior.getReturnValue().getDataType()) {
                    fAddable = fAddable && fFixable;
                    this.logError("IFACE-006", nSeverity, new Object[]{signatureDerived, sDerivedName, sBehavior, behavior.getReturnValue().getDataType().toString(), sMethod, method.getReturnValue().getDataType().toString()}, errlist);
                }
                if (!method.getParameterDirections().equals(behavior.getParameterDirections())) {
                    fAddable = fAddable && fFixable;
                    this.logError("IFACE-007", nSeverity, new Object[]{signatureDerived, sDerivedName, sBehavior, sMethod}, errlist);
                }
            }
            if (!fAddable) continue;
            try {
                derived.m_mapMethod.put(sMethod, sBehavior);
            }
            catch (IllegalStringException e) {
                throw new WrapperException(e);
            }
            if (behavior == null && tblDeferBehavior != null && (behavior = (Behavior)tblDeferBehavior.get(sBehavior)) != null) {
                tblDeferBehavior.remove(sBehavior);
                behavior = new Behavior(parent, behavior);
                behavior.setExists(2);
                tblBehavior.put(sBehavior, behavior);
            }
            if (method == null) continue;
            if (behavior == null) {
                String sName = sBehavior.substring(0, sBehavior.indexOf(40));
                behavior = new Behavior(parent, this, sName, method);
                try {
                    parent.addBehavior(behavior, false);
                    continue;
                }
                catch (PropertyVetoException e) {
                    throw new WrapperException(e);
                }
            }
            behavior.setDeclaredByIntegration(this, method);
        }
        enmr2 = delta.getFields();
        while (enmr2.hasMoreElements()) {
            fAddable = true;
            String sField = (String)enmr2.nextElement();
            Property field = jcsDerived.getProperty(sField);
            if (field == null) {
                fAddable = false;
                this.logError("IFACE-008", 2, new Object[]{signatureDerived, sDerivedName, sField, jcsDerived.getName()}, errlist);
            }
            String sProperty = delta.getProperty(sField);
            Property property = parent.getProperty(sProperty);
            if (field != null) {
                if (property == null) {
                    boolean fAccess;
                    DataType dt = field.getDataType();
                    boolean fStatic = field.isStatic();
                    nAccess = field.getAccess();
                    boolean bl = fAccess = nAccess == 48 || nAccess == 32;
                    if (fAccess && field.isJavaConstant()) {
                        if (!Property.isJavaConstantCreatable(parent, dt, sProperty, 0x10000000, fStatic, field.getAccess())) {
                            fAddable = false;
                            this.logError("IFACE-010", 2, new Object[]{signatureDerived, sDerivedName, sProperty, dt.toString()}, errlist);
                        }
                    } else if (fAccess && field.isStandardProperty()) {
                        if (!Property.isPropertyCreatable(parent, dt, sProperty, 0x10000000, fStatic, false)) {
                            fAddable = false;
                            this.logError("IFACE-010", 2, new Object[]{signatureDerived, sDerivedName, sProperty, dt.toString()}, errlist);
                        }
                    } else {
                        fAddable = false;
                        this.logError("IFACE-009", 2, new Object[]{signatureDerived, sDerivedName, sField, jcsDerived.getName()}, errlist);
                    }
                } else {
                    boolean fFixable = !property.isFromNonManual();
                    int nSeverity = fFixable ? 1 : 2;
                    int n = nAccess = field.isJavaConstant() ? field.getAccess() : 0;
                    if (property.getAccess() != nAccess) {
                        fAddable = fAddable && fFixable;
                        this.logError("IFACE-011", 2, new Object[]{signatureDerived, sDerivedName, "Access", sProperty, sField}, errlist);
                    }
                    if (field.isStandardProperty()) {
                        // empty if block
                    }
                    if (property.isStatic() != field.isStatic()) {
                        fAddable = fAddable && fFixable;
                        this.logError("IFACE-011", 2, new Object[]{signatureDerived, sDerivedName, "Static", sProperty, sField}, errlist);
                    }
                    if (property.isFinal() != field.isFinal()) {
                        fAddable = fAddable && fFixable;
                        this.logError("IFACE-011", 2, new Object[]{signatureDerived, sDerivedName, "Final", sProperty, sField}, errlist);
                    }
                    if (property.isPersistent() != field.isPersistent()) {
                        fAddable = fAddable && fFixable;
                        this.logError("IFACE-011", 2, new Object[]{signatureDerived, sDerivedName, "Persistent", sProperty, sField}, errlist);
                    }
                    if (property.getDirection() != field.getDirection()) {
                        fAddable = fAddable && fFixable;
                        this.logError("IFACE-011", 2, new Object[]{signatureDerived, sDerivedName, "Direction", sProperty, sField}, errlist);
                    }
                    if (property.getDataType() != field.getDataType()) {
                        fAddable = fAddable && fFixable;
                        this.logError("IFACE-011", 2, new Object[]{signatureDerived, sDerivedName, "DataType", sProperty, sField}, errlist);
                    }
                    if (property.getIndexed() != 0x10000000) {
                        fAddable = fAddable && fFixable;
                        this.logError("IFACE-011", 2, new Object[]{signatureDerived, sDerivedName, "Indexed", sProperty, sField}, errlist);
                    }
                    if (!property.isNoValue() && !property.isNoDelta()) {
                        fAddable = fAddable && fFixable;
                        this.logError("IFACE-012", 2, new Object[]{signatureDerived, sDerivedName, sProperty}, errlist);
                    }
                }
            }
            if (!fAddable) continue;
            try {
                derived.m_mapField.put(sField, sProperty);
            }
            catch (IllegalStringException e) {
                throw new WrapperException(e);
            }
            if (property == null && tblDeferProperty != null && (property = (Property)tblDeferProperty.get(sProperty)) != null) {
                tblDeferProperty.remove(sProperty);
                property = new Property(parent, property);
                property.setExists(2);
                tblProperty.put(sProperty, property);
            }
            if (field == null) continue;
            if (property == null) {
                DataType dt = field.getDataType();
                boolean fStatic = field.isStatic();
                property = field.isJavaConstant() ? Property.createJavaConstant(parent, dt, sProperty, 0x10000000, fStatic, field.getAccess()) : Property.createProperty(parent, dt, sProperty, 0x10000000, fStatic, false);
                try {
                    parent.addProperty(property, false);
                }
                catch (PropertyVetoException e) {
                    throw new WrapperException(e);
                }
            }
            property.setFromIntegration(this, field);
            if (property.isConstant()) continue;
            if (tblDeferBehavior != null) {
                for (int i = 0; i <= 5; ++i) {
                    String sBehavior;
                    Behavior behavior;
                    if (!property.isAccessorApplicable(i) || property.getAccessor(i) != null || (behavior = (Behavior)tblDeferBehavior.get(sBehavior = property.getAccessorSignature(i))) == null) continue;
                    tblDeferBehavior.remove(sBehavior);
                    behavior = new Behavior(parent, behavior);
                    behavior.setExists(2);
                    tblBehavior.put(sBehavior, behavior);
                }
            }
            property.addAccessors();
        }
        return derived;
    }

    @Override
    protected Trait extract(Trait traitBase, Trait parent, Loader loader, ErrorList errlist) throws ComponentException {
        Integration derived = this;
        Integration base = (Integration)traitBase;
        Integration delta = (Integration)super.extract(base, parent, loader, errlist);
        if (delta.getMode() != 2) {
            throw new IllegalArgumentException("Integration.extract:  Only Integration derivations can be extracted!");
        }
        String signatureBase = base.m_sSignature;
        String signatureDerived = derived.m_sSignature;
        String signatureDelta = "";
        if (!signatureDerived.equals(signatureBase)) {
            signatureDelta = signatureDerived;
        }
        delta.m_sSignature = signatureDelta;
        String modelBase = base.m_sModel;
        String modelDerived = derived.m_sModel;
        String modelDelta = "";
        String miscBase = base.m_sMisc;
        String miscDerived = derived.m_sMisc;
        String miscDelta = "";
        if (!modelDerived.equals(modelBase) || !miscDerived.equals(miscBase)) {
            modelDelta = modelDerived;
            miscDelta = miscDerived;
        }
        delta.m_sModel = modelDelta;
        delta.m_sMisc = miscDelta;
        this.extractMap(base.m_mapPrevMethod, base.m_mapMethod, derived.m_mapPrevMethod, derived.m_mapMethod, delta.m_mapMethod, errlist);
        this.extractMap(base.m_mapPrevField, base.m_mapField, derived.m_mapPrevField, derived.m_mapField, delta.m_mapField, errlist);
        delta.m_jcs = derived.m_jcs;
        return delta;
    }

    private void extractMap(StringMap mapPrevBase, StringMap mapBase, StringMap mapPrevDerived, StringMap mapDerived, StringMap mapDelta, ErrorList errlist) {
        String sName;
        Enumeration enmr = mapPrevDerived.primaryStrings();
        while (enmr.hasMoreElements()) {
            sName = (String)enmr.nextElement();
            if (mapPrevBase.contains(sName) || mapBase.contains(sName)) continue;
            try {
                mapDelta.put(sName, mapPrevDerived.get(sName));
            }
            catch (IllegalStringException e) {
                throw new WrapperException(e);
            }
        }
        enmr = mapDerived.primaryStrings();
        while (enmr.hasMoreElements()) {
            sName = (String)enmr.nextElement();
            if (mapPrevBase.contains(sName) || mapBase.contains(sName)) continue;
            try {
                mapDelta.put(sName, mapDerived.get(sName));
            }
            catch (IllegalStringException e) {
                throw new WrapperException(e);
            }
        }
    }

    public synchronized void finalizeExtract() throws ComponentException {
        super.finalizeExtract(null, null);
        try {
            Enumeration enmrMethods = this.m_mapMethod.primaryStrings();
            while (enmrMethods.hasMoreElements()) {
                String method = (String)enmrMethods.nextElement();
                String behavior = this.m_mapMethod.get(method);
                if (behavior != null) continue;
                this.m_mapMethod.remove(method);
            }
            Enumeration enmrFields = this.m_mapField.primaryStrings();
            while (enmrFields.hasMoreElements()) {
                String field = (String)enmrFields.nextElement();
                String property = this.m_mapField.get(field);
                if (property != null) continue;
                this.m_mapField.remove(field);
            }
        }
        catch (IllegalStringException e) {
            throw new WrapperException(e);
        }
    }

    public Component getComponent() {
        return (Component)this.getParentTrait();
    }

    public boolean isNewIntegration() {
        return !this.m_sPrevSignature.equals(this.m_sSignature) || !this.m_sPrevModel.equals(this.m_sModel) || !this.m_sPrevMisc.equals(this.m_sMisc) || !this.m_mapMethod.isEmpty() || !this.m_mapField.isEmpty();
    }

    @Override
    public boolean isModifiable() {
        return super.isModifiable() && ((Component)this.getParentTrait()).isIntegrationSettable() && this.m_jcs != null;
    }

    @Override
    protected String getUniqueName() {
        return this.getSignature();
    }

    @Override
    protected String getUniqueDescription() {
        return "Integration " + this.getUniqueName();
    }

    @Override
    protected boolean isDiscardable() {
        int nMode = this.getMode();
        if ((nMode == 2 || nMode == 3) && this.isNewIntegration()) {
            return false;
        }
        return super.isDiscardable();
    }

    public String getPreviousSignature() {
        return this.m_sPrevSignature;
    }

    public String getSignature() {
        return this.m_sSignature;
    }

    public boolean isSignatureSettable() {
        return super.isModifiable();
    }

    public boolean isSignatureLegal(String sName) {
        return ClassHelper.isQualifiedNameLegal(sName);
    }

    public void setSignature(String sSignature) throws PropertyVetoException {
        this.setSignature(sSignature, true);
    }

    protected synchronized void setSignature(String sSignature, boolean fVetoable) throws PropertyVetoException {
        String sPrev;
        if (sSignature == null || sSignature.length() == 0) {
            sSignature = "";
        }
        if (sSignature.equals(sPrev = this.m_sSignature)) {
            return;
        }
        if (fVetoable) {
            if (!this.isSignatureSettable()) {
                this.readOnlyAttribute(ATTR_INTEGRATION_SIGNATURE, sPrev, sSignature);
            }
            if (!this.isSignatureLegal(sSignature)) {
                this.illegalAttributeValue(ATTR_INTEGRATION_SIGNATURE, sPrev, sSignature);
            }
            this.fireVetoableChange(ATTR_INTEGRATION_SIGNATURE, sPrev, sSignature);
        }
        this.m_sSignature = sSignature;
        this.m_sModel = this.m_sPrevModel;
        this.m_sMisc = this.m_sPrevMisc;
        this.m_mapMethod = new StringMap();
        this.m_mapField = new StringMap();
        this.clearJcs();
        this.firePropertyChange(ATTR_INTEGRATION_SIGNATURE, sPrev, sSignature);
    }

    public String getModel() {
        return this.m_sModel;
    }

    public String getMisc() {
        return this.m_sMisc;
    }

    public boolean isModelSettable() {
        return this.isModifiable();
    }

    public boolean isModelLegal(String sModel, String sMisc) {
        if (sModel == null || sModel.length() == 0) {
            sModel = "";
        }
        if (sMisc == null || sMisc.length() == 0) {
            sMisc = "";
        }
        if (sModel == "") {
            return sMisc == "";
        }
        return ClassHelper.isPartialNameLegal(sModel);
    }

    public void setModel(String sModel, String sMisc) throws PropertyVetoException {
        this.setModel(sModel, sMisc, true);
    }

    protected synchronized void setModel(String sModel, String sMisc, boolean fVetoable) throws PropertyVetoException {
        String[] asPrev;
        String[] asNew;
        if (sModel == null || sModel.length() == 0) {
            sModel = "";
        }
        if (sMisc == null || sMisc.length() == 0) {
            sMisc = "";
        }
        if ((asNew = new String[]{sModel, sMisc})[0].equals((asPrev = new String[]{this.m_sModel, this.m_sMisc})[0]) && asNew[1].equals(asPrev[1])) {
            return;
        }
        if (fVetoable) {
            if (!this.isModelSettable()) {
                this.readOnlyAttribute(ATTR_INTEGRATION_MODEL, asPrev, asNew);
            }
            if (!this.isModelLegal(asNew[0], asNew[1])) {
                this.illegalAttributeValue(ATTR_INTEGRATION_MODEL, asPrev, asNew);
            }
            this.fireVetoableChange(ATTR_INTEGRATION_MODEL, asPrev, asNew);
        }
        this.m_sModel = asNew[0];
        this.m_sMisc = asNew[1];
        this.firePropertyChange(ATTR_INTEGRATION_MODEL, asPrev, asNew);
    }

    public Enumeration getMethods() {
        return new ChainedEnumerator(this.m_mapPrevMethod.primaryStrings(), this.m_mapMethod.primaryStrings());
    }

    public Enumeration getBehaviors() {
        return new ChainedEnumerator(this.m_mapPrevMethod.secondaryStrings(), this.m_mapMethod.secondaryStrings());
    }

    public String getBehavior(String sMethodSignature) {
        String sBehavior = this.m_mapPrevMethod.get(sMethodSignature);
        if (sBehavior == null) {
            sBehavior = this.m_mapMethod.get(sMethodSignature);
        }
        return sBehavior;
    }

    public String getBehavior(Behavior method) {
        return this.getBehavior(method.getSignature());
    }

    public String getSuggestedBehavior(Behavior method) {
        String sBehavior = this.getBehavior(method);
        if (sBehavior != null) {
            return sBehavior;
        }
        Property field = this.getFieldFromAccessor(method);
        if (field == null) {
            return null;
        }
        String sProperty = this.getSuggestedProperty(field);
        if (sProperty == null) {
            return null;
        }
        return sBehavior.substring(0, (sBehavior = method.getSignature()).charAt(0) == 'i' ? 2 : 3) + sProperty + sBehavior.substring(sBehavior.indexOf(40));
    }

    public boolean containsMethod(String sMethodSignature) {
        boolean fContains = this.m_mapPrevMethod.contains(sMethodSignature);
        if (!fContains) {
            fContains = this.m_mapMethod.contains(sMethodSignature);
        }
        return fContains;
    }

    public String getMethod(String sBehaviorSignature) {
        String sMethod = this.m_mapPrevMethod.getPrimary(sBehaviorSignature);
        if (sMethod == null) {
            sMethod = this.m_mapMethod.getPrimary(sBehaviorSignature);
        }
        return sMethod;
    }

    public boolean isMethodInherited(Behavior method) {
        return method.getExists() != 2;
    }

    public boolean isMethodBehaviorInherited(Behavior method) {
        return this.m_mapPrevMethod.contains(method.getSignature());
    }

    public boolean isMethodSettable(Behavior method) {
        if (!this.isModifiable() || method == null) {
            return false;
        }
        String sMethodSignature = method.getSignature();
        return !this.m_mapPrevMethod.contains(sMethodSignature) && this.m_jcs.getBehavior(sMethodSignature) == method;
    }

    public boolean isMethodRenamable(Behavior method) {
        String sProperty;
        Property field = this.getFieldFromAccessor(method);
        return field == null || (sProperty = this.getProperty(field)) == null || !this.isPropertyFromIntegration(sProperty);
    }

    private Property getFieldFromAccessor(Behavior method) {
        String[] asProperties = this.m_tblProperties.strings();
        for (int i = 0; i < asProperties.length; ++i) {
            Property field = (Property)this.m_tblProperties.get(asProperties[i]);
            if (field == null) continue;
            Behavior[] accessors = field.getAccessors();
            for (int ii = 0; ii < accessors.length; ++ii) {
                if (accessors[ii] != method) continue;
                return field;
            }
        }
        return null;
    }

    public boolean isBehaviorLegal(Behavior method, String sBehaviorSignature) {
        if (method == null) {
            return false;
        }
        String sMethodSignature = method.getSignature();
        Component parent = (Component)this.getParentTrait();
        if (this.m_jcs == null) {
            return false;
        }
        if (this.m_jcs.getBehavior(sMethodSignature) != method) {
            return false;
        }
        int nAccess = method.getAccess();
        if (nAccess != 48 && nAccess != 32) {
            return false;
        }
        String sMethodParms = sMethodSignature.substring(sMethodSignature.indexOf(40));
        if (sBehaviorSignature == null || sBehaviorSignature.length() == 0) {
            return true;
        }
        String sPrevBehaviorSignature = this.getBehavior(sMethodSignature);
        if (sPrevBehaviorSignature != null && sPrevBehaviorSignature.length() == 0) {
            sPrevBehaviorSignature = null;
        }
        if (sBehaviorSignature.equals(sPrevBehaviorSignature)) {
            return true;
        }
        int of = sBehaviorSignature.indexOf(40);
        if (of < 0) {
            return false;
        }
        String sBehaviorName = sBehaviorSignature.substring(0, of);
        String sBehaviorParms = sBehaviorSignature.substring(of);
        if (!ClassHelper.isSimpleNameLegal(sBehaviorName) || !sBehaviorParms.equals(sMethodParms)) {
            return false;
        }
        String sBehaviorMethod = this.getMethod(sBehaviorSignature);
        if (sBehaviorMethod != null) {
            return false;
        }
        Behavior behavior = null;
        if (sPrevBehaviorSignature != null) {
            behavior = parent.getBehavior(sPrevBehaviorSignature);
        }
        if (behavior != null) {
            return behavior.isNameLegal(sBehaviorName);
        }
        behavior = parent.getBehavior(sBehaviorSignature);
        if (behavior == null) {
            return !parent.isBehaviorReserved(sBehaviorSignature);
        }
        if (!behavior.isFromNonManual()) {
            return true;
        }
        if (method.isStatic() != behavior.isStatic()) {
            return false;
        }
        if (method.getReturnValue().getDataType() != behavior.getReturnValue().getDataType()) {
            return false;
        }
        return method.getParameterDirections().equals(behavior.getParameterDirections());
    }

    public void setBehavior(Behavior method, String sBehaviorSignature) throws PropertyVetoException {
        this.setBehavior(method, sBehaviorSignature, true);
    }

    protected synchronized void setBehavior(Behavior method, String sBehaviorSignature, boolean fVetoable) throws PropertyVetoException {
        String sPrevBehaviorSignature;
        if (method == null) {
            return;
        }
        String sMethodSignature = method.getSignature();
        if (sBehaviorSignature != null && sBehaviorSignature.length() == 0) {
            sBehaviorSignature = null;
        }
        if ((sPrevBehaviorSignature = this.getBehavior(sMethodSignature)) != null && sPrevBehaviorSignature.length() == 0) {
            sPrevBehaviorSignature = null;
        }
        if (sPrevBehaviorSignature == null ? sBehaviorSignature == null : sPrevBehaviorSignature.equals(sBehaviorSignature)) {
            return;
        }
        Object[] asPrev = new Object[]{method, sPrevBehaviorSignature};
        if (fVetoable) {
            if (!this.isMethodSettable(method)) {
                this.readOnlyAttribute(ATTR_INTEGRATION_METHOD, asPrev, sBehaviorSignature);
            }
            if (!this.isBehaviorLegal(method, sBehaviorSignature)) {
                this.illegalAttributeValue(ATTR_INTEGRATION_METHOD, asPrev, sBehaviorSignature);
            }
            this.fireVetoableChange(ATTR_INTEGRATION_METHOD, asPrev, sBehaviorSignature);
        }
        boolean fLastAccessor = false;
        Property field = this.getFieldFromAccessor(method);
        if (sBehaviorSignature == null && field != null) {
            fLastAccessor = true;
            Behavior[] accessors = field.getAccessors();
            for (int i = 0; i < accessors.length; ++i) {
                Behavior accessor = accessors[i];
                if (accessor == null || accessor == method || this.getBehavior(accessor) == null) continue;
                fLastAccessor = false;
            }
        }
        try {
            if (sBehaviorSignature == null) {
                if (fLastAccessor) {
                    this.setProperty(field, null, false);
                    if (this.m_mapMethod.contains(sMethodSignature)) {
                        this.m_mapMethod.remove(sMethodSignature);
                    }
                } else {
                    this.m_mapMethod.remove(sMethodSignature);
                }
            } else {
                this.m_mapMethod.put(sMethodSignature, sBehaviorSignature);
            }
        }
        catch (IllegalStringException e) {
            throw new WrapperException(e);
        }
        Component parent = (Component)this.getParentTrait();
        Behavior behavior = null;
        if (sPrevBehaviorSignature != null) {
            behavior = parent.getBehavior(sPrevBehaviorSignature);
        }
        if (sBehaviorSignature == null) {
            if (behavior != null && behavior.isFromIntegration()) {
                behavior.removeOriginTrait(this);
                if (behavior.isDiscardable()) {
                    parent.removeBehavior(behavior, false);
                }
            }
        } else {
            String sBehaviorName = sBehaviorSignature.substring(0, sBehaviorSignature.indexOf(40));
            if (behavior == null) {
                behavior = parent.getBehavior(sBehaviorSignature);
                if (behavior == null) {
                    behavior = new Behavior(parent, this, sBehaviorName, method);
                    parent.addBehavior(behavior, false);
                } else {
                    behavior.setDeclaredByIntegration(this, method);
                }
            } else {
                behavior.setName(sBehaviorName, false);
            }
        }
        this.firePropertyChange(ATTR_INTEGRATION_METHOD, asPrev, sBehaviorSignature);
    }

    public Enumeration getFields() {
        return new ChainedEnumerator(this.m_mapPrevField.primaryStrings(), this.m_mapField.primaryStrings());
    }

    public Enumeration getProperties() {
        return new ChainedEnumerator(this.m_mapPrevField.secondaryStrings(), this.m_mapField.secondaryStrings());
    }

    public String getProperty(String sField) {
        String sProperty = this.m_mapPrevField.get(sField);
        if (sProperty == null) {
            sProperty = this.m_mapField.get(sField);
        }
        return sProperty;
    }

    public String getProperty(Property field) {
        String sFieldSignature = this.getFieldSignature(field);
        Property property = (Property)this.m_tblProperties.get(sFieldSignature);
        if (property == null) {
            return this.getProperty(field.getName());
        }
        String sProperty = this.getSuggestedProperty(field);
        if (sProperty != null && !this.isPropertyFromIntegration(sProperty)) {
            sProperty = null;
        }
        return sProperty;
    }

    public String getSuggestedProperty(Property field) {
        String sFieldSignature = this.getFieldSignature(field);
        Property property = (Property)this.m_tblProperties.get(sFieldSignature);
        if (property == null) {
            return this.getProperty(field.getName());
        }
        String sProperty = null;
        Behavior[] accessors = field.getAccessors();
        for (int i = 0; i < accessors.length; ++i) {
            String sBehavior;
            Behavior accessor = accessors[i];
            if (accessor == null || (sBehavior = this.getBehavior(accessor.getSignature())) == null) continue;
            sBehavior = sBehavior.substring(sBehavior.charAt(0) == 'i' ? 2 : 3, sBehavior.indexOf(40));
            if (sProperty == null) {
                sProperty = sBehavior;
                continue;
            }
            if (sBehavior.equals(sProperty)) continue;
            return field.getName();
        }
        return sProperty;
    }

    public boolean containsField(String sField) {
        boolean fContains = this.m_mapPrevField.contains(sField);
        if (!fContains) {
            fContains = this.m_mapField.contains(sField);
        }
        return fContains;
    }

    public String getField(String sProperty) {
        String sField = this.m_mapPrevField.getPrimary(sProperty);
        if (sField == null) {
            sField = this.m_mapField.getPrimary(sProperty);
        }
        return sField;
    }

    public boolean isFieldInherited(Property field) {
        if (field.getExists() != 2) {
            return true;
        }
        Behavior[] accessors = field.getAccessors();
        for (int i = 0; i < accessors.length; ++i) {
            Behavior accessor = accessors[i];
            if (accessor == null || accessor.getExists() == 2) continue;
            return true;
        }
        return false;
    }

    public boolean isFieldPropertyInherited(Property field) {
        Property property = (Property)this.m_tblProperties.get(this.getFieldSignature(field));
        if (property == null) {
            return this.m_mapPrevField.contains(field.getName());
        }
        Behavior[] accessors = property.getAccessors();
        for (int i = 0; i < accessors.length; ++i) {
            Behavior accessor = accessors[i];
            if (accessor == null || !this.m_mapPrevMethod.contains(accessor.getSignature())) continue;
            return true;
        }
        return false;
    }

    public boolean isFieldSettable(Property field) {
        if (!this.isModifiable() || field == null) {
            return false;
        }
        String sFieldSignature = this.getFieldSignature(field);
        if (!this.m_tblProperties.contains(sFieldSignature)) {
            return false;
        }
        if (this.isFieldPropertyInherited(field)) {
            return false;
        }
        if (this.m_tblProperties.get(sFieldSignature) == null) {
            return this.m_jcs.getProperty(field.getName()) == field;
        }
        String sProperty = this.getProperty(field);
        if (sProperty == null) {
            Behavior[] accessors = field.getAccessors();
            for (int i = 0; i < accessors.length; ++i) {
                Behavior accessor = accessors[i];
                if (accessor == null) continue;
                if (!this.isMethodSettable(accessor)) {
                    return false;
                }
                String sBehavior = this.getBehavior(accessor.getSignature());
                if (sBehavior == null) continue;
                sBehavior = sBehavior.substring(sBehavior.charAt(0) == 'i' ? 2 : 3, sBehavior.indexOf(40));
                if (sProperty == null) {
                    sProperty = sBehavior;
                    continue;
                }
                if (sBehavior.equals(sProperty)) continue;
                return false;
            }
        } else if (!this.isPropertyFromIntegration(sProperty)) {
            return false;
        }
        return true;
    }

    public boolean isFieldRenamable(Property field) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPropertyLegal(Property field, String sProperty) {
        if (field == null) {
            return false;
        }
        Component parent = (Component)this.getParentTrait();
        if (this.m_jcs == null) {
            return false;
        }
        String sFieldSignature = this.getFieldSignature(field);
        if (!this.m_tblProperties.contains(sFieldSignature)) {
            return false;
        }
        if (sProperty == null || sProperty.length() == 0) {
            Behavior[] accessors = field.getAccessors();
            for (int i = 0; i < accessors.length; ++i) {
                Behavior accessor = accessors[i];
                if (accessor == null || this.isBehaviorLegal(accessors[i], null)) continue;
                return false;
            }
            return true;
        }
        String sPrevProperty = this.getProperty(field);
        if (sPrevProperty != null && sPrevProperty.length() == 0) {
            sPrevProperty = null;
        }
        if (sProperty.equals(sPrevProperty)) {
            return true;
        }
        if (!ClassHelper.isSimpleNameLegal(sProperty)) {
            return false;
        }
        String sPropertyField = this.getField(sProperty);
        if (sPropertyField != null) {
            return false;
        }
        Property property = null;
        if (sPrevProperty != null) {
            property = parent.getProperty(sPrevProperty);
        }
        if (property != null) {
            if (property.isNameLegal(sProperty)) return true;
            return false;
        }
        property = parent.getProperty(sProperty);
        if (property == null) {
            DataType dt = field.getDataType();
            boolean fStatic = field.isStatic();
            int nIndexed = field.getIndexed();
            if (field.isJavaConstant()) {
                int nAccess = field.getAccess();
                if (nAccess != 48 && nAccess != 32) {
                    return false;
                }
                if (!Property.isJavaConstantCreatable(parent, dt, sProperty, nIndexed, fStatic, nAccess)) {
                    return false;
                }
            } else if (field.isCalculatedProperty()) {
                if (!Property.isCalculatedPropertyCreatable(parent, dt, sProperty, nIndexed, fStatic)) {
                    return false;
                }
            } else if (field.isFunctionalProperty()) {
                if (!Property.isFunctionalPropertyCreatable(parent, dt, sProperty, nIndexed, fStatic)) {
                    return false;
                }
            } else {
                if (!field.isStandardProperty()) return false;
                if (!Property.isPropertyCreatable(parent, dt, sProperty, nIndexed, fStatic, false)) {
                    return false;
                }
            }
        } else if (property.isFromNonManual()) {
            int nAccess;
            int n = nAccess = field.isJavaConstant() ? field.getAccess() : 0;
            if (property.getAccess() != nAccess) {
                return false;
            }
            if (property.isStatic() != field.isStatic()) {
                return false;
            }
            if (property.isFinal() != field.isFinal()) {
                return false;
            }
            if (property.isPersistent() != field.isPersistent()) {
                return false;
            }
            if (property.getDirection() != field.getDirection()) {
                return false;
            }
            if (property.getDataType() != field.getDataType()) {
                return false;
            }
            if (property.getIndexed() != field.getIndexed()) {
                return false;
            }
            if (!property.isNoValue() && !property.isNoDelta()) {
                return false;
            }
        }
        Behavior[] accessors = field.getAccessors();
        String[] behaviors = this.getAccessorsBehaviors(accessors, sProperty, field.isBooleanGet());
        for (int i = 0; i < behaviors.length; ++i) {
            String behavior = behaviors[i];
            if (behavior == null || this.isBehaviorLegal(accessors[i], behavior)) continue;
            return false;
        }
        return true;
    }

    public void setProperty(Property field, String sProperty) throws PropertyVetoException {
        this.setProperty(field, sProperty, true);
    }

    protected synchronized void setProperty(Property field, String sProperty, boolean fVetoable) throws PropertyVetoException {
        String sPrevProperty;
        if (sProperty != null && sProperty.length() == 0) {
            sProperty = null;
        }
        if ((sPrevProperty = this.getProperty(field)) != null && sPrevProperty.length() == 0) {
            sPrevProperty = null;
        }
        if (sPrevProperty == null ? sProperty == null : sPrevProperty.equals(sProperty)) {
            return;
        }
        Object[] asPrev = new Object[]{field, sPrevProperty};
        if (fVetoable) {
            if (!this.isFieldSettable(field)) {
                this.readOnlyAttribute(ATTR_INTEGRATION_FIELD, asPrev, sProperty);
            }
            if (!this.isPropertyLegal(field, sProperty)) {
                this.illegalAttributeValue(ATTR_INTEGRATION_FIELD, asPrev, sProperty);
            }
            this.fireVetoableChange(ATTR_INTEGRATION_FIELD, asPrev, sProperty);
        }
        try {
            if (this.m_tblProperties.get(this.getFieldSignature(field)) == null) {
                if (sProperty == null) {
                    this.m_mapField.remove(field.getName());
                } else {
                    this.m_mapField.put(field.getName(), sProperty);
                }
            }
        }
        catch (IllegalStringException e) {
            throw new WrapperException(e);
        }
        Component parent = (Component)this.getParentTrait();
        Property property = null;
        if (sPrevProperty != null) {
            property = parent.getProperty(sPrevProperty);
        }
        if (sProperty == null) {
            if (property != null && this.isPropertyFromIntegration(property)) {
                property.removeOriginTrait(this);
                parent.removeProperty(property, false);
            }
            Behavior[] accessors = field.getAccessors();
            for (int i = 0; i < accessors.length; ++i) {
                Behavior accessor = accessors[i];
                if (accessor == null) continue;
                this.setBehavior(accessor, null, false);
            }
        } else {
            if (property == null) {
                property = parent.getProperty(sProperty);
                if (property == null) {
                    DataType dt = field.getDataType();
                    int nIndexed = field.getIndexed();
                    boolean fStatic = field.isStatic();
                    property = field.isJavaConstant() ? Property.createJavaConstant(parent, dt, sProperty, nIndexed, fStatic, field.getAccess()) : (field.isCalculatedProperty() ? Property.createCalculatedProperty(parent, dt, sProperty, nIndexed, fStatic) : (field.isFunctionalProperty() ? Property.createFunctionalProperty(parent, dt, sProperty, nIndexed, fStatic) : Property.createProperty(parent, dt, sProperty, nIndexed, fStatic, false)));
                    parent.addProperty(property, false);
                }
                property.setFromIntegration(this, field);
                property.addAccessors();
                property.setFromManual();
            } else {
                property.setName(sProperty, false);
            }
            Behavior[] accessors = field.getAccessors();
            String[] behaviors = this.getAccessorsBehaviors(accessors, sProperty, field.isBooleanGet());
            for (int i = 0; i < behaviors.length; ++i) {
                String behavior = behaviors[i];
                if (behavior == null) continue;
                this.setBehavior(accessors[i], behavior, false);
            }
        }
        this.firePropertyChange(ATTR_INTEGRATION_FIELD, asPrev, sProperty);
    }

    public String[] getImplements() {
        return this.m_tblImplements.strings();
    }

    public Interface getImplements(String sInterface) {
        if (!this.m_tblImplements.contains(sInterface)) {
            return null;
        }
        return this.m_jcs.getImplements(sInterface);
    }

    public String[] getDispatches() {
        return this.m_tblDispatches.strings();
    }

    public Interface getDispatches(String sInterface) {
        if (!this.m_tblDispatches.contains(sInterface)) {
            return null;
        }
        Interface iface = (Interface)this.m_tblDispatches.get(sInterface);
        if (iface == null) {
            iface = this.m_jcs.getImplements(sInterface);
        }
        return iface;
    }

    public String[] getMethodBehavior() {
        return this.m_tblBehaviors.strings();
    }

    public Behavior getMethodBehavior(String sMethod) {
        return this.m_jcs.getBehavior(sMethod);
    }

    public String[] getFieldProperty() {
        return this.m_tblProperties.strings();
    }

    public Property getFieldProperty(String sField) {
        if (!this.m_tblProperties.contains(sField)) {
            return null;
        }
        Property property = (Property)this.m_tblProperties.get(sField);
        if (property == null) {
            property = this.m_jcs.getProperty(sField.substring(0, sField.indexOf(46)));
        }
        return property;
    }

    public void clearJcs() {
        this.m_jcs = null;
        this.m_tblImplements = null;
        this.m_tblDispatches = null;
        this.m_tblBehaviors = null;
        this.m_tblProperties = null;
    }

    public void loadJcs(Loader loader) throws ComponentException {
        int i;
        this.clearJcs();
        this.m_tblImplements = new StringTable();
        this.m_tblDispatches = new StringTable();
        this.m_tblBehaviors = new StringTable();
        this.m_tblProperties = new StringTable();
        if (this.m_sSignature == "") {
            return;
        }
        this.m_jcs = loader.loadSignature(this.m_sSignature);
        if (this.m_jcs == null) {
            return;
        }
        String[] as = this.m_jcs.getBehavior();
        for (i = 0; i < as.length; ++i) {
            String sMethod = as[i];
            if (sMethod.startsWith("<init>")) continue;
            this.m_tblBehaviors.add(as[i]);
        }
        as = this.m_jcs.getProperty();
        for (i = 0; i < as.length; ++i) {
            this.m_tblProperties.add(this.getFieldSignature(this.m_jcs.getProperty(as[i])));
        }
        as = this.m_jcs.getBehavior();
        for (i = 0; i < as.length; ++i) {
            Behavior method = this.m_jcs.getBehavior(as[i]);
            String sVerb = method.getName();
            String sNoun = null;
            for (int ii = 0; ii < sVerb.length(); ++ii) {
                if (Character.isLowerCase(sVerb.charAt(ii))) continue;
                sNoun = sVerb.substring(ii);
                sVerb = sVerb.substring(0, ii);
                break;
            }
            if (sNoun == null) continue;
            DataType dataType = method.getReturnValue().getDataType();
            if (sVerb.equals("is") || sVerb.equals("get")) {
                switch (method.getParameterCount()) {
                    case 0: {
                        this.setupProperty(sNoun, dataType);
                        break;
                    }
                    case 1: {
                        if (method.getParameter(0).getDataType() != DataType.INT) break;
                        this.setupProperty(sNoun, dataType.getArrayType());
                    }
                }
                continue;
            }
            if (dataType == DataType.VOID && sVerb.equals("set")) {
                switch (method.getParameterCount()) {
                    case 1: {
                        this.setupProperty(sNoun, method.getParameter(0).getDataType());
                        break;
                    }
                    case 2: {
                        if (method.getParameter(0).getDataType() != DataType.INT) break;
                        this.setupProperty(sNoun, method.getParameter(1).getDataType().getArrayType());
                    }
                }
                continue;
            }
            if (dataType != DataType.VOID || !sVerb.equals("add") && !sVerb.equals("remove") || !sNoun.endsWith("Listener") || method.getParameterCount() != 1 || !(dataType = method.getParameter(0).getDataType()).isClass() || !this.isEventListener(dataType.getClassName(), loader)) continue;
            this.setupDispatches(dataType);
        }
    }

    private boolean isEventListener(String sClass, Loader loader) {
        if (sClass.equals("java.util.EventListener")) {
            return true;
        }
        try {
            Component component = loader.loadSignature(sClass);
            if (component != null) {
                String[] asImplements = component.getImplements();
                for (int i = 0; i < asImplements.length; ++i) {
                    if (!this.isEventListener(asImplements[i], loader)) continue;
                    return true;
                }
            }
        }
        catch (ComponentException componentException) {
            // empty catch block
        }
        return false;
    }

    private String getFieldSignature(Property field) {
        DataType dataType = field.getDataType();
        if (!field.isSingle()) {
            dataType = dataType.getArrayType();
        }
        return field.getName() + "." + dataType.getTypeString();
    }

    private String[] getAccessorsBehaviors(Behavior[] accessors, String sProperty, boolean fBooleanGet) {
        boolean fAllSet = true;
        boolean fAllClear = true;
        if (sProperty != null) {
            for (int i = 0; i < accessors.length; ++i) {
                Behavior accessor = accessors[i];
                if (accessor == null) continue;
                if (this.getBehavior(accessor.getSignature()) == null) {
                    fAllSet = false;
                    continue;
                }
                fAllClear = false;
            }
        }
        String[] behaviors = new String[accessors.length];
        for (int i = 0; i < accessors.length; ++i) {
            behaviors[i] = null;
            Behavior accessor = accessors[i];
            if (accessor == null) continue;
            String sMethod = accessor.getSignature();
            if (!fAllClear && !fAllSet && this.getBehavior(sMethod) == null) continue;
            behaviors[i] = (switch (sMethod.charAt(0)) {
                case 'g' -> {
                    if (!fBooleanGet) {
                        yield "get";
                    }
                }
                case 'i' -> "is";
                default -> "set";
            }) + sProperty + sMethod.substring(sMethod.indexOf(40));
        }
        return behaviors;
    }

    private void setupProperty(String sProperty, DataType dataType) {
        String sSingleIn;
        String sPropertySignature = sProperty + "." + dataType.getTypeString();
        if (this.m_tblProperties.contains(sPropertySignature)) {
            return;
        }
        boolean fArray = dataType.isArray();
        DataType elementType = fArray ? dataType.getElementType() : dataType;
        boolean fBoolean = (dataType.isArray() ? dataType.getElementType() : dataType) == DataType.BOOLEAN;
        String sOut = fBoolean ? "is" : "get";
        String sSingleOut = sOut + sProperty + "()";
        Behavior method = this.m_jcs.getBehavior(sSingleOut);
        if (method == null || method.getReturnValue().getDataType() != dataType) {
            if (fBoolean) {
                sOut = "get";
                sSingleOut = sOut + sProperty + "()";
                method = this.m_jcs.getBehavior(sSingleOut);
                if (method == null || method.getReturnValue().getDataType() != dataType) {
                    sOut = "is";
                    sSingleOut = null;
                }
            } else {
                sSingleOut = null;
            }
        }
        if ((method = this.m_jcs.getBehavior(sSingleIn = "set" + sProperty + "(" + dataType.getTypeString() + ")")) == null || method.getReturnValue().getDataType() != DataType.VOID) {
            sSingleIn = null;
        }
        String sIndexedOut = null;
        String sIndexedIn = null;
        if (fArray) {
            sIndexedOut = sOut + sProperty + "(I)";
            method = this.m_jcs.getBehavior(sIndexedOut);
            if (!(method != null && method.getReturnValue().getDataType() == elementType || !fBoolean || sSingleOut != null || (method = this.m_jcs.getBehavior(sIndexedOut = (sOut = "get") + sProperty + "(I)")) != null && method.getReturnValue().getDataType() == elementType)) {
                sOut = "is";
                sIndexedOut = null;
            }
            if ((method = this.m_jcs.getBehavior(sIndexedIn = "set" + sProperty + "(I" + elementType.getTypeString() + ")")) == null || method.getReturnValue().getDataType() != DataType.VOID) {
                sIndexedIn = null;
            }
        }
        int iType = 0;
        int nProp = 0;
        if (sSingleOut != null && sSingleIn != null) {
            iType = 1;
            if (sIndexedOut == null || sIndexedIn == null) {
                nProp = 0x10000000;
                sIndexedOut = null;
                sIndexedIn = null;
            } else {
                nProp = 0x30000000;
            }
        } else if (sIndexedOut != null && sIndexedIn != null) {
            iType = 1;
            nProp = 0x20000000;
            sSingleOut = null;
            sSingleIn = null;
        } else if (sSingleOut != null) {
            if (sIndexedIn == null) {
                iType = 2;
                nProp = sIndexedOut == null ? 0x10000000 : 0x30000000;
            }
        } else if (sSingleIn != null) {
            if (sIndexedOut == null) {
                iType = 3;
                nProp = sIndexedIn == null ? 0x10000000 : 0x30000000;
            }
        } else if (sIndexedOut != null) {
            iType = 2;
            nProp = 0x20000000;
        } else if (sIndexedIn != null) {
            iType = 3;
            nProp = 0x20000000;
        }
        if (nProp == 0x10000000 && fArray) {
            elementType = dataType;
        }
        Property property = null;
        switch (iType) {
            case 1: {
                property = Property.createProperty(this.m_jcs, elementType, sProperty, nProp, false, false);
                break;
            }
            case 2: {
                property = Property.createCalculatedProperty(this.m_jcs, elementType, sProperty, nProp, false);
                break;
            }
            case 3: {
                property = Property.createFunctionalProperty(this.m_jcs, elementType, sProperty, nProp, false);
            }
        }
        if (property != null) {
            if (fBoolean && sOut.equals("get")) {
                property.setBooleanGet(true);
            }
            this.m_tblProperties.put(sPropertySignature, property);
            if (sSingleOut != null) {
                this.m_tblBehaviors.remove(sSingleOut);
            }
            if (sSingleIn != null) {
                this.m_tblBehaviors.remove(sSingleIn);
            }
            if (sIndexedOut != null) {
                this.m_tblBehaviors.remove(sIndexedOut);
            }
            if (sIndexedIn != null) {
                this.m_tblBehaviors.remove(sIndexedIn);
            }
        }
    }

    private boolean isPropertyFromIntegration(String sProperty) {
        Property property = ((Component)this.getParentTrait()).getProperty(sProperty);
        if (property == null) {
            return false;
        }
        return this.isPropertyFromIntegration(property);
    }

    private boolean isPropertyFromIntegration(Property property) {
        if (property.isFromIntegration()) {
            return true;
        }
        Behavior[] accessors = property.getAccessors();
        for (int i = 0; i < accessors.length; ++i) {
            Behavior accessor = accessors[i];
            if (accessor == null || !accessor.isFromIntegration()) continue;
            return true;
        }
        return false;
    }

    private void setupDispatches(DataType dataType) {
        Enumeration enmrProperties;
        Enumeration enmrBehaviors;
        String className = dataType.getClassName();
        if (this.m_tblDispatches.get(className) != null) {
            return;
        }
        String name = className.substring(className.lastIndexOf(46) + 1) + "(L" + className + ";)";
        String sAdd = "add" + name;
        Behavior method = this.m_jcs.getBehavior(sAdd);
        if (method == null || method.getReturnValue().getDataType() != DataType.VOID || method.getParameterCount() != 1 || method.getParameter(0).getDataType() != dataType) {
            return;
        }
        String sRemove = "remove" + name;
        method = this.m_jcs.getBehavior(sRemove);
        if (method == null || method.getReturnValue().getDataType() != DataType.VOID || method.getParameterCount() != 1 || method.getParameter(0).getDataType() != dataType) {
            return;
        }
        Interface iface = this.m_jcs.getImplements(className);
        if (iface != null) {
            enmrBehaviors = iface.getBehaviors();
            enmrProperties = iface.getProperties();
        } else {
            enmrBehaviors = NullImplementation.getEnumeration();
            enmrProperties = NullImplementation.getEnumeration();
        }
        iface = new Interface(this.m_jcs, className, 2, new ChainedEnumerator(enmrBehaviors, new SimpleEnumerator<Object>(new Object[]{sAdd, sRemove})), enmrProperties);
        this.m_tblDispatches.put(className, iface);
        this.m_tblBehaviors.remove(sAdd);
        this.m_tblBehaviors.remove(sRemove);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Integration)) {
            return false;
        }
        Integration that = (Integration)obj;
        if (this == that) {
            return true;
        }
        return super.equals(that) && this.m_sPrevSignature.equals(that.m_sPrevSignature) && this.m_sSignature.equals(that.m_sSignature) && this.m_sPrevModel.equals(that.m_sPrevModel) && this.m_sModel.equals(that.m_sModel) && this.m_sPrevMisc.equals(that.m_sPrevMisc) && this.m_sMisc.equals(that.m_sMisc) && this.m_mapMethod.equals(that.m_mapMethod) && this.m_mapField.equals(that.m_mapField);
    }

    @Override
    protected synchronized void invalidate() {
        super.invalidate();
        this.m_sPrevSignature = null;
        this.m_sSignature = null;
        this.m_sPrevModel = null;
        this.m_sModel = null;
        this.m_sPrevMisc = null;
        this.m_sMisc = null;
        this.m_mapPrevMethod = null;
        this.m_mapMethod = null;
        this.m_mapPrevField = null;
        this.m_mapField = null;
        this.m_jcs = null;
    }

    @Override
    public void dump() {
        this.dump(Integration.getOut(), "");
    }

    @Override
    public void dump(PrintWriter out, String sIndent) {
        this.dump(out, sIndent, true);
    }

    public void dump(PrintWriter out, String sIndent, boolean fIndentFirstLine) {
        if (fIndentFirstLine) {
            out.print(sIndent);
        }
        out.println("PrevSignature=" + this.m_sPrevSignature);
        out.println(sIndent + "Signature=" + this.m_sSignature);
        out.println(sIndent + "PrevModel=" + this.m_sPrevModel);
        out.println(sIndent + "Model=" + this.m_sModel);
        out.println(sIndent + "PrevMisc=" + this.m_sPrevMisc);
        out.println(sIndent + "Misc=" + this.m_sMisc);
        super.dump(out, sIndent);
        Integration.out();
        this.dump(out, sIndent + "  ", this.m_mapPrevMethod, this.m_mapMethod, "Java Method", "Behavior");
        Integration.out();
        this.dump(out, sIndent + "  ", this.m_mapPrevField, this.m_mapField, "Java Field", "Property");
    }

    private void dump(PrintWriter out, String sIndent, StringMap mapPrev, StringMap map, String sCol1, String sCol2) {
        ChainedEnumerator enmr1 = new ChainedEnumerator(mapPrev.primaryStrings(), map.primaryStrings());
        ChainedEnumerator enmr2 = new ChainedEnumerator(mapPrev.secondaryStrings(), map.secondaryStrings());
        int cch1 = sCol1.length();
        int cch2 = sCol2.length();
        try {
            while (true) {
                String s2;
                String s1;
                if ((s1 = (String)enmr1.nextElement()).length() > cch1) {
                    cch1 = s1.length();
                }
                if ((s2 = (String)enmr2.nextElement()) == null) {
                    s2 = NULL_STRING;
                } else if (s2 == s1) {
                    s2 = EQUAL_STRING;
                }
                if (s2.length() <= cch2) continue;
                cch2 = s2.length();
            }
        }
        catch (NoSuchElementException s1) {
            int cchMax = cch1 > cch2 ? cch1 : cch2;
            char[] achSpc = new char[cchMax];
            char[] achDiv = new char[cchMax];
            for (int i = 0; i < cchMax; ++i) {
                achSpc[i] = 32;
                achDiv[i] = 45;
            }
            String sSpc = new String(achSpc);
            String sDiv = new String(achDiv);
            String sDiv1 = sDiv.substring(0, cch1);
            String sDiv2 = sDiv.substring(0, cch2);
            out.println(sIndent + (sCol1 + sSpc).substring(0, cch1) + "  " + (sCol2 + sSpc).substring(0, cch2) + "  Type");
            out.println(sIndent + sDiv1 + "  " + sDiv2 + "  ---------");
            enmr1 = new ChainedEnumerator(mapPrev.primaryStrings(), map.primaryStrings());
            enmr2 = new ChainedEnumerator(mapPrev.secondaryStrings(), map.secondaryStrings());
            try {
                while (true) {
                    String s12 = (String)enmr1.nextElement();
                    String s2 = (String)enmr2.nextElement();
                    if (s2 == null) {
                        s2 = NULL_STRING;
                    } else if (s2 == s12) {
                        s2 = EQUAL_STRING;
                    }
                    out.println(sIndent + (s12 + sSpc).substring(0, cch1) + "  " + (s2 + sSpc).substring(0, cch2) + "  " + (mapPrev.contains(s12) ? "Inherited" : "Local"));
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return;
            }
        }
    }
}

