/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentException;
import com.tangosol.dev.component.Resolver;
import com.tangosol.dev.component.Storage;
import com.tangosol.dev.component.Trait;
import com.tangosol.util.ErrorList;
import com.tangosol.util.StringTable;
import java.io.IOException;

public class Extractor
extends Resolver
implements Storage {
    private static final String CLASS = "Extractor";
    private Storage m_storage;

    public Extractor(Storage storage) {
        this(storage, null);
    }

    public Extractor(Storage storage, String sPkg) {
        super(storage, sPkg);
        this.m_storage = storage;
    }

    @Override
    public void storeComponent(Component cd, ErrorList errlist) throws ComponentException {
        if (Trait.DEBUG) {
            Extractor.out();
            Extractor.out("***Extractor*** Component to store:");
            cd.dump();
        }
        if (cd.getMode() != 1) {
            throw new ComponentException("Extractor.storeComponent:  Invalid mode " + String.valueOf(cd) + " (" + cd.getMode() + ")");
        }
        if (cd.getQualifiedName().length() > 0) {
            Component cdSuper = cd.isInterface() ? new Component(null, 2, "") : this.loadComponent(cd.getSuperName(), true, errlist);
            Extractor.azzert(cdSuper != null, "Failed to load the super component: \"" + cd.getSuperName() + "\"");
            if (Trait.DEBUG) {
                Extractor.out();
                Extractor.out("***Extractor*** Super before extract:");
                cdSuper.dump();
            }
            cd = cd.extract(cdSuper, this, errlist);
            if (Trait.DEBUG) {
                Extractor.out();
                Extractor.out("***Extractor*** Component after extract:");
                cd.dump();
            }
        }
        this.m_storage.storeComponent(cd, errlist);
    }

    @Override
    public void removeComponent(String sName) throws ComponentException {
        this.m_storage.removeComponent(sName);
    }

    @Override
    public void storeSignature(Component signature) throws ComponentException {
        boolean fResolvable = signature.getSuperName().length() == 0 && !signature.isInterface();
        switch (signature.getMode()) {
            case 1: {
                if (fResolvable) break;
                throw new ComponentException("Extractor.storeSignature:  Invalid mode " + String.valueOf(signature) + " (" + signature.getMode() + ")");
            }
            case 2: {
                if (!fResolvable) break;
                throw new ComponentException("Extractor.storeSignature:  Invalid mode " + String.valueOf(signature) + " (" + signature.getMode() + ")");
            }
            default: {
                throw new ComponentException("Extractor.storeSignature:  Invalid mode " + String.valueOf(signature) + " (" + signature.getMode() + ")");
            }
        }
        this.m_storage.storeSignature(signature);
    }

    @Override
    public void storeClass(ClassFile clz, String sListing) throws ComponentException {
        this.m_storage.storeClass(clz, sListing);
    }

    @Override
    public void storeResourceSignature(String sName, byte[] abData) throws IOException {
        this.m_storage.storeResourceSignature(sName, abData);
    }

    @Override
    public void removeResourceSignature(String sName) throws IOException {
        this.m_storage.removeResourceSignature(sName);
    }

    @Override
    public void storeResource(String sName, byte[] abData) throws IOException {
        this.m_storage.storeResource(sName, abData);
    }

    @Override
    public StringTable getSubComponents(String sComponent, boolean fQualify) {
        return this.m_storage.getSubComponents(sComponent, fQualify);
    }

    @Override
    public StringTable getPackageComponents(String sPackage, boolean fQualify) {
        return this.m_storage.getPackageComponents(sPackage, fQualify);
    }

    @Override
    public StringTable getComponentPackages(String sPackage, boolean fQualify, boolean fSubs) {
        return this.m_storage.getComponentPackages(sPackage, fQualify, fSubs);
    }

    @Override
    public StringTable getPackageSignatures(String sPackage, boolean fQualify) {
        return this.m_storage.getPackageSignatures(sPackage, fQualify);
    }

    @Override
    public StringTable getSignaturePackages(String sPackage, boolean fQualify, boolean fSubs) {
        return this.m_storage.getSignaturePackages(sPackage, fQualify, fSubs);
    }

    @Override
    public StringTable getPackageResources(String sPackage, boolean fQualify) {
        return this.m_storage.getPackageResources(sPackage, fQualify);
    }

    @Override
    public StringTable getResourcePackages(String sPackage, boolean fQualify, boolean fSubs) {
        return this.m_storage.getResourcePackages(sPackage, fQualify, fSubs);
    }

    @Override
    public String toString() {
        return "Extractor(" + String.valueOf(this.m_storage) + ")";
    }
}

