/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.component;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.component.Component;
import com.tangosol.dev.component.ComponentType;
import com.tangosol.dev.component.Constants;
import com.tangosol.java.type.ArrayType;
import com.tangosol.java.type.ClassType;
import com.tangosol.java.type.PrimitiveType;
import com.tangosol.java.type.ReferenceType;
import com.tangosol.java.type.Type;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class DataType
extends Base
implements Constants {
    private static final String CLASS = "DataType";
    private static Hashtable sm_tblTypes = new Hashtable();
    public static final DataType UNKNOWN = DataType.getType("U");
    public static final DataType NULL = DataType.getType("N");
    public static final DataType VOID = DataType.getType("V");
    public static final DataType BOOLEAN = DataType.getType("Z");
    public static final DataType BYTE = DataType.getType("B");
    public static final DataType CHAR = DataType.getType("C");
    public static final DataType SHORT = DataType.getType("S");
    public static final DataType INT = DataType.getType("I");
    public static final DataType LONG = DataType.getType("J");
    public static final DataType FLOAT = DataType.getType("F");
    public static final DataType DOUBLE = DataType.getType("D");
    public static final DataType OBJECT = DataType.getClassType(Object.class);
    public static final DataType STRING = DataType.getClassType(String.class);
    public static final DataType BINARY = DataType.getArrayType(BYTE);
    public static final DataType COMPLEX = DataType.getComponentType(Component.getRootName());
    public static final DataType SERIALIZABLE = DataType.getClassType(Serializable.class);
    public static final DataType CLONEABLE = DataType.getClassType(Cloneable.class);
    public static final DataType THROWABLE = DataType.getClassType(Throwable.class);
    public static final DataType ERROR = DataType.getClassType(Error.class);
    public static final DataType EXCEPTION = DataType.getClassType(Exception.class);
    public static final DataType RUNTIME = DataType.getClassType(RuntimeException.class);
    private Type m_type;

    private DataType(Type type) {
        this.m_type = type;
    }

    public static DataType getClassType(Class clz) {
        DataType.azzert(clz != null);
        if (clz.isArray()) {
            return DataType.getClassType(clz.getComponentType()).getArrayType();
        }
        if (clz.isPrimitive()) {
            if (clz == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (clz == Character.TYPE) {
                return CHAR;
            }
            if (clz == Byte.TYPE) {
                return BYTE;
            }
            if (clz == Short.TYPE) {
                return SHORT;
            }
            if (clz == Integer.TYPE) {
                return INT;
            }
            if (clz == Long.TYPE) {
                return LONG;
            }
            if (clz == Float.TYPE) {
                return FLOAT;
            }
            if (clz == Double.TYPE) {
                return DOUBLE;
            }
            if (clz == Void.TYPE) {
                return VOID;
            }
            throw new IllegalArgumentException("DataType.getClassType:  Primitive type (" + clz.getName() + ") is not known!");
        }
        return DataType.getClassType(clz.getName());
    }

    public static DataType getClassType(String sName) {
        DataType.azzert(sName != null);
        DataType.azzert(ClassHelper.isQualifiedNameLegal(sName), "Illegal class name: \"" + sName + "\"");
        return DataType.getType("L" + sName + ";");
    }

    public static DataType getComponentType(String sName) {
        DataType.azzert(sName != null);
        DataType.azzert(Component.isQualifiedNameLegal(sName), "Illegal component name: \"" + sName + "\"");
        return DataType.getType("R" + sName + ";");
    }

    public static DataType getArrayType(DataType dtElement) {
        DataType.azzert(dtElement != null);
        return dtElement.getArrayType();
    }

    public static DataType getJVMType(String sType) {
        switch (sType.length()) {
            case 0: {
                throw new IllegalArgumentException("DataType.getJVMType:  JVM Type Signature required!");
            }
            case 1: {
                switch (sType.charAt(0)) {
                    case 'V': {
                        return VOID;
                    }
                    case 'Z': {
                        return BOOLEAN;
                    }
                    case 'B': {
                        return BYTE;
                    }
                    case 'C': {
                        return CHAR;
                    }
                    case 'S': {
                        return SHORT;
                    }
                    case 'I': {
                        return INT;
                    }
                    case 'J': {
                        return LONG;
                    }
                    case 'F': {
                        return FLOAT;
                    }
                    case 'D': {
                        return DOUBLE;
                    }
                }
                throw new IllegalArgumentException("DataType.getJVMType:  Illegal JVM Type Signature:  " + sType);
            }
        }
        switch (sType.charAt(0)) {
            case '[': {
                return DataType.getJVMType(sType.substring(1)).getArrayType();
            }
            case 'L': {
                String sName;
                sType = sType.substring(1, sType.length() - 1);
                if (sType.startsWith("_package/") && Component.isQualifiedNameLegal(sName = DataType.getComponentName(sType))) {
                    return DataType.getComponentType(sName);
                }
                return DataType.getClassType(sType.replace('/', '.'));
            }
            case 'R': {
                sType = sType.substring(1, sType.length() - 1);
                return DataType.getComponentType(DataType.getComponentName(sType));
            }
        }
        throw new IllegalArgumentException("DataType.getJVMType:  Illegal JVM Type Signature:  " + sType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataType getDataType(Type type) {
        DataType dt;
        Hashtable map = sm_tblTypes;
        String sType = DataType.toTypeString(type);
        Hashtable hashtable = map;
        synchronized (hashtable) {
            dt = (DataType)map.get(sType);
            if (dt == null) {
                dt = new DataType(type);
                map.put(sType, dt);
            }
        }
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataType getType(String sType) {
        DataType dt;
        Hashtable map;
        Hashtable hashtable = map = sm_tblTypes;
        synchronized (hashtable) {
            dt = (DataType)map.get(sType);
            if (dt == null) {
                Type type;
                switch (sType.charAt(0)) {
                    case '[': {
                        int cDepth = 1;
                        int of = 1;
                        while (sType.charAt(of) == '[') {
                            ++cDepth;
                            ++of;
                        }
                        type = DataType.getType(sType.substring(cDepth)).getType();
                        for (int i = 0; i < cDepth; ++i) {
                            type = type.getArrayType();
                        }
                        break;
                    }
                    case 'R': {
                        type = new ComponentType(sType.substring(1, sType.length() - 1));
                        break;
                    }
                    case 'U': {
                        type = Type.UNKNOWN;
                        break;
                    }
                    case 'N': {
                        type = Type.NULL;
                        break;
                    }
                    default: {
                        type = Type.parseSignature(sType);
                    }
                }
                dt = new DataType(type);
                map.put(sType, dt);
            }
        }
        return dt;
    }

    public boolean isPrimitive() {
        return this.getType() instanceof PrimitiveType;
    }

    public boolean isNumeric() {
        Type type = this.getType();
        return type instanceof PrimitiveType && ((PrimitiveType)type).isNumeric();
    }

    public boolean isIntegral() {
        Type type = this.getType();
        return type instanceof PrimitiveType && ((PrimitiveType)type).isIntegral();
    }

    public boolean isFloatingPoint() {
        Type type = this.getType();
        return type instanceof PrimitiveType && ((PrimitiveType)type).isFloatingPoint();
    }

    public boolean isReference() {
        return this.getType() instanceof ReferenceType;
    }

    public boolean isExtendedSimple() {
        return this == STRING || this.isPrimitive();
    }

    public boolean isClass() {
        Type type = this.getType();
        return type instanceof ClassType && !(type instanceof ComponentType);
    }

    public boolean isComponent() {
        return this.getType() instanceof ComponentType;
    }

    public boolean isArray() {
        return this.getType() instanceof ArrayType;
    }

    public Type getType() {
        return this.m_type;
    }

    public String getTypeString() {
        return DataType.toTypeString(this.getType());
    }

    public DataType getArrayType() {
        DataType.azzert(this != NULL && this != VOID);
        if (this == UNKNOWN) {
            return this;
        }
        return DataType.getType("[" + this.getTypeString());
    }

    public String getClassName() {
        Type type = this.getType();
        DataType.azzert(type instanceof ClassType, "Invalid type: " + String.valueOf(type));
        return ((ClassType)type).getClassName();
    }

    public String getComponentName() {
        DataType.azzert(this.isComponent());
        return ((ComponentType)this.getType()).getComponentName();
    }

    public DataType getElementType() {
        if (this == UNKNOWN) {
            return this;
        }
        DataType.azzert(this.isArray());
        return DataType.getDataType(((ArrayType)this.getType()).getElementType());
    }

    public DataType getBaseElementType() {
        DataType dt = this.getElementType();
        while (dt.isArray()) {
            dt = dt.getElementType();
        }
        return dt;
    }

    public String getJVMSignature() {
        return this.getType().getSignature();
    }

    public ClassConstant getClassConstant() {
        if (this.isPrimitive() || this.isArray()) {
            return new ClassConstant(this.getJVMSignature());
        }
        if (this == NULL) {
            return OBJECT.getClassConstant();
        }
        return new ClassConstant(this.getClassName());
    }

    public static DataType[] parseSignature(String sSig) {
        String sRet;
        char[] ach = sSig.toCharArray();
        int of = 0;
        while (ach[of++] != '(') {
        }
        Vector<DataType> vect = new Vector<DataType>();
        vect.add(null);
        while (ach[of] != ')') {
            int cch = DataType.parseTypeLength(ach, of);
            vect.addElement(DataType.getJVMType(new String(ach, of, cch)));
            of += cch;
        }
        if ((sRet = new String(ach, ++of, ach.length - of)).length() > 0) {
            vect.set(0, DataType.getJVMType(sRet));
        }
        Object[] adt = new DataType[vect.size()];
        vect.copyInto(adt);
        return adt;
    }

    private static int parseTypeLength(char[] ach, int of) {
        switch (ach[of]) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1;
            }
            case '[': {
                int cch = 1;
                while (DataType.isDecimal(ach[++of])) {
                    ++cch;
                }
                return cch + DataType.parseTypeLength(ach, of);
            }
            case 'L': 
            case 'R': {
                int cch = 2;
                while (ach[++of] != ';') {
                    ++cch;
                }
                return cch;
            }
        }
        throw new IllegalArgumentException("DataType.parseTypeLength:  JVM Type Signature cannot start with '" + ach[of] + "'");
    }

    public static String toTypeString(Type type) {
        if (type instanceof ArrayType) {
            return "[" + DataType.toTypeString(((ArrayType)type).getElementType());
        }
        if (type instanceof ComponentType) {
            return "R" + ((ComponentType)type).getComponentName() + ";";
        }
        return type.getSignature().replace('/', '.');
    }

    public static String getComponentClassName(Component cd) {
        return ComponentType.getComponentClassName(cd);
    }

    public static String getComponentClassName(String sName) {
        return ComponentType.getComponentClassName(sName);
    }

    public static String getComponentPackage(Component cd) {
        return ComponentType.getComponentPackage(cd);
    }

    public static String getComponentPackage(String sName) {
        return ComponentType.getComponentPackage(sName);
    }

    public static String getComponentName(String sClassName) {
        return ComponentType.getComponentName(sClassName);
    }

    public String toString() {
        return this.getType().toString();
    }
}

